/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.SignalDecisionOutcome;
import com.plaid.client.model.SignalPaymentMethod;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SignalDecisionReportRequest defines the request schema for `/signal/decision/report`")
public class SignalDecisionReportRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CLIENT_TRANSACTION_ID = "client_transaction_id";
    @SerializedName(value="client_transaction_id")
    private String clientTransactionId;
    public static final String SERIALIZED_NAME_INITIATED = "initiated";
    @SerializedName(value="initiated")
    private Boolean initiated;
    public static final String SERIALIZED_NAME_DAYS_FUNDS_ON_HOLD = "days_funds_on_hold";
    @SerializedName(value="days_funds_on_hold")
    private Integer daysFundsOnHold;
    public static final String SERIALIZED_NAME_DECISION_OUTCOME = "decision_outcome";
    @SerializedName(value="decision_outcome")
    private SignalDecisionOutcome decisionOutcome;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD = "payment_method";
    @SerializedName(value="payment_method")
    private SignalPaymentMethod paymentMethod;
    public static final String SERIALIZED_NAME_AMOUNT_INSTANTLY_AVAILABLE = "amount_instantly_available";
    @SerializedName(value="amount_instantly_available")
    private Double amountInstantlyAvailable;

    public SignalDecisionReportRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SignalDecisionReportRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SignalDecisionReportRequest clientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="Must be the same as the `client_transaction_id` supplied when calling `/signal/evaluate`")
    public String getClientTransactionId() {
        return this.clientTransactionId;
    }

    public void setClientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
    }

    public SignalDecisionReportRequest initiated(Boolean initiated) {
        this.initiated = initiated;
        return this;
    }

    @ApiModelProperty(required=true, value="`true` if the ACH transaction was initiated, `false` otherwise.  This field must be returned as a boolean. If formatted incorrectly, this will result in an [`INVALID_FIELD`](/docs/errors/invalid-request/#invalid_field) error.")
    public Boolean getInitiated() {
        return this.initiated;
    }

    public void setInitiated(Boolean initiated) {
        this.initiated = initiated;
    }

    public SignalDecisionReportRequest daysFundsOnHold(Integer daysFundsOnHold) {
        this.daysFundsOnHold = daysFundsOnHold;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The actual number of days (hold time) since the ACH debit transaction that you wait before making funds available to your customers. The holding time could affect the ACH return rate.  For example, use 0 if you make funds available to your customers instantly or the same day following the debit transaction, or 1 if you make funds available the next day following the debit initialization.")
    public Integer getDaysFundsOnHold() {
        return this.daysFundsOnHold;
    }

    public void setDaysFundsOnHold(Integer daysFundsOnHold) {
        this.daysFundsOnHold = daysFundsOnHold;
    }

    public SignalDecisionReportRequest decisionOutcome(SignalDecisionOutcome decisionOutcome) {
        this.decisionOutcome = decisionOutcome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SignalDecisionOutcome getDecisionOutcome() {
        return this.decisionOutcome;
    }

    public void setDecisionOutcome(SignalDecisionOutcome decisionOutcome) {
        this.decisionOutcome = decisionOutcome;
    }

    public SignalDecisionReportRequest paymentMethod(SignalPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SignalPaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(SignalPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public SignalDecisionReportRequest amountInstantlyAvailable(Double amountInstantlyAvailable) {
        this.amountInstantlyAvailable = amountInstantlyAvailable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount (in USD) made available to your customers instantly following the debit transaction. It could be a partial amount of the requested transaction (example: 102.05).")
    public Double getAmountInstantlyAvailable() {
        return this.amountInstantlyAvailable;
    }

    public void setAmountInstantlyAvailable(Double amountInstantlyAvailable) {
        this.amountInstantlyAvailable = amountInstantlyAvailable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalDecisionReportRequest signalDecisionReportRequest = (SignalDecisionReportRequest)o;
        return Objects.equals(this.clientId, signalDecisionReportRequest.clientId) && Objects.equals(this.secret, signalDecisionReportRequest.secret) && Objects.equals(this.clientTransactionId, signalDecisionReportRequest.clientTransactionId) && Objects.equals(this.initiated, signalDecisionReportRequest.initiated) && Objects.equals(this.daysFundsOnHold, signalDecisionReportRequest.daysFundsOnHold) && Objects.equals((Object)this.decisionOutcome, (Object)signalDecisionReportRequest.decisionOutcome) && Objects.equals((Object)this.paymentMethod, (Object)signalDecisionReportRequest.paymentMethod) && Objects.equals(this.amountInstantlyAvailable, signalDecisionReportRequest.amountInstantlyAvailable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.clientTransactionId, this.initiated, this.daysFundsOnHold, this.decisionOutcome, this.paymentMethod, this.amountInstantlyAvailable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalDecisionReportRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    clientTransactionId: ").append(this.toIndentedString(this.clientTransactionId)).append("\n");
        sb.append("    initiated: ").append(this.toIndentedString(this.initiated)).append("\n");
        sb.append("    daysFundsOnHold: ").append(this.toIndentedString(this.daysFundsOnHold)).append("\n");
        sb.append("    decisionOutcome: ").append(this.toIndentedString((Object)this.decisionOutcome)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString((Object)this.paymentMethod)).append("\n");
        sb.append("    amountInstantlyAvailable: ").append(this.toIndentedString(this.amountInstantlyAvailable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

