/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details about the end user's device. When calling `/signal/evaluate` or `/signal/processor/evaluate`, this field is optional, but strongly recommended to increase the accuracy of Signal results.")
public class SignalDevice {
    public static final String SERIALIZED_NAME_IP_ADDRESS = "ip_address";
    @SerializedName(value="ip_address")
    private String ipAddress;
    public static final String SERIALIZED_NAME_USER_AGENT = "user_agent";
    @SerializedName(value="user_agent")
    private String userAgent;

    public SignalDevice ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The IP address of the device that initiated the transaction")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public SignalDevice userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user agent of the device that initiated the transaction (e.g. \"Mozilla/5.0\")")
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalDevice signalDevice = (SignalDevice)o;
        return Objects.equals(this.ipAddress, signalDevice.ipAddress) && Objects.equals(this.userAgent, signalDevice.userAgent);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.userAgent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalDevice {\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

