/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The core attributes object contains additional data that can be used to assess the ACH return risk. Examples of data include:  `days_since_first_plaid_connection`: The number of days since the first time the Item was connected to an application via Plaid `plaid_connections_count_7d`: The number of times the Item has been connected to applications via Plaid over the past 7 days `plaid_connections_count_30d`: The number of times the Item has been connected to applications via Plaid over the past 30 days `total_plaid_connections_count`: The number of times the Item has been connected to applications via Plaid `is_savings_or_money_market_account`: Indicates whether the ACH transaction funding account is a savings/money market account  For the full list and detailed documentation of core attributes available, or to request that core attributes not be returned, contact Sales or your Plaid account manager")
public class SignalEvaluateCoreAttributes {
    public static final String SERIALIZED_NAME_UNAUTHORIZED_TRANSACTIONS_COUNT7D = "unauthorized_transactions_count_7d";
    @SerializedName(value="unauthorized_transactions_count_7d")
    private Integer unauthorizedTransactionsCount7d;
    public static final String SERIALIZED_NAME_UNAUTHORIZED_TRANSACTIONS_COUNT30D = "unauthorized_transactions_count_30d";
    @SerializedName(value="unauthorized_transactions_count_30d")
    private Integer unauthorizedTransactionsCount30d;
    public static final String SERIALIZED_NAME_UNAUTHORIZED_TRANSACTIONS_COUNT60D = "unauthorized_transactions_count_60d";
    @SerializedName(value="unauthorized_transactions_count_60d")
    private Integer unauthorizedTransactionsCount60d;
    public static final String SERIALIZED_NAME_UNAUTHORIZED_TRANSACTIONS_COUNT90D = "unauthorized_transactions_count_90d";
    @SerializedName(value="unauthorized_transactions_count_90d")
    private Integer unauthorizedTransactionsCount90d;
    public static final String SERIALIZED_NAME_NSF_OVERDRAFT_TRANSACTIONS_COUNT7D = "nsf_overdraft_transactions_count_7d";
    @SerializedName(value="nsf_overdraft_transactions_count_7d")
    private Integer nsfOverdraftTransactionsCount7d;
    public static final String SERIALIZED_NAME_NSF_OVERDRAFT_TRANSACTIONS_COUNT30D = "nsf_overdraft_transactions_count_30d";
    @SerializedName(value="nsf_overdraft_transactions_count_30d")
    private Integer nsfOverdraftTransactionsCount30d;
    public static final String SERIALIZED_NAME_NSF_OVERDRAFT_TRANSACTIONS_COUNT60D = "nsf_overdraft_transactions_count_60d";
    @SerializedName(value="nsf_overdraft_transactions_count_60d")
    private Integer nsfOverdraftTransactionsCount60d;
    public static final String SERIALIZED_NAME_NSF_OVERDRAFT_TRANSACTIONS_COUNT90D = "nsf_overdraft_transactions_count_90d";
    @SerializedName(value="nsf_overdraft_transactions_count_90d")
    private Integer nsfOverdraftTransactionsCount90d;
    public static final String SERIALIZED_NAME_DAYS_SINCE_FIRST_PLAID_CONNECTION = "days_since_first_plaid_connection";
    @SerializedName(value="days_since_first_plaid_connection")
    private Integer daysSinceFirstPlaidConnection;
    public static final String SERIALIZED_NAME_PLAID_CONNECTIONS_COUNT7D = "plaid_connections_count_7d";
    @SerializedName(value="plaid_connections_count_7d")
    private Integer plaidConnectionsCount7d;
    public static final String SERIALIZED_NAME_PLAID_CONNECTIONS_COUNT30D = "plaid_connections_count_30d";
    @SerializedName(value="plaid_connections_count_30d")
    private Integer plaidConnectionsCount30d;
    public static final String SERIALIZED_NAME_TOTAL_PLAID_CONNECTIONS_COUNT = "total_plaid_connections_count";
    @SerializedName(value="total_plaid_connections_count")
    private Integer totalPlaidConnectionsCount;
    public static final String SERIALIZED_NAME_IS_SAVINGS_OR_MONEY_MARKET_ACCOUNT = "is_savings_or_money_market_account";
    @SerializedName(value="is_savings_or_money_market_account")
    private Boolean isSavingsOrMoneyMarketAccount;
    public static final String SERIALIZED_NAME_TOTAL_CREDIT_TRANSACTIONS_AMOUNT10D = "total_credit_transactions_amount_10d";
    @SerializedName(value="total_credit_transactions_amount_10d")
    private Double totalCreditTransactionsAmount10d;
    public static final String SERIALIZED_NAME_TOTAL_DEBIT_TRANSACTIONS_AMOUNT10D = "total_debit_transactions_amount_10d";
    @SerializedName(value="total_debit_transactions_amount_10d")
    private Double totalDebitTransactionsAmount10d;
    public static final String SERIALIZED_NAME_P50_CREDIT_TRANSACTIONS_AMOUNT28D = "p50_credit_transactions_amount_28d";
    @SerializedName(value="p50_credit_transactions_amount_28d")
    private Double p50CreditTransactionsAmount28d;
    public static final String SERIALIZED_NAME_P50_DEBIT_TRANSACTIONS_AMOUNT28D = "p50_debit_transactions_amount_28d";
    @SerializedName(value="p50_debit_transactions_amount_28d")
    private Double p50DebitTransactionsAmount28d;
    public static final String SERIALIZED_NAME_P95_CREDIT_TRANSACTIONS_AMOUNT28D = "p95_credit_transactions_amount_28d";
    @SerializedName(value="p95_credit_transactions_amount_28d")
    private Double p95CreditTransactionsAmount28d;
    public static final String SERIALIZED_NAME_P95_DEBIT_TRANSACTIONS_AMOUNT28D = "p95_debit_transactions_amount_28d";
    @SerializedName(value="p95_debit_transactions_amount_28d")
    private Double p95DebitTransactionsAmount28d;
    public static final String SERIALIZED_NAME_DAYS_WITH_NEGATIVE_BALANCE_COUNT90D = "days_with_negative_balance_count_90d";
    @SerializedName(value="days_with_negative_balance_count_90d")
    private Integer daysWithNegativeBalanceCount90d;
    public static final String SERIALIZED_NAME_P90_EOD_BALANCE30D = "p90_eod_balance_30d";
    @SerializedName(value="p90_eod_balance_30d")
    private Double p90EodBalance30d;
    public static final String SERIALIZED_NAME_P90_EOD_BALANCE60D = "p90_eod_balance_60d";
    @SerializedName(value="p90_eod_balance_60d")
    private Double p90EodBalance60d;
    public static final String SERIALIZED_NAME_P90_EOD_BALANCE90D = "p90_eod_balance_90d";
    @SerializedName(value="p90_eod_balance_90d")
    private Double p90EodBalance90d;
    public static final String SERIALIZED_NAME_P10_EOD_BALANCE30D = "p10_eod_balance_30d";
    @SerializedName(value="p10_eod_balance_30d")
    private Double p10EodBalance30d;
    public static final String SERIALIZED_NAME_P10_EOD_BALANCE60D = "p10_eod_balance_60d";
    @SerializedName(value="p10_eod_balance_60d")
    private Double p10EodBalance60d;
    public static final String SERIALIZED_NAME_P10_EOD_BALANCE90D = "p10_eod_balance_90d";
    @SerializedName(value="p10_eod_balance_90d")
    private Double p10EodBalance90d;
    public static final String SERIALIZED_NAME_AVAILABLE_BALANCE = "available_balance";
    @SerializedName(value="available_balance")
    private Double availableBalance;
    public static final String SERIALIZED_NAME_CURRENT_BALANCE = "current_balance";
    @SerializedName(value="current_balance")
    private Double currentBalance;
    public static final String SERIALIZED_NAME_BALANCE_LAST_UPDATED = "balance_last_updated";
    @SerializedName(value="balance_last_updated")
    private OffsetDateTime balanceLastUpdated;
    public static final String SERIALIZED_NAME_PHONE_CHANGE_COUNT28D = "phone_change_count_28d";
    @SerializedName(value="phone_change_count_28d")
    private Integer phoneChangeCount28d;
    public static final String SERIALIZED_NAME_PHONE_CHANGE_COUNT90D = "phone_change_count_90d";
    @SerializedName(value="phone_change_count_90d")
    private Integer phoneChangeCount90d;
    public static final String SERIALIZED_NAME_EMAIL_CHANGE_COUNT28D = "email_change_count_28d";
    @SerializedName(value="email_change_count_28d")
    private Integer emailChangeCount28d;
    public static final String SERIALIZED_NAME_EMAIL_CHANGE_COUNT90D = "email_change_count_90d";
    @SerializedName(value="email_change_count_90d")
    private Integer emailChangeCount90d;
    public static final String SERIALIZED_NAME_ADDRESS_CHANGE_COUNT28D = "address_change_count_28d";
    @SerializedName(value="address_change_count_28d")
    private Integer addressChangeCount28d;
    public static final String SERIALIZED_NAME_ADDRESS_CHANGE_COUNT90D = "address_change_count_90d";
    @SerializedName(value="address_change_count_90d")
    private Integer addressChangeCount90d;
    public static final String SERIALIZED_NAME_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT3D = "plaid_non_oauth_authentication_attempts_count_3d";
    @SerializedName(value="plaid_non_oauth_authentication_attempts_count_3d")
    private Integer plaidNonOauthAuthenticationAttemptsCount3d;
    public static final String SERIALIZED_NAME_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT7D = "plaid_non_oauth_authentication_attempts_count_7d";
    @SerializedName(value="plaid_non_oauth_authentication_attempts_count_7d")
    private Integer plaidNonOauthAuthenticationAttemptsCount7d;
    public static final String SERIALIZED_NAME_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT30D = "plaid_non_oauth_authentication_attempts_count_30d";
    @SerializedName(value="plaid_non_oauth_authentication_attempts_count_30d")
    private Integer plaidNonOauthAuthenticationAttemptsCount30d;
    public static final String SERIALIZED_NAME_FAILED_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT3D = "failed_plaid_non_oauth_authentication_attempts_count_3d";
    @SerializedName(value="failed_plaid_non_oauth_authentication_attempts_count_3d")
    private Integer failedPlaidNonOauthAuthenticationAttemptsCount3d;
    public static final String SERIALIZED_NAME_FAILED_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT7D = "failed_plaid_non_oauth_authentication_attempts_count_7d";
    @SerializedName(value="failed_plaid_non_oauth_authentication_attempts_count_7d")
    private Integer failedPlaidNonOauthAuthenticationAttemptsCount7d;
    public static final String SERIALIZED_NAME_FAILED_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT30D = "failed_plaid_non_oauth_authentication_attempts_count_30d";
    @SerializedName(value="failed_plaid_non_oauth_authentication_attempts_count_30d")
    private Integer failedPlaidNonOauthAuthenticationAttemptsCount30d;
    public static final String SERIALIZED_NAME_DEBIT_TRANSACTIONS_COUNT10D = "debit_transactions_count_10d";
    @SerializedName(value="debit_transactions_count_10d")
    private Integer debitTransactionsCount10d;
    public static final String SERIALIZED_NAME_CREDIT_TRANSACTIONS_COUNT10D = "credit_transactions_count_10d";
    @SerializedName(value="credit_transactions_count_10d")
    private Integer creditTransactionsCount10d;
    public static final String SERIALIZED_NAME_DEBIT_TRANSACTIONS_COUNT30D = "debit_transactions_count_30d";
    @SerializedName(value="debit_transactions_count_30d")
    private Integer debitTransactionsCount30d;
    public static final String SERIALIZED_NAME_CREDIT_TRANSACTIONS_COUNT30D = "credit_transactions_count_30d";
    @SerializedName(value="credit_transactions_count_30d")
    private Integer creditTransactionsCount30d;
    public static final String SERIALIZED_NAME_DEBIT_TRANSACTIONS_COUNT60D = "debit_transactions_count_60d";
    @SerializedName(value="debit_transactions_count_60d")
    private Integer debitTransactionsCount60d;
    public static final String SERIALIZED_NAME_CREDIT_TRANSACTIONS_COUNT60D = "credit_transactions_count_60d";
    @SerializedName(value="credit_transactions_count_60d")
    private Integer creditTransactionsCount60d;
    public static final String SERIALIZED_NAME_DEBIT_TRANSACTIONS_COUNT90D = "debit_transactions_count_90d";
    @SerializedName(value="debit_transactions_count_90d")
    private Integer debitTransactionsCount90d;
    public static final String SERIALIZED_NAME_CREDIT_TRANSACTIONS_COUNT90D = "credit_transactions_count_90d";
    @SerializedName(value="credit_transactions_count_90d")
    private Integer creditTransactionsCount90d;
    public static final String SERIALIZED_NAME_TOTAL_DEBIT_TRANSACTIONS_AMOUNT30D = "total_debit_transactions_amount_30d";
    @SerializedName(value="total_debit_transactions_amount_30d")
    private Double totalDebitTransactionsAmount30d;
    public static final String SERIALIZED_NAME_TOTAL_CREDIT_TRANSACTIONS_AMOUNT30D = "total_credit_transactions_amount_30d";
    @SerializedName(value="total_credit_transactions_amount_30d")
    private Double totalCreditTransactionsAmount30d;
    public static final String SERIALIZED_NAME_TOTAL_DEBIT_TRANSACTIONS_AMOUNT60D = "total_debit_transactions_amount_60d";
    @SerializedName(value="total_debit_transactions_amount_60d")
    private Double totalDebitTransactionsAmount60d;
    public static final String SERIALIZED_NAME_TOTAL_CREDIT_TRANSACTIONS_AMOUNT60D = "total_credit_transactions_amount_60d";
    @SerializedName(value="total_credit_transactions_amount_60d")
    private Double totalCreditTransactionsAmount60d;
    public static final String SERIALIZED_NAME_TOTAL_DEBIT_TRANSACTIONS_AMOUNT90D = "total_debit_transactions_amount_90d";
    @SerializedName(value="total_debit_transactions_amount_90d")
    private Double totalDebitTransactionsAmount90d;
    public static final String SERIALIZED_NAME_TOTAL_CREDIT_TRANSACTIONS_AMOUNT90D = "total_credit_transactions_amount_90d";
    @SerializedName(value="total_credit_transactions_amount_90d")
    private Double totalCreditTransactionsAmount90d;
    public static final String SERIALIZED_NAME_P50_EOD_BALANCE30D = "p50_eod_balance_30d";
    @SerializedName(value="p50_eod_balance_30d")
    private Double p50EodBalance30d;
    public static final String SERIALIZED_NAME_P50_EOD_BALANCE60D = "p50_eod_balance_60d";
    @SerializedName(value="p50_eod_balance_60d")
    private Double p50EodBalance60d;
    public static final String SERIALIZED_NAME_P50_EOD_BALANCE90D = "p50_eod_balance_90d";
    @SerializedName(value="p50_eod_balance_90d")
    private Double p50EodBalance90d;
    public static final String SERIALIZED_NAME_P50_EOD_BALANCE31D_TO60D = "p50_eod_balance_31d_to_60d";
    @SerializedName(value="p50_eod_balance_31d_to_60d")
    private Double p50EodBalance31dTo60d;
    public static final String SERIALIZED_NAME_P50_EOD_BALANCE61D_TO90D = "p50_eod_balance_61d_to_90d";
    @SerializedName(value="p50_eod_balance_61d_to_90d")
    private Double p50EodBalance61dTo90d;
    public static final String SERIALIZED_NAME_P90_EOD_BALANCE31D_TO60D = "p90_eod_balance_31d_to_60d";
    @SerializedName(value="p90_eod_balance_31d_to_60d")
    private Double p90EodBalance31dTo60d;
    public static final String SERIALIZED_NAME_P90_EOD_BALANCE61D_TO90D = "p90_eod_balance_61d_to_90d";
    @SerializedName(value="p90_eod_balance_61d_to_90d")
    private Double p90EodBalance61dTo90d;
    public static final String SERIALIZED_NAME_P10_EOD_BALANCE31D_TO60D = "p10_eod_balance_31d_to_60d";
    @SerializedName(value="p10_eod_balance_31d_to_60d")
    private Double p10EodBalance31dTo60d;
    public static final String SERIALIZED_NAME_P10_EOD_BALANCE61D_TO90D = "p10_eod_balance_61d_to_90d";
    @SerializedName(value="p10_eod_balance_61d_to_90d")
    private Double p10EodBalance61dTo90d;
    public static final String SERIALIZED_NAME_TRANSACTIONS_LAST_UPDATED = "transactions_last_updated";
    @SerializedName(value="transactions_last_updated")
    private OffsetDateTime transactionsLastUpdated;
    public static final String SERIALIZED_NAME_IS_ACCOUNT_CLOSED = "is_account_closed";
    @SerializedName(value="is_account_closed")
    private Boolean isAccountClosed;
    public static final String SERIALIZED_NAME_IS_ACCOUNT_FROZEN_OR_RESTRICTED = "is_account_frozen_or_restricted";
    @SerializedName(value="is_account_frozen_or_restricted")
    private Boolean isAccountFrozenOrRestricted;
    public static final String SERIALIZED_NAME_DISTINCT_IP_ADDRESSES_COUNT3D = "distinct_ip_addresses_count_3d";
    @SerializedName(value="distinct_ip_addresses_count_3d")
    private Integer distinctIpAddressesCount3d;
    public static final String SERIALIZED_NAME_DISTINCT_IP_ADDRESSES_COUNT7D = "distinct_ip_addresses_count_7d";
    @SerializedName(value="distinct_ip_addresses_count_7d")
    private Integer distinctIpAddressesCount7d;
    public static final String SERIALIZED_NAME_DISTINCT_IP_ADDRESSES_COUNT30D = "distinct_ip_addresses_count_30d";
    @SerializedName(value="distinct_ip_addresses_count_30d")
    private Integer distinctIpAddressesCount30d;
    public static final String SERIALIZED_NAME_DISTINCT_IP_ADDRESSES_COUNT90D = "distinct_ip_addresses_count_90d";
    @SerializedName(value="distinct_ip_addresses_count_90d")
    private Integer distinctIpAddressesCount90d;
    public static final String SERIALIZED_NAME_DISTINCT_USER_AGENTS_COUNT3D = "distinct_user_agents_count_3d";
    @SerializedName(value="distinct_user_agents_count_3d")
    private Integer distinctUserAgentsCount3d;
    public static final String SERIALIZED_NAME_DISTINCT_USER_AGENTS_COUNT7D = "distinct_user_agents_count_7d";
    @SerializedName(value="distinct_user_agents_count_7d")
    private Integer distinctUserAgentsCount7d;
    public static final String SERIALIZED_NAME_DISTINCT_USER_AGENTS_COUNT30D = "distinct_user_agents_count_30d";
    @SerializedName(value="distinct_user_agents_count_30d")
    private Integer distinctUserAgentsCount30d;
    public static final String SERIALIZED_NAME_DISTINCT_USER_AGENTS_COUNT90D = "distinct_user_agents_count_90d";
    @SerializedName(value="distinct_user_agents_count_90d")
    private Integer distinctUserAgentsCount90d;
    public static final String SERIALIZED_NAME_DISTINCT_SSL_TLS_CONNECTION_SESSIONS_COUNT3D = "distinct_ssl_tls_connection_sessions_count_3d";
    @SerializedName(value="distinct_ssl_tls_connection_sessions_count_3d")
    private Integer distinctSslTlsConnectionSessionsCount3d;
    public static final String SERIALIZED_NAME_DISTINCT_SSL_TLS_CONNECTION_SESSIONS_COUNT7D = "distinct_ssl_tls_connection_sessions_count_7d";
    @SerializedName(value="distinct_ssl_tls_connection_sessions_count_7d")
    private Integer distinctSslTlsConnectionSessionsCount7d;
    public static final String SERIALIZED_NAME_DISTINCT_SSL_TLS_CONNECTION_SESSIONS_COUNT30D = "distinct_ssl_tls_connection_sessions_count_30d";
    @SerializedName(value="distinct_ssl_tls_connection_sessions_count_30d")
    private Integer distinctSslTlsConnectionSessionsCount30d;
    public static final String SERIALIZED_NAME_DISTINCT_SSL_TLS_CONNECTION_SESSIONS_COUNT90D = "distinct_ssl_tls_connection_sessions_count_90d";
    @SerializedName(value="distinct_ssl_tls_connection_sessions_count_90d")
    private Integer distinctSslTlsConnectionSessionsCount90d;
    public static final String SERIALIZED_NAME_DAYS_SINCE_ACCOUNT_OPENING = "days_since_account_opening";
    @SerializedName(value="days_since_account_opening")
    private Integer daysSinceAccountOpening;

    public SignalEvaluateCoreAttributes unauthorizedTransactionsCount7d(Integer unauthorizedTransactionsCount7d) {
        this.unauthorizedTransactionsCount7d = unauthorizedTransactionsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="We parse and analyze historical transaction metadata to identify the number of possible past returns due to unauthorized transactions over the past 7 days from the account that will be debited.")
    public Integer getUnauthorizedTransactionsCount7d() {
        return this.unauthorizedTransactionsCount7d;
    }

    public void setUnauthorizedTransactionsCount7d(Integer unauthorizedTransactionsCount7d) {
        this.unauthorizedTransactionsCount7d = unauthorizedTransactionsCount7d;
    }

    public SignalEvaluateCoreAttributes unauthorizedTransactionsCount30d(Integer unauthorizedTransactionsCount30d) {
        this.unauthorizedTransactionsCount30d = unauthorizedTransactionsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="We parse and analyze historical transaction metadata to identify the number of possible past returns due to unauthorized transactions over the past 30 days from the account that will be debited.")
    public Integer getUnauthorizedTransactionsCount30d() {
        return this.unauthorizedTransactionsCount30d;
    }

    public void setUnauthorizedTransactionsCount30d(Integer unauthorizedTransactionsCount30d) {
        this.unauthorizedTransactionsCount30d = unauthorizedTransactionsCount30d;
    }

    public SignalEvaluateCoreAttributes unauthorizedTransactionsCount60d(Integer unauthorizedTransactionsCount60d) {
        this.unauthorizedTransactionsCount60d = unauthorizedTransactionsCount60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="We parse and analyze historical transaction metadata to identify the number of possible past returns due to unauthorized transactions over the past 60 days from the account that will be debited.")
    public Integer getUnauthorizedTransactionsCount60d() {
        return this.unauthorizedTransactionsCount60d;
    }

    public void setUnauthorizedTransactionsCount60d(Integer unauthorizedTransactionsCount60d) {
        this.unauthorizedTransactionsCount60d = unauthorizedTransactionsCount60d;
    }

    public SignalEvaluateCoreAttributes unauthorizedTransactionsCount90d(Integer unauthorizedTransactionsCount90d) {
        this.unauthorizedTransactionsCount90d = unauthorizedTransactionsCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="We parse and analyze historical transaction metadata to identify the number of possible past returns due to unauthorized transactions over the past 90 days from the account that will be debited.")
    public Integer getUnauthorizedTransactionsCount90d() {
        return this.unauthorizedTransactionsCount90d;
    }

    public void setUnauthorizedTransactionsCount90d(Integer unauthorizedTransactionsCount90d) {
        this.unauthorizedTransactionsCount90d = unauthorizedTransactionsCount90d;
    }

    public SignalEvaluateCoreAttributes nsfOverdraftTransactionsCount7d(Integer nsfOverdraftTransactionsCount7d) {
        this.nsfOverdraftTransactionsCount7d = nsfOverdraftTransactionsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="We parse and analyze historical transaction metadata to identify the number of possible past returns due to non-sufficient funds/overdrafts over the past 7 days from the account that will be debited.")
    public Integer getNsfOverdraftTransactionsCount7d() {
        return this.nsfOverdraftTransactionsCount7d;
    }

    public void setNsfOverdraftTransactionsCount7d(Integer nsfOverdraftTransactionsCount7d) {
        this.nsfOverdraftTransactionsCount7d = nsfOverdraftTransactionsCount7d;
    }

    public SignalEvaluateCoreAttributes nsfOverdraftTransactionsCount30d(Integer nsfOverdraftTransactionsCount30d) {
        this.nsfOverdraftTransactionsCount30d = nsfOverdraftTransactionsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="We parse and analyze historical transaction metadata to identify the number of possible past returns due to non-sufficient funds/overdrafts over the past 30 days from the account that will be debited.")
    public Integer getNsfOverdraftTransactionsCount30d() {
        return this.nsfOverdraftTransactionsCount30d;
    }

    public void setNsfOverdraftTransactionsCount30d(Integer nsfOverdraftTransactionsCount30d) {
        this.nsfOverdraftTransactionsCount30d = nsfOverdraftTransactionsCount30d;
    }

    public SignalEvaluateCoreAttributes nsfOverdraftTransactionsCount60d(Integer nsfOverdraftTransactionsCount60d) {
        this.nsfOverdraftTransactionsCount60d = nsfOverdraftTransactionsCount60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="We parse and analyze historical transaction metadata to identify the number of possible past returns due to non-sufficient funds/overdrafts over the past 60 days from the account that will be debited.")
    public Integer getNsfOverdraftTransactionsCount60d() {
        return this.nsfOverdraftTransactionsCount60d;
    }

    public void setNsfOverdraftTransactionsCount60d(Integer nsfOverdraftTransactionsCount60d) {
        this.nsfOverdraftTransactionsCount60d = nsfOverdraftTransactionsCount60d;
    }

    public SignalEvaluateCoreAttributes nsfOverdraftTransactionsCount90d(Integer nsfOverdraftTransactionsCount90d) {
        this.nsfOverdraftTransactionsCount90d = nsfOverdraftTransactionsCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="We parse and analyze historical transaction metadata to identify the number of possible past returns due to non-sufficient funds/overdrafts over the past 90 days from the account that will be debited.")
    public Integer getNsfOverdraftTransactionsCount90d() {
        return this.nsfOverdraftTransactionsCount90d;
    }

    public void setNsfOverdraftTransactionsCount90d(Integer nsfOverdraftTransactionsCount90d) {
        this.nsfOverdraftTransactionsCount90d = nsfOverdraftTransactionsCount90d;
    }

    public SignalEvaluateCoreAttributes daysSinceFirstPlaidConnection(Integer daysSinceFirstPlaidConnection) {
        this.daysSinceFirstPlaidConnection = daysSinceFirstPlaidConnection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of days since the first time the Item was connected to an application via Plaid")
    public Integer getDaysSinceFirstPlaidConnection() {
        return this.daysSinceFirstPlaidConnection;
    }

    public void setDaysSinceFirstPlaidConnection(Integer daysSinceFirstPlaidConnection) {
        this.daysSinceFirstPlaidConnection = daysSinceFirstPlaidConnection;
    }

    public SignalEvaluateCoreAttributes plaidConnectionsCount7d(Integer plaidConnectionsCount7d) {
        this.plaidConnectionsCount7d = plaidConnectionsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the Item has been connected to applications via Plaid over the past 7 days")
    public Integer getPlaidConnectionsCount7d() {
        return this.plaidConnectionsCount7d;
    }

    public void setPlaidConnectionsCount7d(Integer plaidConnectionsCount7d) {
        this.plaidConnectionsCount7d = plaidConnectionsCount7d;
    }

    public SignalEvaluateCoreAttributes plaidConnectionsCount30d(Integer plaidConnectionsCount30d) {
        this.plaidConnectionsCount30d = plaidConnectionsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the Item has been connected to applications via Plaid over the past 30 days")
    public Integer getPlaidConnectionsCount30d() {
        return this.plaidConnectionsCount30d;
    }

    public void setPlaidConnectionsCount30d(Integer plaidConnectionsCount30d) {
        this.plaidConnectionsCount30d = plaidConnectionsCount30d;
    }

    public SignalEvaluateCoreAttributes totalPlaidConnectionsCount(Integer totalPlaidConnectionsCount) {
        this.totalPlaidConnectionsCount = totalPlaidConnectionsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of times the Item has been connected to applications via Plaid")
    public Integer getTotalPlaidConnectionsCount() {
        return this.totalPlaidConnectionsCount;
    }

    public void setTotalPlaidConnectionsCount(Integer totalPlaidConnectionsCount) {
        this.totalPlaidConnectionsCount = totalPlaidConnectionsCount;
    }

    public SignalEvaluateCoreAttributes isSavingsOrMoneyMarketAccount(Boolean isSavingsOrMoneyMarketAccount) {
        this.isSavingsOrMoneyMarketAccount = isSavingsOrMoneyMarketAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the ACH transaction funding account is a savings/money market account")
    public Boolean getIsSavingsOrMoneyMarketAccount() {
        return this.isSavingsOrMoneyMarketAccount;
    }

    public void setIsSavingsOrMoneyMarketAccount(Boolean isSavingsOrMoneyMarketAccount) {
        this.isSavingsOrMoneyMarketAccount = isSavingsOrMoneyMarketAccount;
    }

    public SignalEvaluateCoreAttributes totalCreditTransactionsAmount10d(Double totalCreditTransactionsAmount10d) {
        this.totalCreditTransactionsAmount10d = totalCreditTransactionsAmount10d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total credit (inflow) transaction amount over the past 10 days from the account that will be debited")
    public Double getTotalCreditTransactionsAmount10d() {
        return this.totalCreditTransactionsAmount10d;
    }

    public void setTotalCreditTransactionsAmount10d(Double totalCreditTransactionsAmount10d) {
        this.totalCreditTransactionsAmount10d = totalCreditTransactionsAmount10d;
    }

    public SignalEvaluateCoreAttributes totalDebitTransactionsAmount10d(Double totalDebitTransactionsAmount10d) {
        this.totalDebitTransactionsAmount10d = totalDebitTransactionsAmount10d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total debit (outflow) transaction amount over the past 10 days from the account that will be debited")
    public Double getTotalDebitTransactionsAmount10d() {
        return this.totalDebitTransactionsAmount10d;
    }

    public void setTotalDebitTransactionsAmount10d(Double totalDebitTransactionsAmount10d) {
        this.totalDebitTransactionsAmount10d = totalDebitTransactionsAmount10d;
    }

    public SignalEvaluateCoreAttributes p50CreditTransactionsAmount28d(Double p50CreditTransactionsAmount28d) {
        this.p50CreditTransactionsAmount28d = p50CreditTransactionsAmount28d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 50th percentile of all credit (inflow) transaction amounts over the past 28 days from the account that will be debited")
    public Double getP50CreditTransactionsAmount28d() {
        return this.p50CreditTransactionsAmount28d;
    }

    public void setP50CreditTransactionsAmount28d(Double p50CreditTransactionsAmount28d) {
        this.p50CreditTransactionsAmount28d = p50CreditTransactionsAmount28d;
    }

    public SignalEvaluateCoreAttributes p50DebitTransactionsAmount28d(Double p50DebitTransactionsAmount28d) {
        this.p50DebitTransactionsAmount28d = p50DebitTransactionsAmount28d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 50th percentile of all debit (outflow) transaction amounts over the past 28 days from the account that will be debited")
    public Double getP50DebitTransactionsAmount28d() {
        return this.p50DebitTransactionsAmount28d;
    }

    public void setP50DebitTransactionsAmount28d(Double p50DebitTransactionsAmount28d) {
        this.p50DebitTransactionsAmount28d = p50DebitTransactionsAmount28d;
    }

    public SignalEvaluateCoreAttributes p95CreditTransactionsAmount28d(Double p95CreditTransactionsAmount28d) {
        this.p95CreditTransactionsAmount28d = p95CreditTransactionsAmount28d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 95th percentile of all credit (inflow) transaction amounts over the past 28 days from the account that will be debited")
    public Double getP95CreditTransactionsAmount28d() {
        return this.p95CreditTransactionsAmount28d;
    }

    public void setP95CreditTransactionsAmount28d(Double p95CreditTransactionsAmount28d) {
        this.p95CreditTransactionsAmount28d = p95CreditTransactionsAmount28d;
    }

    public SignalEvaluateCoreAttributes p95DebitTransactionsAmount28d(Double p95DebitTransactionsAmount28d) {
        this.p95DebitTransactionsAmount28d = p95DebitTransactionsAmount28d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 95th percentile of all debit (outflow) transaction amounts over the past 28 days from the account that will be debited")
    public Double getP95DebitTransactionsAmount28d() {
        return this.p95DebitTransactionsAmount28d;
    }

    public void setP95DebitTransactionsAmount28d(Double p95DebitTransactionsAmount28d) {
        this.p95DebitTransactionsAmount28d = p95DebitTransactionsAmount28d;
    }

    public SignalEvaluateCoreAttributes daysWithNegativeBalanceCount90d(Integer daysWithNegativeBalanceCount90d) {
        this.daysWithNegativeBalanceCount90d = daysWithNegativeBalanceCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of days within the past 90 days when the account that will be debited had a negative end-of-day available balance")
    public Integer getDaysWithNegativeBalanceCount90d() {
        return this.daysWithNegativeBalanceCount90d;
    }

    public void setDaysWithNegativeBalanceCount90d(Integer daysWithNegativeBalanceCount90d) {
        this.daysWithNegativeBalanceCount90d = daysWithNegativeBalanceCount90d;
    }

    public SignalEvaluateCoreAttributes p90EodBalance30d(Double p90EodBalance30d) {
        this.p90EodBalance30d = p90EodBalance30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 90th percentile of the end-of-day available balance over the past 30 days of the account that will be debited")
    public Double getP90EodBalance30d() {
        return this.p90EodBalance30d;
    }

    public void setP90EodBalance30d(Double p90EodBalance30d) {
        this.p90EodBalance30d = p90EodBalance30d;
    }

    public SignalEvaluateCoreAttributes p90EodBalance60d(Double p90EodBalance60d) {
        this.p90EodBalance60d = p90EodBalance60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 90th percentile of the end-of-day available balance over the past 60 days of the account that will be debited")
    public Double getP90EodBalance60d() {
        return this.p90EodBalance60d;
    }

    public void setP90EodBalance60d(Double p90EodBalance60d) {
        this.p90EodBalance60d = p90EodBalance60d;
    }

    public SignalEvaluateCoreAttributes p90EodBalance90d(Double p90EodBalance90d) {
        this.p90EodBalance90d = p90EodBalance90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 90th percentile of the end-of-day available balance over the past 90 days of the account that will be debited")
    public Double getP90EodBalance90d() {
        return this.p90EodBalance90d;
    }

    public void setP90EodBalance90d(Double p90EodBalance90d) {
        this.p90EodBalance90d = p90EodBalance90d;
    }

    public SignalEvaluateCoreAttributes p10EodBalance30d(Double p10EodBalance30d) {
        this.p10EodBalance30d = p10EodBalance30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 10th percentile of the end-of-day available balance over the past 30 days of the account that will be debited")
    public Double getP10EodBalance30d() {
        return this.p10EodBalance30d;
    }

    public void setP10EodBalance30d(Double p10EodBalance30d) {
        this.p10EodBalance30d = p10EodBalance30d;
    }

    public SignalEvaluateCoreAttributes p10EodBalance60d(Double p10EodBalance60d) {
        this.p10EodBalance60d = p10EodBalance60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 10th percentile of the end-of-day available balance over the past 60 days of the account that will be debited")
    public Double getP10EodBalance60d() {
        return this.p10EodBalance60d;
    }

    public void setP10EodBalance60d(Double p10EodBalance60d) {
        this.p10EodBalance60d = p10EodBalance60d;
    }

    public SignalEvaluateCoreAttributes p10EodBalance90d(Double p10EodBalance90d) {
        this.p10EodBalance90d = p10EodBalance90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 10th percentile of the end-of-day available balance over the past 90 days of the account that will be debited")
    public Double getP10EodBalance90d() {
        return this.p10EodBalance90d;
    }

    public void setP10EodBalance90d(Double p10EodBalance90d) {
        this.p10EodBalance90d = p10EodBalance90d;
    }

    public SignalEvaluateCoreAttributes availableBalance(Double availableBalance) {
        this.availableBalance = availableBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Available balance, as of the `balance_last_updated` time. The available balance is the current balance less any outstanding holds or debits that have not yet posted to the account.")
    public Double getAvailableBalance() {
        return this.availableBalance;
    }

    public void setAvailableBalance(Double availableBalance) {
        this.availableBalance = availableBalance;
    }

    public SignalEvaluateCoreAttributes currentBalance(Double currentBalance) {
        this.currentBalance = currentBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Current balance, as of the `balance_last_updated` time. The current balance is the total amount of funds in the account.")
    public Double getCurrentBalance() {
        return this.currentBalance;
    }

    public void setCurrentBalance(Double currentBalance) {
        this.currentBalance = currentBalance;
    }

    public SignalEvaluateCoreAttributes balanceLastUpdated(OffsetDateTime balanceLastUpdated) {
        this.balanceLastUpdated = balanceLastUpdated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DDTHH:mm:ssZ) indicating the last time that the balance for the given account has been updated.")
    public OffsetDateTime getBalanceLastUpdated() {
        return this.balanceLastUpdated;
    }

    public void setBalanceLastUpdated(OffsetDateTime balanceLastUpdated) {
        this.balanceLastUpdated = balanceLastUpdated;
    }

    public SignalEvaluateCoreAttributes phoneChangeCount28d(Integer phoneChangeCount28d) {
        this.phoneChangeCount28d = phoneChangeCount28d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's phone numbers on file have changed over the past 28 days")
    public Integer getPhoneChangeCount28d() {
        return this.phoneChangeCount28d;
    }

    public void setPhoneChangeCount28d(Integer phoneChangeCount28d) {
        this.phoneChangeCount28d = phoneChangeCount28d;
    }

    public SignalEvaluateCoreAttributes phoneChangeCount90d(Integer phoneChangeCount90d) {
        this.phoneChangeCount90d = phoneChangeCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's phone numbers on file have changed over the past 90 days")
    public Integer getPhoneChangeCount90d() {
        return this.phoneChangeCount90d;
    }

    public void setPhoneChangeCount90d(Integer phoneChangeCount90d) {
        this.phoneChangeCount90d = phoneChangeCount90d;
    }

    public SignalEvaluateCoreAttributes emailChangeCount28d(Integer emailChangeCount28d) {
        this.emailChangeCount28d = emailChangeCount28d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's email addresses on file have changed over the past 28 days")
    public Integer getEmailChangeCount28d() {
        return this.emailChangeCount28d;
    }

    public void setEmailChangeCount28d(Integer emailChangeCount28d) {
        this.emailChangeCount28d = emailChangeCount28d;
    }

    public SignalEvaluateCoreAttributes emailChangeCount90d(Integer emailChangeCount90d) {
        this.emailChangeCount90d = emailChangeCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's email addresses on file have changed over the past 90 days")
    public Integer getEmailChangeCount90d() {
        return this.emailChangeCount90d;
    }

    public void setEmailChangeCount90d(Integer emailChangeCount90d) {
        this.emailChangeCount90d = emailChangeCount90d;
    }

    public SignalEvaluateCoreAttributes addressChangeCount28d(Integer addressChangeCount28d) {
        this.addressChangeCount28d = addressChangeCount28d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's addresses on file have changed over the past 28 days")
    public Integer getAddressChangeCount28d() {
        return this.addressChangeCount28d;
    }

    public void setAddressChangeCount28d(Integer addressChangeCount28d) {
        this.addressChangeCount28d = addressChangeCount28d;
    }

    public SignalEvaluateCoreAttributes addressChangeCount90d(Integer addressChangeCount90d) {
        this.addressChangeCount90d = addressChangeCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's addresses on file have changed over the past 90 days")
    public Integer getAddressChangeCount90d() {
        return this.addressChangeCount90d;
    }

    public void setAddressChangeCount90d(Integer addressChangeCount90d) {
        this.addressChangeCount90d = addressChangeCount90d;
    }

    public SignalEvaluateCoreAttributes plaidNonOauthAuthenticationAttemptsCount3d(Integer plaidNonOauthAuthenticationAttemptsCount3d) {
        this.plaidNonOauthAuthenticationAttemptsCount3d = plaidNonOauthAuthenticationAttemptsCount3d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of non-OAuth authentication attempts via Plaid for this bank account over the past 3 days")
    public Integer getPlaidNonOauthAuthenticationAttemptsCount3d() {
        return this.plaidNonOauthAuthenticationAttemptsCount3d;
    }

    public void setPlaidNonOauthAuthenticationAttemptsCount3d(Integer plaidNonOauthAuthenticationAttemptsCount3d) {
        this.plaidNonOauthAuthenticationAttemptsCount3d = plaidNonOauthAuthenticationAttemptsCount3d;
    }

    public SignalEvaluateCoreAttributes plaidNonOauthAuthenticationAttemptsCount7d(Integer plaidNonOauthAuthenticationAttemptsCount7d) {
        this.plaidNonOauthAuthenticationAttemptsCount7d = plaidNonOauthAuthenticationAttemptsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of non-OAuth authentication attempts via Plaid for this bank account over the past 7 days")
    public Integer getPlaidNonOauthAuthenticationAttemptsCount7d() {
        return this.plaidNonOauthAuthenticationAttemptsCount7d;
    }

    public void setPlaidNonOauthAuthenticationAttemptsCount7d(Integer plaidNonOauthAuthenticationAttemptsCount7d) {
        this.plaidNonOauthAuthenticationAttemptsCount7d = plaidNonOauthAuthenticationAttemptsCount7d;
    }

    public SignalEvaluateCoreAttributes plaidNonOauthAuthenticationAttemptsCount30d(Integer plaidNonOauthAuthenticationAttemptsCount30d) {
        this.plaidNonOauthAuthenticationAttemptsCount30d = plaidNonOauthAuthenticationAttemptsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of non-OAuth authentication attempts via Plaid for this bank account over the past 30 days")
    public Integer getPlaidNonOauthAuthenticationAttemptsCount30d() {
        return this.plaidNonOauthAuthenticationAttemptsCount30d;
    }

    public void setPlaidNonOauthAuthenticationAttemptsCount30d(Integer plaidNonOauthAuthenticationAttemptsCount30d) {
        this.plaidNonOauthAuthenticationAttemptsCount30d = plaidNonOauthAuthenticationAttemptsCount30d;
    }

    public SignalEvaluateCoreAttributes failedPlaidNonOauthAuthenticationAttemptsCount3d(Integer failedPlaidNonOauthAuthenticationAttemptsCount3d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount3d = failedPlaidNonOauthAuthenticationAttemptsCount3d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of failed non-OAuth authentication attempts via Plaid for this bank account over the past 3 days")
    public Integer getFailedPlaidNonOauthAuthenticationAttemptsCount3d() {
        return this.failedPlaidNonOauthAuthenticationAttemptsCount3d;
    }

    public void setFailedPlaidNonOauthAuthenticationAttemptsCount3d(Integer failedPlaidNonOauthAuthenticationAttemptsCount3d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount3d = failedPlaidNonOauthAuthenticationAttemptsCount3d;
    }

    public SignalEvaluateCoreAttributes failedPlaidNonOauthAuthenticationAttemptsCount7d(Integer failedPlaidNonOauthAuthenticationAttemptsCount7d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount7d = failedPlaidNonOauthAuthenticationAttemptsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of failed non-OAuth authentication attempts via Plaid for this bank account over the past 7 days")
    public Integer getFailedPlaidNonOauthAuthenticationAttemptsCount7d() {
        return this.failedPlaidNonOauthAuthenticationAttemptsCount7d;
    }

    public void setFailedPlaidNonOauthAuthenticationAttemptsCount7d(Integer failedPlaidNonOauthAuthenticationAttemptsCount7d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount7d = failedPlaidNonOauthAuthenticationAttemptsCount7d;
    }

    public SignalEvaluateCoreAttributes failedPlaidNonOauthAuthenticationAttemptsCount30d(Integer failedPlaidNonOauthAuthenticationAttemptsCount30d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount30d = failedPlaidNonOauthAuthenticationAttemptsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of failed non-OAuth authentication attempts via Plaid for this bank account over the past 30 days")
    public Integer getFailedPlaidNonOauthAuthenticationAttemptsCount30d() {
        return this.failedPlaidNonOauthAuthenticationAttemptsCount30d;
    }

    public void setFailedPlaidNonOauthAuthenticationAttemptsCount30d(Integer failedPlaidNonOauthAuthenticationAttemptsCount30d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount30d = failedPlaidNonOauthAuthenticationAttemptsCount30d;
    }

    public SignalEvaluateCoreAttributes debitTransactionsCount10d(Integer debitTransactionsCount10d) {
        this.debitTransactionsCount10d = debitTransactionsCount10d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of debit (outflow) transactions over the past 10 days from the account that will be debited")
    public Integer getDebitTransactionsCount10d() {
        return this.debitTransactionsCount10d;
    }

    public void setDebitTransactionsCount10d(Integer debitTransactionsCount10d) {
        this.debitTransactionsCount10d = debitTransactionsCount10d;
    }

    public SignalEvaluateCoreAttributes creditTransactionsCount10d(Integer creditTransactionsCount10d) {
        this.creditTransactionsCount10d = creditTransactionsCount10d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of credit (inflow) transactions over the past 10 days from the account that will be debited")
    public Integer getCreditTransactionsCount10d() {
        return this.creditTransactionsCount10d;
    }

    public void setCreditTransactionsCount10d(Integer creditTransactionsCount10d) {
        this.creditTransactionsCount10d = creditTransactionsCount10d;
    }

    public SignalEvaluateCoreAttributes debitTransactionsCount30d(Integer debitTransactionsCount30d) {
        this.debitTransactionsCount30d = debitTransactionsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of debit (outflow) transactions over the past 30 days from the account that will be debited")
    public Integer getDebitTransactionsCount30d() {
        return this.debitTransactionsCount30d;
    }

    public void setDebitTransactionsCount30d(Integer debitTransactionsCount30d) {
        this.debitTransactionsCount30d = debitTransactionsCount30d;
    }

    public SignalEvaluateCoreAttributes creditTransactionsCount30d(Integer creditTransactionsCount30d) {
        this.creditTransactionsCount30d = creditTransactionsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of credit (inflow) transactions over the past 30 days from the account that will be debited")
    public Integer getCreditTransactionsCount30d() {
        return this.creditTransactionsCount30d;
    }

    public void setCreditTransactionsCount30d(Integer creditTransactionsCount30d) {
        this.creditTransactionsCount30d = creditTransactionsCount30d;
    }

    public SignalEvaluateCoreAttributes debitTransactionsCount60d(Integer debitTransactionsCount60d) {
        this.debitTransactionsCount60d = debitTransactionsCount60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of debit (outflow) transactions over the past 60 days from the account that will be debited")
    public Integer getDebitTransactionsCount60d() {
        return this.debitTransactionsCount60d;
    }

    public void setDebitTransactionsCount60d(Integer debitTransactionsCount60d) {
        this.debitTransactionsCount60d = debitTransactionsCount60d;
    }

    public SignalEvaluateCoreAttributes creditTransactionsCount60d(Integer creditTransactionsCount60d) {
        this.creditTransactionsCount60d = creditTransactionsCount60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of credit (inflow) transactions over the past 60 days from the account that will be debited")
    public Integer getCreditTransactionsCount60d() {
        return this.creditTransactionsCount60d;
    }

    public void setCreditTransactionsCount60d(Integer creditTransactionsCount60d) {
        this.creditTransactionsCount60d = creditTransactionsCount60d;
    }

    public SignalEvaluateCoreAttributes debitTransactionsCount90d(Integer debitTransactionsCount90d) {
        this.debitTransactionsCount90d = debitTransactionsCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of debit (outflow) transactions over the past 90 days from the account that will be debited")
    public Integer getDebitTransactionsCount90d() {
        return this.debitTransactionsCount90d;
    }

    public void setDebitTransactionsCount90d(Integer debitTransactionsCount90d) {
        this.debitTransactionsCount90d = debitTransactionsCount90d;
    }

    public SignalEvaluateCoreAttributes creditTransactionsCount90d(Integer creditTransactionsCount90d) {
        this.creditTransactionsCount90d = creditTransactionsCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of credit (inflow) transactions over the past 90 days from the account that will be debited")
    public Integer getCreditTransactionsCount90d() {
        return this.creditTransactionsCount90d;
    }

    public void setCreditTransactionsCount90d(Integer creditTransactionsCount90d) {
        this.creditTransactionsCount90d = creditTransactionsCount90d;
    }

    public SignalEvaluateCoreAttributes totalDebitTransactionsAmount30d(Double totalDebitTransactionsAmount30d) {
        this.totalDebitTransactionsAmount30d = totalDebitTransactionsAmount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total debit (outflow) transaction amount over the past 30 days from the account that will be debited")
    public Double getTotalDebitTransactionsAmount30d() {
        return this.totalDebitTransactionsAmount30d;
    }

    public void setTotalDebitTransactionsAmount30d(Double totalDebitTransactionsAmount30d) {
        this.totalDebitTransactionsAmount30d = totalDebitTransactionsAmount30d;
    }

    public SignalEvaluateCoreAttributes totalCreditTransactionsAmount30d(Double totalCreditTransactionsAmount30d) {
        this.totalCreditTransactionsAmount30d = totalCreditTransactionsAmount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total credit (inflow) transaction amount over the past 30 days from the account that will be debited")
    public Double getTotalCreditTransactionsAmount30d() {
        return this.totalCreditTransactionsAmount30d;
    }

    public void setTotalCreditTransactionsAmount30d(Double totalCreditTransactionsAmount30d) {
        this.totalCreditTransactionsAmount30d = totalCreditTransactionsAmount30d;
    }

    public SignalEvaluateCoreAttributes totalDebitTransactionsAmount60d(Double totalDebitTransactionsAmount60d) {
        this.totalDebitTransactionsAmount60d = totalDebitTransactionsAmount60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total debit (outflow) transaction amount over the past 60 days from the account that will be debited")
    public Double getTotalDebitTransactionsAmount60d() {
        return this.totalDebitTransactionsAmount60d;
    }

    public void setTotalDebitTransactionsAmount60d(Double totalDebitTransactionsAmount60d) {
        this.totalDebitTransactionsAmount60d = totalDebitTransactionsAmount60d;
    }

    public SignalEvaluateCoreAttributes totalCreditTransactionsAmount60d(Double totalCreditTransactionsAmount60d) {
        this.totalCreditTransactionsAmount60d = totalCreditTransactionsAmount60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total credit (inflow) transaction amount over the past 60 days from the account that will be debited")
    public Double getTotalCreditTransactionsAmount60d() {
        return this.totalCreditTransactionsAmount60d;
    }

    public void setTotalCreditTransactionsAmount60d(Double totalCreditTransactionsAmount60d) {
        this.totalCreditTransactionsAmount60d = totalCreditTransactionsAmount60d;
    }

    public SignalEvaluateCoreAttributes totalDebitTransactionsAmount90d(Double totalDebitTransactionsAmount90d) {
        this.totalDebitTransactionsAmount90d = totalDebitTransactionsAmount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total debit (outflow) transaction amount over the past 90 days from the account that will be debited")
    public Double getTotalDebitTransactionsAmount90d() {
        return this.totalDebitTransactionsAmount90d;
    }

    public void setTotalDebitTransactionsAmount90d(Double totalDebitTransactionsAmount90d) {
        this.totalDebitTransactionsAmount90d = totalDebitTransactionsAmount90d;
    }

    public SignalEvaluateCoreAttributes totalCreditTransactionsAmount90d(Double totalCreditTransactionsAmount90d) {
        this.totalCreditTransactionsAmount90d = totalCreditTransactionsAmount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total credit (inflow) transaction amount over the past 90 days from the account that will be debited")
    public Double getTotalCreditTransactionsAmount90d() {
        return this.totalCreditTransactionsAmount90d;
    }

    public void setTotalCreditTransactionsAmount90d(Double totalCreditTransactionsAmount90d) {
        this.totalCreditTransactionsAmount90d = totalCreditTransactionsAmount90d;
    }

    public SignalEvaluateCoreAttributes p50EodBalance30d(Double p50EodBalance30d) {
        this.p50EodBalance30d = p50EodBalance30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 50th percentile of the end-of-day available balance over the past 30 days of the account that will be debited")
    public Double getP50EodBalance30d() {
        return this.p50EodBalance30d;
    }

    public void setP50EodBalance30d(Double p50EodBalance30d) {
        this.p50EodBalance30d = p50EodBalance30d;
    }

    public SignalEvaluateCoreAttributes p50EodBalance60d(Double p50EodBalance60d) {
        this.p50EodBalance60d = p50EodBalance60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 50th percentile of the end-of-day available balance over the past 60 days of the account that will be debited")
    public Double getP50EodBalance60d() {
        return this.p50EodBalance60d;
    }

    public void setP50EodBalance60d(Double p50EodBalance60d) {
        this.p50EodBalance60d = p50EodBalance60d;
    }

    public SignalEvaluateCoreAttributes p50EodBalance90d(Double p50EodBalance90d) {
        this.p50EodBalance90d = p50EodBalance90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 50th percentile of the end-of-day available balance over the past 90 days of the account that will be debited")
    public Double getP50EodBalance90d() {
        return this.p50EodBalance90d;
    }

    public void setP50EodBalance90d(Double p50EodBalance90d) {
        this.p50EodBalance90d = p50EodBalance90d;
    }

    public SignalEvaluateCoreAttributes p50EodBalance31dTo60d(Double p50EodBalance31dTo60d) {
        this.p50EodBalance31dTo60d = p50EodBalance31dTo60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 50th percentile of the end-of-day available balance between day 31 and day 60 over the past 60 days of the account that will be debited")
    public Double getP50EodBalance31dTo60d() {
        return this.p50EodBalance31dTo60d;
    }

    public void setP50EodBalance31dTo60d(Double p50EodBalance31dTo60d) {
        this.p50EodBalance31dTo60d = p50EodBalance31dTo60d;
    }

    public SignalEvaluateCoreAttributes p50EodBalance61dTo90d(Double p50EodBalance61dTo90d) {
        this.p50EodBalance61dTo90d = p50EodBalance61dTo90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 50th percentile of the end-of-day available balance between day 61 and day 90 over the past 60 days of the account that will be debited")
    public Double getP50EodBalance61dTo90d() {
        return this.p50EodBalance61dTo90d;
    }

    public void setP50EodBalance61dTo90d(Double p50EodBalance61dTo90d) {
        this.p50EodBalance61dTo90d = p50EodBalance61dTo90d;
    }

    public SignalEvaluateCoreAttributes p90EodBalance31dTo60d(Double p90EodBalance31dTo60d) {
        this.p90EodBalance31dTo60d = p90EodBalance31dTo60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 90th percentile of the end-of-day available balance between day 31 and day 60 over the past 60 days of the account that will be debited")
    public Double getP90EodBalance31dTo60d() {
        return this.p90EodBalance31dTo60d;
    }

    public void setP90EodBalance31dTo60d(Double p90EodBalance31dTo60d) {
        this.p90EodBalance31dTo60d = p90EodBalance31dTo60d;
    }

    public SignalEvaluateCoreAttributes p90EodBalance61dTo90d(Double p90EodBalance61dTo90d) {
        this.p90EodBalance61dTo90d = p90EodBalance61dTo90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 90th percentile of the end-of-day available balance between day 61 and day 90 over the past 60 days of the account that will be debited")
    public Double getP90EodBalance61dTo90d() {
        return this.p90EodBalance61dTo90d;
    }

    public void setP90EodBalance61dTo90d(Double p90EodBalance61dTo90d) {
        this.p90EodBalance61dTo90d = p90EodBalance61dTo90d;
    }

    public SignalEvaluateCoreAttributes p10EodBalance31dTo60d(Double p10EodBalance31dTo60d) {
        this.p10EodBalance31dTo60d = p10EodBalance31dTo60d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 10th percentile of the end-of-day available balance between day 31 and day 60 over the past 60 days of the account that will be debited")
    public Double getP10EodBalance31dTo60d() {
        return this.p10EodBalance31dTo60d;
    }

    public void setP10EodBalance31dTo60d(Double p10EodBalance31dTo60d) {
        this.p10EodBalance31dTo60d = p10EodBalance31dTo60d;
    }

    public SignalEvaluateCoreAttributes p10EodBalance61dTo90d(Double p10EodBalance61dTo90d) {
        this.p10EodBalance61dTo90d = p10EodBalance61dTo90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 10th percentile of the end-of-day available balance between day 61 and day 90 over the past 60 days of the account that will be debited")
    public Double getP10EodBalance61dTo90d() {
        return this.p10EodBalance61dTo90d;
    }

    public void setP10EodBalance61dTo90d(Double p10EodBalance61dTo90d) {
        this.p10EodBalance61dTo90d = p10EodBalance61dTo90d;
    }

    public SignalEvaluateCoreAttributes transactionsLastUpdated(OffsetDateTime transactionsLastUpdated) {
        this.transactionsLastUpdated = transactionsLastUpdated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DDTHH:mm:ssZ) indicating the last time that the transactions for the given account have been updated.")
    public OffsetDateTime getTransactionsLastUpdated() {
        return this.transactionsLastUpdated;
    }

    public void setTransactionsLastUpdated(OffsetDateTime transactionsLastUpdated) {
        this.transactionsLastUpdated = transactionsLastUpdated;
    }

    public SignalEvaluateCoreAttributes isAccountClosed(Boolean isAccountClosed) {
        this.isAccountClosed = isAccountClosed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the receiver bank account is closed")
    public Boolean getIsAccountClosed() {
        return this.isAccountClosed;
    }

    public void setIsAccountClosed(Boolean isAccountClosed) {
        this.isAccountClosed = isAccountClosed;
    }

    public SignalEvaluateCoreAttributes isAccountFrozenOrRestricted(Boolean isAccountFrozenOrRestricted) {
        this.isAccountFrozenOrRestricted = isAccountFrozenOrRestricted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the receiver bank account is either frozen or restricted")
    public Boolean getIsAccountFrozenOrRestricted() {
        return this.isAccountFrozenOrRestricted;
    }

    public void setIsAccountFrozenOrRestricted(Boolean isAccountFrozenOrRestricted) {
        this.isAccountFrozenOrRestricted = isAccountFrozenOrRestricted;
    }

    public SignalEvaluateCoreAttributes distinctIpAddressesCount3d(Integer distinctIpAddressesCount3d) {
        this.distinctIpAddressesCount3d = distinctIpAddressesCount3d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct IP addresses linked to the same bank account during Plaid authentication in the last 3 days")
    public Integer getDistinctIpAddressesCount3d() {
        return this.distinctIpAddressesCount3d;
    }

    public void setDistinctIpAddressesCount3d(Integer distinctIpAddressesCount3d) {
        this.distinctIpAddressesCount3d = distinctIpAddressesCount3d;
    }

    public SignalEvaluateCoreAttributes distinctIpAddressesCount7d(Integer distinctIpAddressesCount7d) {
        this.distinctIpAddressesCount7d = distinctIpAddressesCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct IP addresses linked to the same bank account during Plaid authentication in the last 7 days")
    public Integer getDistinctIpAddressesCount7d() {
        return this.distinctIpAddressesCount7d;
    }

    public void setDistinctIpAddressesCount7d(Integer distinctIpAddressesCount7d) {
        this.distinctIpAddressesCount7d = distinctIpAddressesCount7d;
    }

    public SignalEvaluateCoreAttributes distinctIpAddressesCount30d(Integer distinctIpAddressesCount30d) {
        this.distinctIpAddressesCount30d = distinctIpAddressesCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct IP addresses linked to the same bank account during Plaid authentication in the last 30 days (max 100)")
    public Integer getDistinctIpAddressesCount30d() {
        return this.distinctIpAddressesCount30d;
    }

    public void setDistinctIpAddressesCount30d(Integer distinctIpAddressesCount30d) {
        this.distinctIpAddressesCount30d = distinctIpAddressesCount30d;
    }

    public SignalEvaluateCoreAttributes distinctIpAddressesCount90d(Integer distinctIpAddressesCount90d) {
        this.distinctIpAddressesCount90d = distinctIpAddressesCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct IP addresses linked to the same bank account during Plaid authentication in the last 90 days (max 100)")
    public Integer getDistinctIpAddressesCount90d() {
        return this.distinctIpAddressesCount90d;
    }

    public void setDistinctIpAddressesCount90d(Integer distinctIpAddressesCount90d) {
        this.distinctIpAddressesCount90d = distinctIpAddressesCount90d;
    }

    public SignalEvaluateCoreAttributes distinctUserAgentsCount3d(Integer distinctUserAgentsCount3d) {
        this.distinctUserAgentsCount3d = distinctUserAgentsCount3d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct user agents linked to the same bank account during Plaid authentication in the last 3 days")
    public Integer getDistinctUserAgentsCount3d() {
        return this.distinctUserAgentsCount3d;
    }

    public void setDistinctUserAgentsCount3d(Integer distinctUserAgentsCount3d) {
        this.distinctUserAgentsCount3d = distinctUserAgentsCount3d;
    }

    public SignalEvaluateCoreAttributes distinctUserAgentsCount7d(Integer distinctUserAgentsCount7d) {
        this.distinctUserAgentsCount7d = distinctUserAgentsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct user agents linked to the same bank account during Plaid authentication in the last 7 days")
    public Integer getDistinctUserAgentsCount7d() {
        return this.distinctUserAgentsCount7d;
    }

    public void setDistinctUserAgentsCount7d(Integer distinctUserAgentsCount7d) {
        this.distinctUserAgentsCount7d = distinctUserAgentsCount7d;
    }

    public SignalEvaluateCoreAttributes distinctUserAgentsCount30d(Integer distinctUserAgentsCount30d) {
        this.distinctUserAgentsCount30d = distinctUserAgentsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct user agents linked to the same bank account during Plaid authentication in the last 30 days")
    public Integer getDistinctUserAgentsCount30d() {
        return this.distinctUserAgentsCount30d;
    }

    public void setDistinctUserAgentsCount30d(Integer distinctUserAgentsCount30d) {
        this.distinctUserAgentsCount30d = distinctUserAgentsCount30d;
    }

    public SignalEvaluateCoreAttributes distinctUserAgentsCount90d(Integer distinctUserAgentsCount90d) {
        this.distinctUserAgentsCount90d = distinctUserAgentsCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct user agents linked to the same bank account during Plaid authentication in the last 90 days")
    public Integer getDistinctUserAgentsCount90d() {
        return this.distinctUserAgentsCount90d;
    }

    public void setDistinctUserAgentsCount90d(Integer distinctUserAgentsCount90d) {
        this.distinctUserAgentsCount90d = distinctUserAgentsCount90d;
    }

    public SignalEvaluateCoreAttributes distinctSslTlsConnectionSessionsCount3d(Integer distinctSslTlsConnectionSessionsCount3d) {
        this.distinctSslTlsConnectionSessionsCount3d = distinctSslTlsConnectionSessionsCount3d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct SSL/TLS connection sessions linked to the same bank account during Plaid authentication in the last 3 days")
    public Integer getDistinctSslTlsConnectionSessionsCount3d() {
        return this.distinctSslTlsConnectionSessionsCount3d;
    }

    public void setDistinctSslTlsConnectionSessionsCount3d(Integer distinctSslTlsConnectionSessionsCount3d) {
        this.distinctSslTlsConnectionSessionsCount3d = distinctSslTlsConnectionSessionsCount3d;
    }

    public SignalEvaluateCoreAttributes distinctSslTlsConnectionSessionsCount7d(Integer distinctSslTlsConnectionSessionsCount7d) {
        this.distinctSslTlsConnectionSessionsCount7d = distinctSslTlsConnectionSessionsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct SSL/TLS connection sessions linked to the same bank account during Plaid authentication in the last 7 days")
    public Integer getDistinctSslTlsConnectionSessionsCount7d() {
        return this.distinctSslTlsConnectionSessionsCount7d;
    }

    public void setDistinctSslTlsConnectionSessionsCount7d(Integer distinctSslTlsConnectionSessionsCount7d) {
        this.distinctSslTlsConnectionSessionsCount7d = distinctSslTlsConnectionSessionsCount7d;
    }

    public SignalEvaluateCoreAttributes distinctSslTlsConnectionSessionsCount30d(Integer distinctSslTlsConnectionSessionsCount30d) {
        this.distinctSslTlsConnectionSessionsCount30d = distinctSslTlsConnectionSessionsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct SSL/TLS connection sessions linked to the same bank account during Plaid authentication in the last 30 days")
    public Integer getDistinctSslTlsConnectionSessionsCount30d() {
        return this.distinctSslTlsConnectionSessionsCount30d;
    }

    public void setDistinctSslTlsConnectionSessionsCount30d(Integer distinctSslTlsConnectionSessionsCount30d) {
        this.distinctSslTlsConnectionSessionsCount30d = distinctSslTlsConnectionSessionsCount30d;
    }

    public SignalEvaluateCoreAttributes distinctSslTlsConnectionSessionsCount90d(Integer distinctSslTlsConnectionSessionsCount90d) {
        this.distinctSslTlsConnectionSessionsCount90d = distinctSslTlsConnectionSessionsCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct SSL/TLS connection sessions linked to the same bank account during Plaid authentication in the last 90 days")
    public Integer getDistinctSslTlsConnectionSessionsCount90d() {
        return this.distinctSslTlsConnectionSessionsCount90d;
    }

    public void setDistinctSslTlsConnectionSessionsCount90d(Integer distinctSslTlsConnectionSessionsCount90d) {
        this.distinctSslTlsConnectionSessionsCount90d = distinctSslTlsConnectionSessionsCount90d;
    }

    public SignalEvaluateCoreAttributes daysSinceAccountOpening(Integer daysSinceAccountOpening) {
        this.daysSinceAccountOpening = daysSinceAccountOpening;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of days since the bank account was opened, as reported by the financial institution")
    public Integer getDaysSinceAccountOpening() {
        return this.daysSinceAccountOpening;
    }

    public void setDaysSinceAccountOpening(Integer daysSinceAccountOpening) {
        this.daysSinceAccountOpening = daysSinceAccountOpening;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalEvaluateCoreAttributes signalEvaluateCoreAttributes = (SignalEvaluateCoreAttributes)o;
        return Objects.equals(this.unauthorizedTransactionsCount7d, signalEvaluateCoreAttributes.unauthorizedTransactionsCount7d) && Objects.equals(this.unauthorizedTransactionsCount30d, signalEvaluateCoreAttributes.unauthorizedTransactionsCount30d) && Objects.equals(this.unauthorizedTransactionsCount60d, signalEvaluateCoreAttributes.unauthorizedTransactionsCount60d) && Objects.equals(this.unauthorizedTransactionsCount90d, signalEvaluateCoreAttributes.unauthorizedTransactionsCount90d) && Objects.equals(this.nsfOverdraftTransactionsCount7d, signalEvaluateCoreAttributes.nsfOverdraftTransactionsCount7d) && Objects.equals(this.nsfOverdraftTransactionsCount30d, signalEvaluateCoreAttributes.nsfOverdraftTransactionsCount30d) && Objects.equals(this.nsfOverdraftTransactionsCount60d, signalEvaluateCoreAttributes.nsfOverdraftTransactionsCount60d) && Objects.equals(this.nsfOverdraftTransactionsCount90d, signalEvaluateCoreAttributes.nsfOverdraftTransactionsCount90d) && Objects.equals(this.daysSinceFirstPlaidConnection, signalEvaluateCoreAttributes.daysSinceFirstPlaidConnection) && Objects.equals(this.plaidConnectionsCount7d, signalEvaluateCoreAttributes.plaidConnectionsCount7d) && Objects.equals(this.plaidConnectionsCount30d, signalEvaluateCoreAttributes.plaidConnectionsCount30d) && Objects.equals(this.totalPlaidConnectionsCount, signalEvaluateCoreAttributes.totalPlaidConnectionsCount) && Objects.equals(this.isSavingsOrMoneyMarketAccount, signalEvaluateCoreAttributes.isSavingsOrMoneyMarketAccount) && Objects.equals(this.totalCreditTransactionsAmount10d, signalEvaluateCoreAttributes.totalCreditTransactionsAmount10d) && Objects.equals(this.totalDebitTransactionsAmount10d, signalEvaluateCoreAttributes.totalDebitTransactionsAmount10d) && Objects.equals(this.p50CreditTransactionsAmount28d, signalEvaluateCoreAttributes.p50CreditTransactionsAmount28d) && Objects.equals(this.p50DebitTransactionsAmount28d, signalEvaluateCoreAttributes.p50DebitTransactionsAmount28d) && Objects.equals(this.p95CreditTransactionsAmount28d, signalEvaluateCoreAttributes.p95CreditTransactionsAmount28d) && Objects.equals(this.p95DebitTransactionsAmount28d, signalEvaluateCoreAttributes.p95DebitTransactionsAmount28d) && Objects.equals(this.daysWithNegativeBalanceCount90d, signalEvaluateCoreAttributes.daysWithNegativeBalanceCount90d) && Objects.equals(this.p90EodBalance30d, signalEvaluateCoreAttributes.p90EodBalance30d) && Objects.equals(this.p90EodBalance60d, signalEvaluateCoreAttributes.p90EodBalance60d) && Objects.equals(this.p90EodBalance90d, signalEvaluateCoreAttributes.p90EodBalance90d) && Objects.equals(this.p10EodBalance30d, signalEvaluateCoreAttributes.p10EodBalance30d) && Objects.equals(this.p10EodBalance60d, signalEvaluateCoreAttributes.p10EodBalance60d) && Objects.equals(this.p10EodBalance90d, signalEvaluateCoreAttributes.p10EodBalance90d) && Objects.equals(this.availableBalance, signalEvaluateCoreAttributes.availableBalance) && Objects.equals(this.currentBalance, signalEvaluateCoreAttributes.currentBalance) && Objects.equals(this.balanceLastUpdated, signalEvaluateCoreAttributes.balanceLastUpdated) && Objects.equals(this.phoneChangeCount28d, signalEvaluateCoreAttributes.phoneChangeCount28d) && Objects.equals(this.phoneChangeCount90d, signalEvaluateCoreAttributes.phoneChangeCount90d) && Objects.equals(this.emailChangeCount28d, signalEvaluateCoreAttributes.emailChangeCount28d) && Objects.equals(this.emailChangeCount90d, signalEvaluateCoreAttributes.emailChangeCount90d) && Objects.equals(this.addressChangeCount28d, signalEvaluateCoreAttributes.addressChangeCount28d) && Objects.equals(this.addressChangeCount90d, signalEvaluateCoreAttributes.addressChangeCount90d) && Objects.equals(this.plaidNonOauthAuthenticationAttemptsCount3d, signalEvaluateCoreAttributes.plaidNonOauthAuthenticationAttemptsCount3d) && Objects.equals(this.plaidNonOauthAuthenticationAttemptsCount7d, signalEvaluateCoreAttributes.plaidNonOauthAuthenticationAttemptsCount7d) && Objects.equals(this.plaidNonOauthAuthenticationAttemptsCount30d, signalEvaluateCoreAttributes.plaidNonOauthAuthenticationAttemptsCount30d) && Objects.equals(this.failedPlaidNonOauthAuthenticationAttemptsCount3d, signalEvaluateCoreAttributes.failedPlaidNonOauthAuthenticationAttemptsCount3d) && Objects.equals(this.failedPlaidNonOauthAuthenticationAttemptsCount7d, signalEvaluateCoreAttributes.failedPlaidNonOauthAuthenticationAttemptsCount7d) && Objects.equals(this.failedPlaidNonOauthAuthenticationAttemptsCount30d, signalEvaluateCoreAttributes.failedPlaidNonOauthAuthenticationAttemptsCount30d) && Objects.equals(this.debitTransactionsCount10d, signalEvaluateCoreAttributes.debitTransactionsCount10d) && Objects.equals(this.creditTransactionsCount10d, signalEvaluateCoreAttributes.creditTransactionsCount10d) && Objects.equals(this.debitTransactionsCount30d, signalEvaluateCoreAttributes.debitTransactionsCount30d) && Objects.equals(this.creditTransactionsCount30d, signalEvaluateCoreAttributes.creditTransactionsCount30d) && Objects.equals(this.debitTransactionsCount60d, signalEvaluateCoreAttributes.debitTransactionsCount60d) && Objects.equals(this.creditTransactionsCount60d, signalEvaluateCoreAttributes.creditTransactionsCount60d) && Objects.equals(this.debitTransactionsCount90d, signalEvaluateCoreAttributes.debitTransactionsCount90d) && Objects.equals(this.creditTransactionsCount90d, signalEvaluateCoreAttributes.creditTransactionsCount90d) && Objects.equals(this.totalDebitTransactionsAmount30d, signalEvaluateCoreAttributes.totalDebitTransactionsAmount30d) && Objects.equals(this.totalCreditTransactionsAmount30d, signalEvaluateCoreAttributes.totalCreditTransactionsAmount30d) && Objects.equals(this.totalDebitTransactionsAmount60d, signalEvaluateCoreAttributes.totalDebitTransactionsAmount60d) && Objects.equals(this.totalCreditTransactionsAmount60d, signalEvaluateCoreAttributes.totalCreditTransactionsAmount60d) && Objects.equals(this.totalDebitTransactionsAmount90d, signalEvaluateCoreAttributes.totalDebitTransactionsAmount90d) && Objects.equals(this.totalCreditTransactionsAmount90d, signalEvaluateCoreAttributes.totalCreditTransactionsAmount90d) && Objects.equals(this.p50EodBalance30d, signalEvaluateCoreAttributes.p50EodBalance30d) && Objects.equals(this.p50EodBalance60d, signalEvaluateCoreAttributes.p50EodBalance60d) && Objects.equals(this.p50EodBalance90d, signalEvaluateCoreAttributes.p50EodBalance90d) && Objects.equals(this.p50EodBalance31dTo60d, signalEvaluateCoreAttributes.p50EodBalance31dTo60d) && Objects.equals(this.p50EodBalance61dTo90d, signalEvaluateCoreAttributes.p50EodBalance61dTo90d) && Objects.equals(this.p90EodBalance31dTo60d, signalEvaluateCoreAttributes.p90EodBalance31dTo60d) && Objects.equals(this.p90EodBalance61dTo90d, signalEvaluateCoreAttributes.p90EodBalance61dTo90d) && Objects.equals(this.p10EodBalance31dTo60d, signalEvaluateCoreAttributes.p10EodBalance31dTo60d) && Objects.equals(this.p10EodBalance61dTo90d, signalEvaluateCoreAttributes.p10EodBalance61dTo90d) && Objects.equals(this.transactionsLastUpdated, signalEvaluateCoreAttributes.transactionsLastUpdated) && Objects.equals(this.isAccountClosed, signalEvaluateCoreAttributes.isAccountClosed) && Objects.equals(this.isAccountFrozenOrRestricted, signalEvaluateCoreAttributes.isAccountFrozenOrRestricted) && Objects.equals(this.distinctIpAddressesCount3d, signalEvaluateCoreAttributes.distinctIpAddressesCount3d) && Objects.equals(this.distinctIpAddressesCount7d, signalEvaluateCoreAttributes.distinctIpAddressesCount7d) && Objects.equals(this.distinctIpAddressesCount30d, signalEvaluateCoreAttributes.distinctIpAddressesCount30d) && Objects.equals(this.distinctIpAddressesCount90d, signalEvaluateCoreAttributes.distinctIpAddressesCount90d) && Objects.equals(this.distinctUserAgentsCount3d, signalEvaluateCoreAttributes.distinctUserAgentsCount3d) && Objects.equals(this.distinctUserAgentsCount7d, signalEvaluateCoreAttributes.distinctUserAgentsCount7d) && Objects.equals(this.distinctUserAgentsCount30d, signalEvaluateCoreAttributes.distinctUserAgentsCount30d) && Objects.equals(this.distinctUserAgentsCount90d, signalEvaluateCoreAttributes.distinctUserAgentsCount90d) && Objects.equals(this.distinctSslTlsConnectionSessionsCount3d, signalEvaluateCoreAttributes.distinctSslTlsConnectionSessionsCount3d) && Objects.equals(this.distinctSslTlsConnectionSessionsCount7d, signalEvaluateCoreAttributes.distinctSslTlsConnectionSessionsCount7d) && Objects.equals(this.distinctSslTlsConnectionSessionsCount30d, signalEvaluateCoreAttributes.distinctSslTlsConnectionSessionsCount30d) && Objects.equals(this.distinctSslTlsConnectionSessionsCount90d, signalEvaluateCoreAttributes.distinctSslTlsConnectionSessionsCount90d) && Objects.equals(this.daysSinceAccountOpening, signalEvaluateCoreAttributes.daysSinceAccountOpening);
    }

    public int hashCode() {
        return Objects.hash(this.unauthorizedTransactionsCount7d, this.unauthorizedTransactionsCount30d, this.unauthorizedTransactionsCount60d, this.unauthorizedTransactionsCount90d, this.nsfOverdraftTransactionsCount7d, this.nsfOverdraftTransactionsCount30d, this.nsfOverdraftTransactionsCount60d, this.nsfOverdraftTransactionsCount90d, this.daysSinceFirstPlaidConnection, this.plaidConnectionsCount7d, this.plaidConnectionsCount30d, this.totalPlaidConnectionsCount, this.isSavingsOrMoneyMarketAccount, this.totalCreditTransactionsAmount10d, this.totalDebitTransactionsAmount10d, this.p50CreditTransactionsAmount28d, this.p50DebitTransactionsAmount28d, this.p95CreditTransactionsAmount28d, this.p95DebitTransactionsAmount28d, this.daysWithNegativeBalanceCount90d, this.p90EodBalance30d, this.p90EodBalance60d, this.p90EodBalance90d, this.p10EodBalance30d, this.p10EodBalance60d, this.p10EodBalance90d, this.availableBalance, this.currentBalance, this.balanceLastUpdated, this.phoneChangeCount28d, this.phoneChangeCount90d, this.emailChangeCount28d, this.emailChangeCount90d, this.addressChangeCount28d, this.addressChangeCount90d, this.plaidNonOauthAuthenticationAttemptsCount3d, this.plaidNonOauthAuthenticationAttemptsCount7d, this.plaidNonOauthAuthenticationAttemptsCount30d, this.failedPlaidNonOauthAuthenticationAttemptsCount3d, this.failedPlaidNonOauthAuthenticationAttemptsCount7d, this.failedPlaidNonOauthAuthenticationAttemptsCount30d, this.debitTransactionsCount10d, this.creditTransactionsCount10d, this.debitTransactionsCount30d, this.creditTransactionsCount30d, this.debitTransactionsCount60d, this.creditTransactionsCount60d, this.debitTransactionsCount90d, this.creditTransactionsCount90d, this.totalDebitTransactionsAmount30d, this.totalCreditTransactionsAmount30d, this.totalDebitTransactionsAmount60d, this.totalCreditTransactionsAmount60d, this.totalDebitTransactionsAmount90d, this.totalCreditTransactionsAmount90d, this.p50EodBalance30d, this.p50EodBalance60d, this.p50EodBalance90d, this.p50EodBalance31dTo60d, this.p50EodBalance61dTo90d, this.p90EodBalance31dTo60d, this.p90EodBalance61dTo90d, this.p10EodBalance31dTo60d, this.p10EodBalance61dTo90d, this.transactionsLastUpdated, this.isAccountClosed, this.isAccountFrozenOrRestricted, this.distinctIpAddressesCount3d, this.distinctIpAddressesCount7d, this.distinctIpAddressesCount30d, this.distinctIpAddressesCount90d, this.distinctUserAgentsCount3d, this.distinctUserAgentsCount7d, this.distinctUserAgentsCount30d, this.distinctUserAgentsCount90d, this.distinctSslTlsConnectionSessionsCount3d, this.distinctSslTlsConnectionSessionsCount7d, this.distinctSslTlsConnectionSessionsCount30d, this.distinctSslTlsConnectionSessionsCount90d, this.daysSinceAccountOpening);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalEvaluateCoreAttributes {\n");
        sb.append("    unauthorizedTransactionsCount7d: ").append(this.toIndentedString(this.unauthorizedTransactionsCount7d)).append("\n");
        sb.append("    unauthorizedTransactionsCount30d: ").append(this.toIndentedString(this.unauthorizedTransactionsCount30d)).append("\n");
        sb.append("    unauthorizedTransactionsCount60d: ").append(this.toIndentedString(this.unauthorizedTransactionsCount60d)).append("\n");
        sb.append("    unauthorizedTransactionsCount90d: ").append(this.toIndentedString(this.unauthorizedTransactionsCount90d)).append("\n");
        sb.append("    nsfOverdraftTransactionsCount7d: ").append(this.toIndentedString(this.nsfOverdraftTransactionsCount7d)).append("\n");
        sb.append("    nsfOverdraftTransactionsCount30d: ").append(this.toIndentedString(this.nsfOverdraftTransactionsCount30d)).append("\n");
        sb.append("    nsfOverdraftTransactionsCount60d: ").append(this.toIndentedString(this.nsfOverdraftTransactionsCount60d)).append("\n");
        sb.append("    nsfOverdraftTransactionsCount90d: ").append(this.toIndentedString(this.nsfOverdraftTransactionsCount90d)).append("\n");
        sb.append("    daysSinceFirstPlaidConnection: ").append(this.toIndentedString(this.daysSinceFirstPlaidConnection)).append("\n");
        sb.append("    plaidConnectionsCount7d: ").append(this.toIndentedString(this.plaidConnectionsCount7d)).append("\n");
        sb.append("    plaidConnectionsCount30d: ").append(this.toIndentedString(this.plaidConnectionsCount30d)).append("\n");
        sb.append("    totalPlaidConnectionsCount: ").append(this.toIndentedString(this.totalPlaidConnectionsCount)).append("\n");
        sb.append("    isSavingsOrMoneyMarketAccount: ").append(this.toIndentedString(this.isSavingsOrMoneyMarketAccount)).append("\n");
        sb.append("    totalCreditTransactionsAmount10d: ").append(this.toIndentedString(this.totalCreditTransactionsAmount10d)).append("\n");
        sb.append("    totalDebitTransactionsAmount10d: ").append(this.toIndentedString(this.totalDebitTransactionsAmount10d)).append("\n");
        sb.append("    p50CreditTransactionsAmount28d: ").append(this.toIndentedString(this.p50CreditTransactionsAmount28d)).append("\n");
        sb.append("    p50DebitTransactionsAmount28d: ").append(this.toIndentedString(this.p50DebitTransactionsAmount28d)).append("\n");
        sb.append("    p95CreditTransactionsAmount28d: ").append(this.toIndentedString(this.p95CreditTransactionsAmount28d)).append("\n");
        sb.append("    p95DebitTransactionsAmount28d: ").append(this.toIndentedString(this.p95DebitTransactionsAmount28d)).append("\n");
        sb.append("    daysWithNegativeBalanceCount90d: ").append(this.toIndentedString(this.daysWithNegativeBalanceCount90d)).append("\n");
        sb.append("    p90EodBalance30d: ").append(this.toIndentedString(this.p90EodBalance30d)).append("\n");
        sb.append("    p90EodBalance60d: ").append(this.toIndentedString(this.p90EodBalance60d)).append("\n");
        sb.append("    p90EodBalance90d: ").append(this.toIndentedString(this.p90EodBalance90d)).append("\n");
        sb.append("    p10EodBalance30d: ").append(this.toIndentedString(this.p10EodBalance30d)).append("\n");
        sb.append("    p10EodBalance60d: ").append(this.toIndentedString(this.p10EodBalance60d)).append("\n");
        sb.append("    p10EodBalance90d: ").append(this.toIndentedString(this.p10EodBalance90d)).append("\n");
        sb.append("    availableBalance: ").append(this.toIndentedString(this.availableBalance)).append("\n");
        sb.append("    currentBalance: ").append(this.toIndentedString(this.currentBalance)).append("\n");
        sb.append("    balanceLastUpdated: ").append(this.toIndentedString(this.balanceLastUpdated)).append("\n");
        sb.append("    phoneChangeCount28d: ").append(this.toIndentedString(this.phoneChangeCount28d)).append("\n");
        sb.append("    phoneChangeCount90d: ").append(this.toIndentedString(this.phoneChangeCount90d)).append("\n");
        sb.append("    emailChangeCount28d: ").append(this.toIndentedString(this.emailChangeCount28d)).append("\n");
        sb.append("    emailChangeCount90d: ").append(this.toIndentedString(this.emailChangeCount90d)).append("\n");
        sb.append("    addressChangeCount28d: ").append(this.toIndentedString(this.addressChangeCount28d)).append("\n");
        sb.append("    addressChangeCount90d: ").append(this.toIndentedString(this.addressChangeCount90d)).append("\n");
        sb.append("    plaidNonOauthAuthenticationAttemptsCount3d: ").append(this.toIndentedString(this.plaidNonOauthAuthenticationAttemptsCount3d)).append("\n");
        sb.append("    plaidNonOauthAuthenticationAttemptsCount7d: ").append(this.toIndentedString(this.plaidNonOauthAuthenticationAttemptsCount7d)).append("\n");
        sb.append("    plaidNonOauthAuthenticationAttemptsCount30d: ").append(this.toIndentedString(this.plaidNonOauthAuthenticationAttemptsCount30d)).append("\n");
        sb.append("    failedPlaidNonOauthAuthenticationAttemptsCount3d: ").append(this.toIndentedString(this.failedPlaidNonOauthAuthenticationAttemptsCount3d)).append("\n");
        sb.append("    failedPlaidNonOauthAuthenticationAttemptsCount7d: ").append(this.toIndentedString(this.failedPlaidNonOauthAuthenticationAttemptsCount7d)).append("\n");
        sb.append("    failedPlaidNonOauthAuthenticationAttemptsCount30d: ").append(this.toIndentedString(this.failedPlaidNonOauthAuthenticationAttemptsCount30d)).append("\n");
        sb.append("    debitTransactionsCount10d: ").append(this.toIndentedString(this.debitTransactionsCount10d)).append("\n");
        sb.append("    creditTransactionsCount10d: ").append(this.toIndentedString(this.creditTransactionsCount10d)).append("\n");
        sb.append("    debitTransactionsCount30d: ").append(this.toIndentedString(this.debitTransactionsCount30d)).append("\n");
        sb.append("    creditTransactionsCount30d: ").append(this.toIndentedString(this.creditTransactionsCount30d)).append("\n");
        sb.append("    debitTransactionsCount60d: ").append(this.toIndentedString(this.debitTransactionsCount60d)).append("\n");
        sb.append("    creditTransactionsCount60d: ").append(this.toIndentedString(this.creditTransactionsCount60d)).append("\n");
        sb.append("    debitTransactionsCount90d: ").append(this.toIndentedString(this.debitTransactionsCount90d)).append("\n");
        sb.append("    creditTransactionsCount90d: ").append(this.toIndentedString(this.creditTransactionsCount90d)).append("\n");
        sb.append("    totalDebitTransactionsAmount30d: ").append(this.toIndentedString(this.totalDebitTransactionsAmount30d)).append("\n");
        sb.append("    totalCreditTransactionsAmount30d: ").append(this.toIndentedString(this.totalCreditTransactionsAmount30d)).append("\n");
        sb.append("    totalDebitTransactionsAmount60d: ").append(this.toIndentedString(this.totalDebitTransactionsAmount60d)).append("\n");
        sb.append("    totalCreditTransactionsAmount60d: ").append(this.toIndentedString(this.totalCreditTransactionsAmount60d)).append("\n");
        sb.append("    totalDebitTransactionsAmount90d: ").append(this.toIndentedString(this.totalDebitTransactionsAmount90d)).append("\n");
        sb.append("    totalCreditTransactionsAmount90d: ").append(this.toIndentedString(this.totalCreditTransactionsAmount90d)).append("\n");
        sb.append("    p50EodBalance30d: ").append(this.toIndentedString(this.p50EodBalance30d)).append("\n");
        sb.append("    p50EodBalance60d: ").append(this.toIndentedString(this.p50EodBalance60d)).append("\n");
        sb.append("    p50EodBalance90d: ").append(this.toIndentedString(this.p50EodBalance90d)).append("\n");
        sb.append("    p50EodBalance31dTo60d: ").append(this.toIndentedString(this.p50EodBalance31dTo60d)).append("\n");
        sb.append("    p50EodBalance61dTo90d: ").append(this.toIndentedString(this.p50EodBalance61dTo90d)).append("\n");
        sb.append("    p90EodBalance31dTo60d: ").append(this.toIndentedString(this.p90EodBalance31dTo60d)).append("\n");
        sb.append("    p90EodBalance61dTo90d: ").append(this.toIndentedString(this.p90EodBalance61dTo90d)).append("\n");
        sb.append("    p10EodBalance31dTo60d: ").append(this.toIndentedString(this.p10EodBalance31dTo60d)).append("\n");
        sb.append("    p10EodBalance61dTo90d: ").append(this.toIndentedString(this.p10EodBalance61dTo90d)).append("\n");
        sb.append("    transactionsLastUpdated: ").append(this.toIndentedString(this.transactionsLastUpdated)).append("\n");
        sb.append("    isAccountClosed: ").append(this.toIndentedString(this.isAccountClosed)).append("\n");
        sb.append("    isAccountFrozenOrRestricted: ").append(this.toIndentedString(this.isAccountFrozenOrRestricted)).append("\n");
        sb.append("    distinctIpAddressesCount3d: ").append(this.toIndentedString(this.distinctIpAddressesCount3d)).append("\n");
        sb.append("    distinctIpAddressesCount7d: ").append(this.toIndentedString(this.distinctIpAddressesCount7d)).append("\n");
        sb.append("    distinctIpAddressesCount30d: ").append(this.toIndentedString(this.distinctIpAddressesCount30d)).append("\n");
        sb.append("    distinctIpAddressesCount90d: ").append(this.toIndentedString(this.distinctIpAddressesCount90d)).append("\n");
        sb.append("    distinctUserAgentsCount3d: ").append(this.toIndentedString(this.distinctUserAgentsCount3d)).append("\n");
        sb.append("    distinctUserAgentsCount7d: ").append(this.toIndentedString(this.distinctUserAgentsCount7d)).append("\n");
        sb.append("    distinctUserAgentsCount30d: ").append(this.toIndentedString(this.distinctUserAgentsCount30d)).append("\n");
        sb.append("    distinctUserAgentsCount90d: ").append(this.toIndentedString(this.distinctUserAgentsCount90d)).append("\n");
        sb.append("    distinctSslTlsConnectionSessionsCount3d: ").append(this.toIndentedString(this.distinctSslTlsConnectionSessionsCount3d)).append("\n");
        sb.append("    distinctSslTlsConnectionSessionsCount7d: ").append(this.toIndentedString(this.distinctSslTlsConnectionSessionsCount7d)).append("\n");
        sb.append("    distinctSslTlsConnectionSessionsCount30d: ").append(this.toIndentedString(this.distinctSslTlsConnectionSessionsCount30d)).append("\n");
        sb.append("    distinctSslTlsConnectionSessionsCount90d: ").append(this.toIndentedString(this.distinctSslTlsConnectionSessionsCount90d)).append("\n");
        sb.append("    daysSinceAccountOpening: ").append(this.toIndentedString(this.daysSinceAccountOpening)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

