/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.SignalDevice;
import com.plaid.client.model.SignalUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SignalEvaluateRequest defines the request schema for `/signal/evaluate`")
public class SignalEvaluateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_CLIENT_TRANSACTION_ID = "client_transaction_id";
    @SerializedName(value="client_transaction_id")
    private String clientTransactionId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_USER_PRESENT = "user_present";
    @SerializedName(value="user_present")
    private Boolean userPresent;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_IS_RECURRING = "is_recurring";
    @SerializedName(value="is_recurring")
    private Boolean isRecurring;
    public static final String SERIALIZED_NAME_DEFAULT_PAYMENT_METHOD = "default_payment_method";
    @SerializedName(value="default_payment_method")
    private String defaultPaymentMethod;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private SignalUser user;
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    private SignalDevice device;
    public static final String SERIALIZED_NAME_RISK_PROFILE_KEY = "risk_profile_key";
    @SerializedName(value="risk_profile_key")
    private String riskProfileKey;
    public static final String SERIALIZED_NAME_RULESET_KEY = "ruleset_key";
    @SerializedName(value="ruleset_key")
    private String rulesetKey;

    public SignalEvaluateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SignalEvaluateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SignalEvaluateRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public SignalEvaluateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `account_id` of the account that is the funding source for the proposed transaction. The `account_id` is returned in the `/accounts/get` endpoint as well as the [`onSuccess`](/docs/link/ios/#link-ios-onsuccess-linkSuccess-metadata-accounts-id) callback metadata.  This will return an [`INVALID_ACCOUNT_ID`](/docs/errors/invalid-input/#invalid_account_id) error if the account has been removed at the bank or if the `account_id` is no longer valid.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public SignalEvaluateRequest clientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID that you would like to use to refer to this transaction. For your convenience mapping your internal data, you could use your internal ID/identifier for this transaction. The max length for this field is 36 characters.")
    public String getClientTransactionId() {
        return this.clientTransactionId;
    }

    public void setClientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
    }

    public SignalEvaluateRequest amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The transaction amount, in USD (e.g. `102.05`)")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public SignalEvaluateRequest userPresent(Boolean userPresent) {
        this.userPresent = userPresent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`true` if the end user is present while initiating the ACH transfer and the endpoint is being called; `false` otherwise (for example, when the ACH transfer is scheduled and the end user is not present, or you call this endpoint after the ACH transfer but before submitting the Nacha file for ACH processing).")
    public Boolean getUserPresent() {
        return this.userPresent;
    }

    public void setUserPresent(Boolean userPresent) {
        this.userPresent = userPresent;
    }

    public SignalEvaluateRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique ID that identifies the end user in your system. This ID is used to correlate requests by a user with multiple Items. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public SignalEvaluateRequest isRecurring(Boolean isRecurring) {
        this.isRecurring = isRecurring;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`true` if the ACH transaction is a recurring transaction; `false` otherwise ")
    public Boolean getIsRecurring() {
        return this.isRecurring;
    }

    public void setIsRecurring(Boolean isRecurring) {
        this.isRecurring = isRecurring;
    }

    public SignalEvaluateRequest defaultPaymentMethod(String defaultPaymentMethod) {
        this.defaultPaymentMethod = defaultPaymentMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default ACH or non-ACH payment method to complete the transaction. `SAME_DAY_ACH`: Same Day ACH by NACHA. The debit transaction is processed and settled on the same day `NEXT_DAY_ACH`: Next Day ACH settlement for debit transactions, offered by some payment processors `STANDARD_ACH`: standard ACH by NACHA `REAL_TIME_PAYMENTS`: real-time payments such as RTP and FedNow `DEBIT_CARD`: if the default payment is over debit card networks `MULTIPLE_PAYMENT_METHODS`: if there is no default debit rail or there are multiple payment methods Possible values:  `SAME_DAY_ACH`, `NEXT_DAY_ACH`, `STANDARD_ACH`, `REAL_TIME_PAYMENTS`, `DEBIT_CARD`, `MULTIPLE_PAYMENT_METHODS`")
    public String getDefaultPaymentMethod() {
        return this.defaultPaymentMethod;
    }

    public void setDefaultPaymentMethod(String defaultPaymentMethod) {
        this.defaultPaymentMethod = defaultPaymentMethod;
    }

    public SignalEvaluateRequest user(SignalUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SignalUser getUser() {
        return this.user;
    }

    public void setUser(SignalUser user) {
        this.user = user;
    }

    public SignalEvaluateRequest device(SignalDevice device) {
        this.device = device;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SignalDevice getDevice() {
        return this.device;
    }

    public void setDevice(SignalDevice device) {
        this.device = device;
    }

    public SignalEvaluateRequest riskProfileKey(String riskProfileKey) {
        this.riskProfileKey = riskProfileKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifying `risk_profile_key` is deprecated. Please provide `ruleset` instead.")
    public String getRiskProfileKey() {
        return this.riskProfileKey;
    }

    public void setRiskProfileKey(String riskProfileKey) {
        this.riskProfileKey = riskProfileKey;
    }

    public SignalEvaluateRequest rulesetKey(String rulesetKey) {
        this.rulesetKey = rulesetKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the Ruleset to use for this transaction. You can configure a Ruleset using the Signal dashboard located within the Plaid Dashboard. If not provided, no Ruleset will be used. This feature is currently in closed beta; to request access, contact your account manager.")
    public String getRulesetKey() {
        return this.rulesetKey;
    }

    public void setRulesetKey(String rulesetKey) {
        this.rulesetKey = rulesetKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalEvaluateRequest signalEvaluateRequest = (SignalEvaluateRequest)o;
        return Objects.equals(this.clientId, signalEvaluateRequest.clientId) && Objects.equals(this.secret, signalEvaluateRequest.secret) && Objects.equals(this.accessToken, signalEvaluateRequest.accessToken) && Objects.equals(this.accountId, signalEvaluateRequest.accountId) && Objects.equals(this.clientTransactionId, signalEvaluateRequest.clientTransactionId) && Objects.equals(this.amount, signalEvaluateRequest.amount) && Objects.equals(this.userPresent, signalEvaluateRequest.userPresent) && Objects.equals(this.clientUserId, signalEvaluateRequest.clientUserId) && Objects.equals(this.isRecurring, signalEvaluateRequest.isRecurring) && Objects.equals(this.defaultPaymentMethod, signalEvaluateRequest.defaultPaymentMethod) && Objects.equals(this.user, signalEvaluateRequest.user) && Objects.equals(this.device, signalEvaluateRequest.device) && Objects.equals(this.riskProfileKey, signalEvaluateRequest.riskProfileKey) && Objects.equals(this.rulesetKey, signalEvaluateRequest.rulesetKey);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.accessToken, this.accountId, this.clientTransactionId, this.amount, this.userPresent, this.clientUserId, this.isRecurring, this.defaultPaymentMethod, this.user, this.device, this.riskProfileKey, this.rulesetKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalEvaluateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    clientTransactionId: ").append(this.toIndentedString(this.clientTransactionId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    userPresent: ").append(this.toIndentedString(this.userPresent)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    isRecurring: ").append(this.toIndentedString(this.isRecurring)).append("\n");
        sb.append("    defaultPaymentMethod: ").append(this.toIndentedString(this.defaultPaymentMethod)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    riskProfileKey: ").append(this.toIndentedString(this.riskProfileKey)).append("\n");
        sb.append("    rulesetKey: ").append(this.toIndentedString(this.rulesetKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

