/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.RiskProfile;
import com.plaid.client.model.Ruleset;
import com.plaid.client.model.SignalEvaluateCoreAttributes;
import com.plaid.client.model.SignalScores;
import com.plaid.client.model.SignalWarning;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SignalEvaluateResponse defines the response schema for `/signal/income/evaluate`")
public class SignalEvaluateResponse {
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_SCORES = "scores";
    @SerializedName(value="scores")
    private SignalScores scores;
    public static final String SERIALIZED_NAME_CORE_ATTRIBUTES = "core_attributes";
    @SerializedName(value="core_attributes")
    private SignalEvaluateCoreAttributes coreAttributes;
    public static final String SERIALIZED_NAME_RISK_PROFILE = "risk_profile";
    @SerializedName(value="risk_profile")
    private RiskProfile riskProfile;
    public static final String SERIALIZED_NAME_RULESET = "ruleset";
    @SerializedName(value="ruleset")
    private Ruleset ruleset;
    public static final String SERIALIZED_NAME_WARNINGS = "warnings";
    @SerializedName(value="warnings")
    private List<SignalWarning> warnings = new ArrayList<SignalWarning>();

    public SignalEvaluateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public SignalEvaluateResponse scores(SignalScores scores) {
        this.scores = scores;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public SignalScores getScores() {
        return this.scores;
    }

    public void setScores(SignalScores scores) {
        this.scores = scores;
    }

    public SignalEvaluateResponse coreAttributes(SignalEvaluateCoreAttributes coreAttributes) {
        this.coreAttributes = coreAttributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SignalEvaluateCoreAttributes getCoreAttributes() {
        return this.coreAttributes;
    }

    public void setCoreAttributes(SignalEvaluateCoreAttributes coreAttributes) {
        this.coreAttributes = coreAttributes;
    }

    public SignalEvaluateResponse riskProfile(RiskProfile riskProfile) {
        this.riskProfile = riskProfile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RiskProfile getRiskProfile() {
        return this.riskProfile;
    }

    public void setRiskProfile(RiskProfile riskProfile) {
        this.riskProfile = riskProfile;
    }

    public SignalEvaluateResponse ruleset(Ruleset ruleset) {
        this.ruleset = ruleset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Ruleset getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    public SignalEvaluateResponse warnings(List<SignalWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public SignalEvaluateResponse addWarningsItem(SignalWarning warningsItem) {
        this.warnings.add(warningsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="If bank information was not available to be used in the Signal model, this array contains warnings describing why bank data is missing. If you want to receive an API error instead of Signal scores in the case of missing bank data, file a support ticket or contact your Plaid account manager.")
    public List<SignalWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<SignalWarning> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalEvaluateResponse signalEvaluateResponse = (SignalEvaluateResponse)o;
        return Objects.equals(this.requestId, signalEvaluateResponse.requestId) && Objects.equals(this.scores, signalEvaluateResponse.scores) && Objects.equals(this.coreAttributes, signalEvaluateResponse.coreAttributes) && Objects.equals(this.riskProfile, signalEvaluateResponse.riskProfile) && Objects.equals(this.ruleset, signalEvaluateResponse.ruleset) && Objects.equals(this.warnings, signalEvaluateResponse.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.scores, this.coreAttributes, this.riskProfile, this.ruleset, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalEvaluateResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    scores: ").append(this.toIndentedString(this.scores)).append("\n");
        sb.append("    coreAttributes: ").append(this.toIndentedString(this.coreAttributes)).append("\n");
        sb.append("    riskProfile: ").append(this.toIndentedString(this.riskProfile)).append("\n");
        sb.append("    ruleset: ").append(this.toIndentedString(this.ruleset)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

