/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SignalReturnReportRequest defines the request schema for `/signal/return/report`")
public class SignalReturnReportRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CLIENT_TRANSACTION_ID = "client_transaction_id";
    @SerializedName(value="client_transaction_id")
    private String clientTransactionId;
    public static final String SERIALIZED_NAME_RETURN_CODE = "return_code";
    @SerializedName(value="return_code")
    private String returnCode;
    public static final String SERIALIZED_NAME_RETURNED_AT = "returned_at";
    @SerializedName(value="returned_at")
    private OffsetDateTime returnedAt;

    public SignalReturnReportRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SignalReturnReportRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SignalReturnReportRequest clientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="Must be the same as the `client_transaction_id` supplied when calling `/signal/evaluate` or `/accounts/balance/get`.")
    public String getClientTransactionId() {
        return this.clientTransactionId;
    }

    public void setClientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
    }

    public SignalReturnReportRequest returnCode(String returnCode) {
        this.returnCode = returnCode;
        return this;
    }

    @ApiModelProperty(required=true, value="Must be a valid ACH return code (e.g. \"R01\")  If formatted incorrectly, this will result in an [`INVALID_FIELD`](/docs/errors/invalid-request/#invalid_field) error.")
    public String getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public SignalReturnReportRequest returnedAt(OffsetDateTime returnedAt) {
        this.returnedAt = returnedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date and time when you receive the returns from your payment processors, in ISO 8601 format (`YYYY-MM-DDTHH:mm:ssZ`).")
    public OffsetDateTime getReturnedAt() {
        return this.returnedAt;
    }

    public void setReturnedAt(OffsetDateTime returnedAt) {
        this.returnedAt = returnedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalReturnReportRequest signalReturnReportRequest = (SignalReturnReportRequest)o;
        return Objects.equals(this.clientId, signalReturnReportRequest.clientId) && Objects.equals(this.secret, signalReturnReportRequest.secret) && Objects.equals(this.clientTransactionId, signalReturnReportRequest.clientTransactionId) && Objects.equals(this.returnCode, signalReturnReportRequest.returnCode) && Objects.equals(this.returnedAt, signalReturnReportRequest.returnedAt);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.clientTransactionId, this.returnCode, this.returnedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalReturnReportRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    clientTransactionId: ").append(this.toIndentedString(this.clientTransactionId)).append("\n");
        sb.append("    returnCode: ").append(this.toIndentedString(this.returnCode)).append("\n");
        sb.append("    returnedAt: ").append(this.toIndentedString(this.returnedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

