/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.SignalAddressData;
import com.plaid.client.model.SignalPersonName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details about the end user initiating the transaction (i.e., the account holder). When calling `/signal/evaluate` or `/signal/processor/evaluate`, this field is optional, but strongly recommended to increase the accuracy of Signal results.")
public class SignalUser {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private SignalPersonName name;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private String emailAddress;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private SignalAddressData address;

    public SignalUser name(SignalPersonName name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SignalPersonName getName() {
        return this.name;
    }

    public void setName(SignalPersonName name) {
        this.name = name;
    }

    public SignalUser phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's phone number, in E.164 format: +{countrycode}{number}. For example: \"+14151234567\"")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public SignalUser emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public SignalUser address(SignalAddressData address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SignalAddressData getAddress() {
        return this.address;
    }

    public void setAddress(SignalAddressData address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalUser signalUser = (SignalUser)o;
        return Objects.equals(this.name, signalUser.name) && Objects.equals(this.phoneNumber, signalUser.phoneNumber) && Objects.equals(this.emailAddress, signalUser.emailAddress) && Objects.equals(this.address, signalUser.address);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phoneNumber, this.emailAddress, this.address);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalUser {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

