/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Conveys information about the errors causing missing or stale bank data used to construct the /signal/evaluate scores and response")
public class SignalWarning {
    public static final String SERIALIZED_NAME_WARNING_TYPE = "warning_type";
    @SerializedName(value="warning_type")
    private String warningType;
    public static final String SERIALIZED_NAME_WARNING_CODE = "warning_code";
    @SerializedName(value="warning_code")
    private String warningCode;
    public static final String SERIALIZED_NAME_WARNING_MESSAGE = "warning_message";
    @SerializedName(value="warning_message")
    private String warningMessage;

    public SignalWarning warningType(String warningType) {
        this.warningType = warningType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A broad categorization of the warning. Safe for programmatic use.")
    public String getWarningType() {
        return this.warningType;
    }

    public void setWarningType(String warningType) {
        this.warningType = warningType;
    }

    public SignalWarning warningCode(String warningCode) {
        this.warningCode = warningCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The warning code identifies a specific kind of warning that pertains to the error causing bank data to be missing. Safe for programmatic use. For more details on warning codes, please refer to Plaid standard error codes documentation. If you receive the `ITEM_LOGIN_REQUIRED` warning, we recommend re-authenticating your user by implementing Link's update mode. This will guide your user to fix their credentials, allowing Plaid to start fetching data again for future Signal requests.")
    public String getWarningCode() {
        return this.warningCode;
    }

    public void setWarningCode(String warningCode) {
        this.warningCode = warningCode;
    }

    public SignalWarning warningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A developer-friendly representation of the warning type. This may change over time and is not safe for programmatic use.")
    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalWarning signalWarning = (SignalWarning)o;
        return Objects.equals(this.warningType, signalWarning.warningType) && Objects.equals(this.warningCode, signalWarning.warningCode) && Objects.equals(this.warningMessage, signalWarning.warningMessage);
    }

    public int hashCode() {
        return Objects.hash(this.warningType, this.warningCode, this.warningMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalWarning {\n");
        sb.append("    warningType: ").append(this.toIndentedString(this.warningType)).append("\n");
        sb.append("    warningCode: ").append(this.toIndentedString(this.warningCode)).append("\n");
        sb.append("    warningMessage: ").append(this.toIndentedString(this.warningMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

