/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DocumentRiskSignal;
import com.plaid.client.model.DocumentRiskSummary;
import com.plaid.client.model.RiskSignalDocumentReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Object containing all risk signals and relevant metadata for a single document")
public class SingleDocumentRiskSignal {
    public static final String SERIALIZED_NAME_DOCUMENT_REFERENCE = "document_reference";
    @SerializedName(value="document_reference")
    private RiskSignalDocumentReference documentReference;
    public static final String SERIALIZED_NAME_RISK_SIGNALS = "risk_signals";
    @SerializedName(value="risk_signals")
    private List<DocumentRiskSignal> riskSignals = new ArrayList<DocumentRiskSignal>();
    public static final String SERIALIZED_NAME_RISK_SUMMARY = "risk_summary";
    @SerializedName(value="risk_summary")
    private DocumentRiskSummary riskSummary;

    public SingleDocumentRiskSignal documentReference(RiskSignalDocumentReference documentReference) {
        this.documentReference = documentReference;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public RiskSignalDocumentReference getDocumentReference() {
        return this.documentReference;
    }

    public void setDocumentReference(RiskSignalDocumentReference documentReference) {
        this.documentReference = documentReference;
    }

    public SingleDocumentRiskSignal riskSignals(List<DocumentRiskSignal> riskSignals) {
        this.riskSignals = riskSignals;
        return this;
    }

    public SingleDocumentRiskSignal addRiskSignalsItem(DocumentRiskSignal riskSignalsItem) {
        this.riskSignals.add(riskSignalsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of attributes that indicate whether or not there is fraud risk with a document")
    public List<DocumentRiskSignal> getRiskSignals() {
        return this.riskSignals;
    }

    public void setRiskSignals(List<DocumentRiskSignal> riskSignals) {
        this.riskSignals = riskSignals;
    }

    public SingleDocumentRiskSignal riskSummary(DocumentRiskSummary riskSummary) {
        this.riskSummary = riskSummary;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DocumentRiskSummary getRiskSummary() {
        return this.riskSummary;
    }

    public void setRiskSummary(DocumentRiskSummary riskSummary) {
        this.riskSummary = riskSummary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleDocumentRiskSignal singleDocumentRiskSignal = (SingleDocumentRiskSignal)o;
        return Objects.equals(this.documentReference, singleDocumentRiskSignal.documentReference) && Objects.equals(this.riskSignals, singleDocumentRiskSignal.riskSignals) && Objects.equals(this.riskSummary, singleDocumentRiskSignal.riskSummary);
    }

    public int hashCode() {
        return Objects.hash(this.documentReference, this.riskSignals, this.riskSummary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SingleDocumentRiskSignal {\n");
        sb.append("    documentReference: ").append(this.toIndentedString(this.documentReference)).append("\n");
        sb.append("    riskSignals: ").append(this.toIndentedString(this.riskSignals)).append("\n");
        sb.append("    riskSummary: ").append(this.toIndentedString(this.riskSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

