/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The schema below describes the various `types` and corresponding `subtypes` that Plaid recognizes and reports for financial institution accounts.")
public class StandaloneAccountType {
    public static final String SERIALIZED_NAME_DEPOSITORY = "depository";
    @SerializedName(value="depository")
    private String depository;
    public static final String SERIALIZED_NAME_CREDIT = "credit";
    @SerializedName(value="credit")
    private String credit;
    public static final String SERIALIZED_NAME_LOAN = "loan";
    @SerializedName(value="loan")
    private String loan;
    public static final String SERIALIZED_NAME_INVESTMENT = "investment";
    @SerializedName(value="investment")
    private String investment;
    public static final String SERIALIZED_NAME_OTHER = "other";
    @SerializedName(value="other")
    private String other;

    public StandaloneAccountType depository(String depository) {
        this.depository = depository;
        return this;
    }

    @ApiModelProperty(required=true, value="An account type holding cash, in which funds are deposited. Supported products for `depository` accounts are: Auth (`checking` and `savings` types only), Transfer, Balance, Signal, Income, Transactions, Identity, Payment Initiation, Assets, and Investments (`cash management` type only).")
    public String getDepository() {
        return this.depository;
    }

    public void setDepository(String depository) {
        this.depository = depository;
    }

    public StandaloneAccountType credit(String credit) {
        this.credit = credit;
        return this;
    }

    @ApiModelProperty(required=true, value="A credit card type account. Supported products for `credit` accounts are: Balance, Transactions, Identity, Assets, and Liabilities.")
    public String getCredit() {
        return this.credit;
    }

    public void setCredit(String credit) {
        this.credit = credit;
    }

    public StandaloneAccountType loan(String loan) {
        this.loan = loan;
        return this;
    }

    @ApiModelProperty(required=true, value="A loan type account. Supported products for `loan` accounts are: Balance, Liabilities, Assets, and Transactions.")
    public String getLoan() {
        return this.loan;
    }

    public void setLoan(String loan) {
        this.loan = loan;
    }

    public StandaloneAccountType investment(String investment) {
        this.investment = investment;
        return this;
    }

    @ApiModelProperty(required=true, value="An investment account. Supported products for `investment` accounts are: Balance, Assets, and Investments. In API versions 2018-05-22 and earlier, this type is called `brokerage`.")
    public String getInvestment() {
        return this.investment;
    }

    public void setInvestment(String investment) {
        this.investment = investment;
    }

    public StandaloneAccountType other(String other) {
        this.other = other;
        return this;
    }

    @ApiModelProperty(required=true, value="Other or unknown account type. Supported products for `other` accounts are: Balance, Transactions, Identity, and Assets.")
    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandaloneAccountType standaloneAccountType = (StandaloneAccountType)o;
        return Objects.equals(this.depository, standaloneAccountType.depository) && Objects.equals(this.credit, standaloneAccountType.credit) && Objects.equals(this.loan, standaloneAccountType.loan) && Objects.equals(this.investment, standaloneAccountType.investment) && Objects.equals(this.other, standaloneAccountType.other);
    }

    public int hashCode() {
        return Objects.hash(this.depository, this.credit, this.loan, this.investment, this.other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StandaloneAccountType {\n");
        sb.append("    depository: ").append(this.toIndentedString(this.depository)).append("\n");
        sb.append("    credit: ").append(this.toIndentedString(this.credit)).append("\n");
        sb.append("    loan: ").append(this.toIndentedString(this.loan)).append("\n");
        sb.append("    investment: ").append(this.toIndentedString(this.investment)).append("\n");
        sb.append("    other: ").append(this.toIndentedString(this.other)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

