/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Valid values for investment transaction types and subtypes. Note that transactions representing inflow of cash will appear as negative amounts, outflow of cash will appear as positive amounts.")
public class StandaloneInvestmentTransactionType {
    public static final String SERIALIZED_NAME_BUY = "buy";
    @SerializedName(value="buy")
    private String buy;
    public static final String SERIALIZED_NAME_SELL = "sell";
    @SerializedName(value="sell")
    private String sell;
    public static final String SERIALIZED_NAME_CANCEL = "cancel";
    @SerializedName(value="cancel")
    private String cancel;
    public static final String SERIALIZED_NAME_CASH = "cash";
    @SerializedName(value="cash")
    private String cash;
    public static final String SERIALIZED_NAME_FEE = "fee";
    @SerializedName(value="fee")
    private String fee;
    public static final String SERIALIZED_NAME_TRANSFER = "transfer";
    @SerializedName(value="transfer")
    private String transfer;

    public StandaloneInvestmentTransactionType buy(String buy) {
        this.buy = buy;
        return this;
    }

    @ApiModelProperty(required=true, value="Buying an investment")
    public String getBuy() {
        return this.buy;
    }

    public void setBuy(String buy) {
        this.buy = buy;
    }

    public StandaloneInvestmentTransactionType sell(String sell) {
        this.sell = sell;
        return this;
    }

    @ApiModelProperty(required=true, value="Selling an investment")
    public String getSell() {
        return this.sell;
    }

    public void setSell(String sell) {
        this.sell = sell;
    }

    public StandaloneInvestmentTransactionType cancel(String cancel) {
        this.cancel = cancel;
        return this;
    }

    @ApiModelProperty(required=true, value="A cancellation of a pending transaction")
    public String getCancel() {
        return this.cancel;
    }

    public void setCancel(String cancel) {
        this.cancel = cancel;
    }

    public StandaloneInvestmentTransactionType cash(String cash) {
        this.cash = cash;
        return this;
    }

    @ApiModelProperty(required=true, value="Activity that modifies a cash position")
    public String getCash() {
        return this.cash;
    }

    public void setCash(String cash) {
        this.cash = cash;
    }

    public StandaloneInvestmentTransactionType fee(String fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(required=true, value="Fees on the account, e.g. commission, bookkeeping, options-related.")
    public String getFee() {
        return this.fee;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    public StandaloneInvestmentTransactionType transfer(String transfer) {
        this.transfer = transfer;
        return this;
    }

    @ApiModelProperty(required=true, value="Activity that modifies a position, but not through buy/sell activity e.g. options exercise, portfolio transfer")
    public String getTransfer() {
        return this.transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandaloneInvestmentTransactionType standaloneInvestmentTransactionType = (StandaloneInvestmentTransactionType)o;
        return Objects.equals(this.buy, standaloneInvestmentTransactionType.buy) && Objects.equals(this.sell, standaloneInvestmentTransactionType.sell) && Objects.equals(this.cancel, standaloneInvestmentTransactionType.cancel) && Objects.equals(this.cash, standaloneInvestmentTransactionType.cash) && Objects.equals(this.fee, standaloneInvestmentTransactionType.fee) && Objects.equals(this.transfer, standaloneInvestmentTransactionType.transfer);
    }

    public int hashCode() {
        return Objects.hash(this.buy, this.sell, this.cancel, this.cash, this.fee, this.transfer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StandaloneInvestmentTransactionType {\n");
        sb.append("    buy: ").append(this.toIndentedString(this.buy)).append("\n");
        sb.append("    sell: ").append(this.toIndentedString(this.sell)).append("\n");
        sb.append("    cancel: ").append(this.toIndentedString(this.cancel)).append("\n");
        sb.append("    cash: ").append(this.toIndentedString(this.cash)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    transfer: ").append(this.toIndentedString(this.transfer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

