/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.StatementsStatement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Account associated with the Item.")
public class StatementsAccount {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_MASK = "account_mask";
    @SerializedName(value="account_mask")
    private String accountMask;
    public static final String SERIALIZED_NAME_ACCOUNT_NAME = "account_name";
    @SerializedName(value="account_name")
    private String accountName;
    public static final String SERIALIZED_NAME_ACCOUNT_OFFICIAL_NAME = "account_official_name";
    @SerializedName(value="account_official_name")
    private String accountOfficialName;
    public static final String SERIALIZED_NAME_ACCOUNT_SUBTYPE = "account_subtype";
    @SerializedName(value="account_subtype")
    private String accountSubtype;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
    @SerializedName(value="account_type")
    private String accountType;
    public static final String SERIALIZED_NAME_STATEMENTS = "statements";
    @SerializedName(value="statements")
    private List<StatementsStatement> statements = new ArrayList<StatementsStatement>();

    public StatementsAccount accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid's unique identifier for the account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public StatementsAccount accountMask(String accountMask) {
        this.accountMask = accountMask;
        return this;
    }

    @ApiModelProperty(required=true, value="The last 2-4 alphanumeric characters of an account's official account number. Note that the mask may be non-unique between an Item's accounts, and it may also not match the mask that the bank displays to the user.")
    public String getAccountMask() {
        return this.accountMask;
    }

    public void setAccountMask(String accountMask) {
        this.accountMask = accountMask;
    }

    public StatementsAccount accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the account, either assigned by the user or by the financial institution itself.")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public StatementsAccount accountOfficialName(String accountOfficialName) {
        this.accountOfficialName = accountOfficialName;
        return this;
    }

    @ApiModelProperty(required=true, value="The official name of the account as given by the financial institution.")
    public String getAccountOfficialName() {
        return this.accountOfficialName;
    }

    public void setAccountOfficialName(String accountOfficialName) {
        this.accountOfficialName = accountOfficialName;
    }

    public StatementsAccount accountSubtype(String accountSubtype) {
        this.accountSubtype = accountSubtype;
        return this;
    }

    @ApiModelProperty(required=true, value="The subtype of the account. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).")
    public String getAccountSubtype() {
        return this.accountSubtype;
    }

    public void setAccountSubtype(String accountSubtype) {
        this.accountSubtype = accountSubtype;
    }

    public StatementsAccount accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of account. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public StatementsAccount statements(List<StatementsStatement> statements) {
        this.statements = statements;
        return this;
    }

    public StatementsAccount addStatementsItem(StatementsStatement statementsItem) {
        this.statements.add(statementsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The list of statements' metadata associated with this account.")
    public List<StatementsStatement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<StatementsStatement> statements) {
        this.statements = statements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementsAccount statementsAccount = (StatementsAccount)o;
        return Objects.equals(this.accountId, statementsAccount.accountId) && Objects.equals(this.accountMask, statementsAccount.accountMask) && Objects.equals(this.accountName, statementsAccount.accountName) && Objects.equals(this.accountOfficialName, statementsAccount.accountOfficialName) && Objects.equals(this.accountSubtype, statementsAccount.accountSubtype) && Objects.equals(this.accountType, statementsAccount.accountType) && Objects.equals(this.statements, statementsAccount.statements);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountMask, this.accountName, this.accountOfficialName, this.accountSubtype, this.accountType, this.statements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatementsAccount {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountMask: ").append(this.toIndentedString(this.accountMask)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountOfficialName: ").append(this.toIndentedString(this.accountOfficialName)).append("\n");
        sb.append("    accountSubtype: ").append(this.toIndentedString(this.accountSubtype)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    statements: ").append(this.toIndentedString(this.statements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

