/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.StatementsAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="StatementsListResponse defines the response schema for `/statements/list`")
public class StatementsListResponse {
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<StatementsAccount> accounts = new ArrayList<StatementsAccount>();
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_INSTITUTION_NAME = "institution_name";
    @SerializedName(value="institution_name")
    private String institutionName;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public StatementsListResponse accounts(List<StatementsAccount> accounts) {
        this.accounts = accounts;
        return this;
    }

    public StatementsListResponse addAccountsItem(StatementsAccount accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<StatementsAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<StatementsAccount> accounts) {
        this.accounts = accounts;
    }

    public StatementsListResponse institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid Institution ID associated with the Item.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public StatementsListResponse institutionName(String institutionName) {
        this.institutionName = institutionName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the institution associated with the Item.")
    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public StatementsListResponse itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid Item ID. The `item_id` is always unique; linking the same account at the same institution twice will result in two Items with different `item_id` values. Like all Plaid identifiers, the `item_id` is case-sensitive.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public StatementsListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementsListResponse statementsListResponse = (StatementsListResponse)o;
        return Objects.equals(this.accounts, statementsListResponse.accounts) && Objects.equals(this.institutionId, statementsListResponse.institutionId) && Objects.equals(this.institutionName, statementsListResponse.institutionName) && Objects.equals(this.itemId, statementsListResponse.itemId) && Objects.equals(this.requestId, statementsListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.institutionId, this.institutionName, this.itemId, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatementsListResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    institutionName: ").append(this.toIndentedString(this.institutionName)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

