/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.StatementsRefreshCompleteResult;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Fired when refreshed statements extraction is completed or failed to be completed. Triggered by calling `/statements/refresh`.")
public class StatementsRefreshCompleteWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_RESULT = "result";
    @SerializedName(value="result")
    private StatementsRefreshCompleteResult result;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public StatementsRefreshCompleteWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`STATEMENTS`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public StatementsRefreshCompleteWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`STATEMENTS_REFRESH_COMPLETE`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public StatementsRefreshCompleteWebhook itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid Item ID. The `item_id` is always unique; linking the same account at the same institution twice will result in two Items with different `item_id` values. Like all Plaid identifiers, the `item_id` is case-sensitive.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public StatementsRefreshCompleteWebhook result(StatementsRefreshCompleteResult result) {
        this.result = result;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public StatementsRefreshCompleteResult getResult() {
        return this.result;
    }

    public void setResult(StatementsRefreshCompleteResult result) {
        this.result = result;
    }

    public StatementsRefreshCompleteWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementsRefreshCompleteWebhook statementsRefreshCompleteWebhook = (StatementsRefreshCompleteWebhook)o;
        return Objects.equals(this.webhookType, statementsRefreshCompleteWebhook.webhookType) && Objects.equals(this.webhookCode, statementsRefreshCompleteWebhook.webhookCode) && Objects.equals(this.itemId, statementsRefreshCompleteWebhook.itemId) && Objects.equals((Object)this.result, (Object)statementsRefreshCompleteWebhook.result) && Objects.equals((Object)this.environment, (Object)statementsRefreshCompleteWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.itemId, this.result, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatementsRefreshCompleteWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    result: ").append(this.toIndentedString((Object)this.result)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

