/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PSLFStatus;
import com.plaid.client.model.ServicerAddressData;
import com.plaid.client.model.StudentLoanStatus;
import com.plaid.client.model.StudentRepaymentPlan;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains details about a student loan account")
public class StudentLoan {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_DISBURSEMENT_DATES = "disbursement_dates";
    @SerializedName(value="disbursement_dates")
    private List<LocalDate> disbursementDates = new ArrayList<LocalDate>();
    public static final String SERIALIZED_NAME_EXPECTED_PAYOFF_DATE = "expected_payoff_date";
    @SerializedName(value="expected_payoff_date")
    private LocalDate expectedPayoffDate;
    public static final String SERIALIZED_NAME_GUARANTOR = "guarantor";
    @SerializedName(value="guarantor")
    private String guarantor;
    public static final String SERIALIZED_NAME_INTEREST_RATE_PERCENTAGE = "interest_rate_percentage";
    @SerializedName(value="interest_rate_percentage")
    private Double interestRatePercentage;
    public static final String SERIALIZED_NAME_IS_OVERDUE = "is_overdue";
    @SerializedName(value="is_overdue")
    private Boolean isOverdue;
    public static final String SERIALIZED_NAME_LAST_PAYMENT_AMOUNT = "last_payment_amount";
    @SerializedName(value="last_payment_amount")
    private Double lastPaymentAmount;
    public static final String SERIALIZED_NAME_LAST_PAYMENT_DATE = "last_payment_date";
    @SerializedName(value="last_payment_date")
    private LocalDate lastPaymentDate;
    public static final String SERIALIZED_NAME_LAST_STATEMENT_ISSUE_DATE = "last_statement_issue_date";
    @SerializedName(value="last_statement_issue_date")
    private LocalDate lastStatementIssueDate;
    public static final String SERIALIZED_NAME_LOAN_NAME = "loan_name";
    @SerializedName(value="loan_name")
    private String loanName;
    public static final String SERIALIZED_NAME_LOAN_STATUS = "loan_status";
    @SerializedName(value="loan_status")
    private StudentLoanStatus loanStatus;
    public static final String SERIALIZED_NAME_MINIMUM_PAYMENT_AMOUNT = "minimum_payment_amount";
    @SerializedName(value="minimum_payment_amount")
    private Double minimumPaymentAmount;
    public static final String SERIALIZED_NAME_NEXT_PAYMENT_DUE_DATE = "next_payment_due_date";
    @SerializedName(value="next_payment_due_date")
    private LocalDate nextPaymentDueDate;
    public static final String SERIALIZED_NAME_ORIGINATION_DATE = "origination_date";
    @SerializedName(value="origination_date")
    private LocalDate originationDate;
    public static final String SERIALIZED_NAME_ORIGINATION_PRINCIPAL_AMOUNT = "origination_principal_amount";
    @SerializedName(value="origination_principal_amount")
    private Double originationPrincipalAmount;
    public static final String SERIALIZED_NAME_OUTSTANDING_INTEREST_AMOUNT = "outstanding_interest_amount";
    @SerializedName(value="outstanding_interest_amount")
    private Double outstandingInterestAmount;
    public static final String SERIALIZED_NAME_PAYMENT_REFERENCE_NUMBER = "payment_reference_number";
    @SerializedName(value="payment_reference_number")
    private String paymentReferenceNumber;
    public static final String SERIALIZED_NAME_PSLF_STATUS = "pslf_status";
    @SerializedName(value="pslf_status")
    private PSLFStatus pslfStatus;
    public static final String SERIALIZED_NAME_REPAYMENT_PLAN = "repayment_plan";
    @SerializedName(value="repayment_plan")
    private StudentRepaymentPlan repaymentPlan;
    public static final String SERIALIZED_NAME_SEQUENCE_NUMBER = "sequence_number";
    @SerializedName(value="sequence_number")
    private String sequenceNumber;
    public static final String SERIALIZED_NAME_SERVICER_ADDRESS = "servicer_address";
    @SerializedName(value="servicer_address")
    private ServicerAddressData servicerAddress;
    public static final String SERIALIZED_NAME_YTD_INTEREST_PAID = "ytd_interest_paid";
    @SerializedName(value="ytd_interest_paid")
    private Double ytdInterestPaid;
    public static final String SERIALIZED_NAME_YTD_PRINCIPAL_PAID = "ytd_principal_paid";
    @SerializedName(value="ytd_principal_paid")
    private Double ytdPrincipalPaid;

    public StudentLoan accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ID of the account that this liability belongs to. Each account can only contain one liability.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public StudentLoan accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The account number of the loan. For some institutions, this may be a masked version of the number (e.g., the last 4 digits instead of the entire number).")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public StudentLoan disbursementDates(List<LocalDate> disbursementDates) {
        this.disbursementDates = disbursementDates;
        return this;
    }

    public StudentLoan addDisbursementDatesItem(LocalDate disbursementDatesItem) {
        this.disbursementDates.add(disbursementDatesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The dates on which loaned funds were disbursed or will be disbursed. These are often in the past. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public List<LocalDate> getDisbursementDates() {
        return this.disbursementDates;
    }

    public void setDisbursementDates(List<LocalDate> disbursementDates) {
        this.disbursementDates = disbursementDates;
    }

    public StudentLoan expectedPayoffDate(LocalDate expectedPayoffDate) {
        this.expectedPayoffDate = expectedPayoffDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date when the student loan is expected to be paid off. Availability for this field is limited. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getExpectedPayoffDate() {
        return this.expectedPayoffDate;
    }

    public void setExpectedPayoffDate(LocalDate expectedPayoffDate) {
        this.expectedPayoffDate = expectedPayoffDate;
    }

    public StudentLoan guarantor(String guarantor) {
        this.guarantor = guarantor;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The guarantor of the student loan.")
    public String getGuarantor() {
        return this.guarantor;
    }

    public void setGuarantor(String guarantor) {
        this.guarantor = guarantor;
    }

    public StudentLoan interestRatePercentage(Double interestRatePercentage) {
        this.interestRatePercentage = interestRatePercentage;
        return this;
    }

    @ApiModelProperty(required=true, value="The interest rate on the loan as a percentage.")
    public Double getInterestRatePercentage() {
        return this.interestRatePercentage;
    }

    public void setInterestRatePercentage(Double interestRatePercentage) {
        this.interestRatePercentage = interestRatePercentage;
    }

    public StudentLoan isOverdue(Boolean isOverdue) {
        this.isOverdue = isOverdue;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="`true` if a payment is currently overdue. Availability for this field is limited.")
    public Boolean getIsOverdue() {
        return this.isOverdue;
    }

    public void setIsOverdue(Boolean isOverdue) {
        this.isOverdue = isOverdue;
    }

    public StudentLoan lastPaymentAmount(Double lastPaymentAmount) {
        this.lastPaymentAmount = lastPaymentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The amount of the last payment.")
    public Double getLastPaymentAmount() {
        return this.lastPaymentAmount;
    }

    public void setLastPaymentAmount(Double lastPaymentAmount) {
        this.lastPaymentAmount = lastPaymentAmount;
    }

    public StudentLoan lastPaymentDate(LocalDate lastPaymentDate) {
        this.lastPaymentDate = lastPaymentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date of the last payment. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getLastPaymentDate() {
        return this.lastPaymentDate;
    }

    public void setLastPaymentDate(LocalDate lastPaymentDate) {
        this.lastPaymentDate = lastPaymentDate;
    }

    public StudentLoan lastStatementIssueDate(LocalDate lastStatementIssueDate) {
        this.lastStatementIssueDate = lastStatementIssueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date of the last statement. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getLastStatementIssueDate() {
        return this.lastStatementIssueDate;
    }

    public void setLastStatementIssueDate(LocalDate lastStatementIssueDate) {
        this.lastStatementIssueDate = lastStatementIssueDate;
    }

    public StudentLoan loanName(String loanName) {
        this.loanName = loanName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The type of loan, e.g., \"Consolidation Loans\".")
    public String getLoanName() {
        return this.loanName;
    }

    public void setLoanName(String loanName) {
        this.loanName = loanName;
    }

    public StudentLoan loanStatus(StudentLoanStatus loanStatus) {
        this.loanStatus = loanStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public StudentLoanStatus getLoanStatus() {
        return this.loanStatus;
    }

    public void setLoanStatus(StudentLoanStatus loanStatus) {
        this.loanStatus = loanStatus;
    }

    public StudentLoan minimumPaymentAmount(Double minimumPaymentAmount) {
        this.minimumPaymentAmount = minimumPaymentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The minimum payment due for the next billing cycle. There are some exceptions: Some institutions require a minimum payment across all loans associated with an account number. Our API presents that same minimum payment amount on each loan. The institutions that do this are: Great Lakes ( `ins_116861`), Firstmark (`ins_116295`), Commonbond Firstmark Services (`ins_116950`), EdFinancial Services (`ins_116304`), Granite State (`ins_116308`), and Oklahoma Student Loan Authority (`ins_116945`). Firstmark (`ins_116295` ), EdFinancial Services (`ins_116304`),  and Navient (`ins_116248`) will display as $0 if there is an autopay program in effect.")
    public Double getMinimumPaymentAmount() {
        return this.minimumPaymentAmount;
    }

    public void setMinimumPaymentAmount(Double minimumPaymentAmount) {
        this.minimumPaymentAmount = minimumPaymentAmount;
    }

    public StudentLoan nextPaymentDueDate(LocalDate nextPaymentDueDate) {
        this.nextPaymentDueDate = nextPaymentDueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The due date for the next payment. The due date is `null` if a payment is not expected. A payment is not expected if `loan_status.type` is `deferment`, `in_school`, `consolidated`, `paid in full`, or `transferred`. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getNextPaymentDueDate() {
        return this.nextPaymentDueDate;
    }

    public void setNextPaymentDueDate(LocalDate nextPaymentDueDate) {
        this.nextPaymentDueDate = nextPaymentDueDate;
    }

    public StudentLoan originationDate(LocalDate originationDate) {
        this.originationDate = originationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date on which the loan was initially lent. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). ")
    public LocalDate getOriginationDate() {
        return this.originationDate;
    }

    public void setOriginationDate(LocalDate originationDate) {
        this.originationDate = originationDate;
    }

    public StudentLoan originationPrincipalAmount(Double originationPrincipalAmount) {
        this.originationPrincipalAmount = originationPrincipalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The original principal balance of the loan.")
    public Double getOriginationPrincipalAmount() {
        return this.originationPrincipalAmount;
    }

    public void setOriginationPrincipalAmount(Double originationPrincipalAmount) {
        this.originationPrincipalAmount = originationPrincipalAmount;
    }

    public StudentLoan outstandingInterestAmount(Double outstandingInterestAmount) {
        this.outstandingInterestAmount = outstandingInterestAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The total dollar amount of the accrued interest balance. For Sallie Mae ( `ins_116944`), this amount is included in the current balance of the loan, so this field will return as `null`.")
    public Double getOutstandingInterestAmount() {
        return this.outstandingInterestAmount;
    }

    public void setOutstandingInterestAmount(Double outstandingInterestAmount) {
        this.outstandingInterestAmount = outstandingInterestAmount;
    }

    public StudentLoan paymentReferenceNumber(String paymentReferenceNumber) {
        this.paymentReferenceNumber = paymentReferenceNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The relevant account number that should be used to reference this loan for payments. In the majority of cases, `payment_reference_number` will match `account_number,` but in some institutions, such as Great Lakes (`ins_116861`), it will be different.")
    public String getPaymentReferenceNumber() {
        return this.paymentReferenceNumber;
    }

    public void setPaymentReferenceNumber(String paymentReferenceNumber) {
        this.paymentReferenceNumber = paymentReferenceNumber;
    }

    public StudentLoan pslfStatus(PSLFStatus pslfStatus) {
        this.pslfStatus = pslfStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PSLFStatus getPslfStatus() {
        return this.pslfStatus;
    }

    public void setPslfStatus(PSLFStatus pslfStatus) {
        this.pslfStatus = pslfStatus;
    }

    public StudentLoan repaymentPlan(StudentRepaymentPlan repaymentPlan) {
        this.repaymentPlan = repaymentPlan;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public StudentRepaymentPlan getRepaymentPlan() {
        return this.repaymentPlan;
    }

    public void setRepaymentPlan(StudentRepaymentPlan repaymentPlan) {
        this.repaymentPlan = repaymentPlan;
    }

    public StudentLoan sequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The sequence number of the student loan. Heartland ECSI (`ins_116948`) does not make this field available.")
    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public StudentLoan servicerAddress(ServicerAddressData servicerAddress) {
        this.servicerAddress = servicerAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ServicerAddressData getServicerAddress() {
        return this.servicerAddress;
    }

    public void setServicerAddress(ServicerAddressData servicerAddress) {
        this.servicerAddress = servicerAddress;
    }

    public StudentLoan ytdInterestPaid(Double ytdInterestPaid) {
        this.ytdInterestPaid = ytdInterestPaid;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The year to date (YTD) interest paid. Availability for this field is limited.")
    public Double getYtdInterestPaid() {
        return this.ytdInterestPaid;
    }

    public void setYtdInterestPaid(Double ytdInterestPaid) {
        this.ytdInterestPaid = ytdInterestPaid;
    }

    public StudentLoan ytdPrincipalPaid(Double ytdPrincipalPaid) {
        this.ytdPrincipalPaid = ytdPrincipalPaid;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The year to date (YTD) principal paid. Availability for this field is limited.")
    public Double getYtdPrincipalPaid() {
        return this.ytdPrincipalPaid;
    }

    public void setYtdPrincipalPaid(Double ytdPrincipalPaid) {
        this.ytdPrincipalPaid = ytdPrincipalPaid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StudentLoan studentLoan = (StudentLoan)o;
        return Objects.equals(this.accountId, studentLoan.accountId) && Objects.equals(this.accountNumber, studentLoan.accountNumber) && Objects.equals(this.disbursementDates, studentLoan.disbursementDates) && Objects.equals(this.expectedPayoffDate, studentLoan.expectedPayoffDate) && Objects.equals(this.guarantor, studentLoan.guarantor) && Objects.equals(this.interestRatePercentage, studentLoan.interestRatePercentage) && Objects.equals(this.isOverdue, studentLoan.isOverdue) && Objects.equals(this.lastPaymentAmount, studentLoan.lastPaymentAmount) && Objects.equals(this.lastPaymentDate, studentLoan.lastPaymentDate) && Objects.equals(this.lastStatementIssueDate, studentLoan.lastStatementIssueDate) && Objects.equals(this.loanName, studentLoan.loanName) && Objects.equals(this.loanStatus, studentLoan.loanStatus) && Objects.equals(this.minimumPaymentAmount, studentLoan.minimumPaymentAmount) && Objects.equals(this.nextPaymentDueDate, studentLoan.nextPaymentDueDate) && Objects.equals(this.originationDate, studentLoan.originationDate) && Objects.equals(this.originationPrincipalAmount, studentLoan.originationPrincipalAmount) && Objects.equals(this.outstandingInterestAmount, studentLoan.outstandingInterestAmount) && Objects.equals(this.paymentReferenceNumber, studentLoan.paymentReferenceNumber) && Objects.equals(this.pslfStatus, studentLoan.pslfStatus) && Objects.equals(this.repaymentPlan, studentLoan.repaymentPlan) && Objects.equals(this.sequenceNumber, studentLoan.sequenceNumber) && Objects.equals(this.servicerAddress, studentLoan.servicerAddress) && Objects.equals(this.ytdInterestPaid, studentLoan.ytdInterestPaid) && Objects.equals(this.ytdPrincipalPaid, studentLoan.ytdPrincipalPaid);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountNumber, this.disbursementDates, this.expectedPayoffDate, this.guarantor, this.interestRatePercentage, this.isOverdue, this.lastPaymentAmount, this.lastPaymentDate, this.lastStatementIssueDate, this.loanName, this.loanStatus, this.minimumPaymentAmount, this.nextPaymentDueDate, this.originationDate, this.originationPrincipalAmount, this.outstandingInterestAmount, this.paymentReferenceNumber, this.pslfStatus, this.repaymentPlan, this.sequenceNumber, this.servicerAddress, this.ytdInterestPaid, this.ytdPrincipalPaid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StudentLoan {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    disbursementDates: ").append(this.toIndentedString(this.disbursementDates)).append("\n");
        sb.append("    expectedPayoffDate: ").append(this.toIndentedString(this.expectedPayoffDate)).append("\n");
        sb.append("    guarantor: ").append(this.toIndentedString(this.guarantor)).append("\n");
        sb.append("    interestRatePercentage: ").append(this.toIndentedString(this.interestRatePercentage)).append("\n");
        sb.append("    isOverdue: ").append(this.toIndentedString(this.isOverdue)).append("\n");
        sb.append("    lastPaymentAmount: ").append(this.toIndentedString(this.lastPaymentAmount)).append("\n");
        sb.append("    lastPaymentDate: ").append(this.toIndentedString(this.lastPaymentDate)).append("\n");
        sb.append("    lastStatementIssueDate: ").append(this.toIndentedString(this.lastStatementIssueDate)).append("\n");
        sb.append("    loanName: ").append(this.toIndentedString(this.loanName)).append("\n");
        sb.append("    loanStatus: ").append(this.toIndentedString(this.loanStatus)).append("\n");
        sb.append("    minimumPaymentAmount: ").append(this.toIndentedString(this.minimumPaymentAmount)).append("\n");
        sb.append("    nextPaymentDueDate: ").append(this.toIndentedString(this.nextPaymentDueDate)).append("\n");
        sb.append("    originationDate: ").append(this.toIndentedString(this.originationDate)).append("\n");
        sb.append("    originationPrincipalAmount: ").append(this.toIndentedString(this.originationPrincipalAmount)).append("\n");
        sb.append("    outstandingInterestAmount: ").append(this.toIndentedString(this.outstandingInterestAmount)).append("\n");
        sb.append("    paymentReferenceNumber: ").append(this.toIndentedString(this.paymentReferenceNumber)).append("\n");
        sb.append("    pslfStatus: ").append(this.toIndentedString(this.pslfStatus)).append("\n");
        sb.append("    repaymentPlan: ").append(this.toIndentedString(this.repaymentPlan)).append("\n");
        sb.append("    sequenceNumber: ").append(this.toIndentedString(this.sequenceNumber)).append("\n");
        sb.append("    servicerAddress: ").append(this.toIndentedString(this.servicerAddress)).append("\n");
        sb.append("    ytdInterestPaid: ").append(this.toIndentedString(this.ytdInterestPaid)).append("\n");
        sb.append("    ytdPrincipalPaid: ").append(this.toIndentedString(this.ytdPrincipalPaid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

