/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing the status of the student loan")
public class StudentLoanStatus {
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;

    public StudentLoanStatus endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date until which the loan will be in its current status. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). ")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public StudentLoanStatus type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The status type of the student loan")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StudentLoanStatus studentLoanStatus = (StudentLoanStatus)o;
        return Objects.equals(this.endDate, studentLoanStatus.endDate) && Objects.equals((Object)this.type, (Object)studentLoanStatus.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endDate, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StudentLoanStatus {\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CANCELLED("cancelled"),
        CHARGED_OFF("charged off"),
        CLAIM("claim"),
        CONSOLIDATED("consolidated"),
        DEFERMENT("deferment"),
        DELINQUENT("delinquent"),
        DISCHARGED("discharged"),
        EXTENSION("extension"),
        FORBEARANCE("forbearance"),
        IN_GRACE("in grace"),
        IN_MILITARY("in military"),
        IN_SCHOOL("in school"),
        NOT_FULLY_DISBURSED("not fully disbursed"),
        OTHER("other"),
        PAID_IN_FULL("paid in full"),
        REFUNDED("refunded"),
        REPAYMENT("repayment"),
        TRANSFERRED("transferred"),
        PENDING_IDR("pending idr");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

