/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing the repayment plan for the student loan")
public class StudentRepaymentPlan {
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;

    public StudentRepaymentPlan description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The description of the repayment plan as provided by the servicer.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StudentRepaymentPlan type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The type of the repayment plan.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StudentRepaymentPlan studentRepaymentPlan = (StudentRepaymentPlan)o;
        return Objects.equals(this.description, studentRepaymentPlan.description) && Objects.equals((Object)this.type, (Object)studentRepaymentPlan.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StudentRepaymentPlan {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        EXTENDED_GRADUATED("extended graduated"),
        EXTENDED_STANDARD("extended standard"),
        GRADUATED("graduated"),
        INCOME_CONTINGENT_REPAYMENT("income-contingent repayment"),
        INCOME_BASED_REPAYMENT("income-based repayment"),
        INCOME_SENSITIVE_REPAYMENT("income-sensitive repayment"),
        INTEREST_ONLY("interest-only"),
        OTHER("other"),
        PAY_AS_YOU_EARN("pay as you earn"),
        REVISED_PAY_AS_YOU_EARN("revised pay as you earn"),
        STANDARD("standard"),
        SAVING_ON_A_VALUABLE_EDUCATION("saving on a valuable education"),
        NULL("null");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

