/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.W2;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Data about an official document used to report the user's income to the IRS.")
public class Taxform {
    public static final String SERIALIZED_NAME_DOC_ID = "doc_id";
    @SerializedName(value="doc_id")
    private String docId;
    public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
    @SerializedName(value="document_type")
    private String documentType;
    public static final String SERIALIZED_NAME_W2 = "w2";
    @SerializedName(value="w2")
    private W2 w2;

    public Taxform docId(String docId) {
        this.docId = docId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An identifier of the document referenced by the document metadata.")
    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public Taxform documentType(String documentType) {
        this.documentType = documentType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of tax document. Currently, the only supported value is `w2`.")
    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public Taxform w2(W2 w2) {
        this.w2 = w2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public W2 getW2() {
        return this.w2;
    }

    public void setW2(W2 w2) {
        this.w2 = w2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Taxform taxform = (Taxform)o;
        return Objects.equals(this.docId, taxform.docId) && Objects.equals(this.documentType, taxform.documentType) && Objects.equals(this.w2, taxform.w2);
    }

    public int hashCode() {
        return Objects.hash(this.docId, this.documentType, this.w2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Taxform {\n");
        sb.append("    docId: ").append(this.toIndentedString(this.docId)).append("\n");
        sb.append("    documentType: ").append(this.toIndentedString(this.documentType)).append("\n");
        sb.append("    w2: ").append(this.toIndentedString(this.w2)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

