/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Taxpayer ID of the individual receiving the paystub.")
public class TaxpayerID {
    public static final String SERIALIZED_NAME_ID_TYPE = "id_type";
    @SerializedName(value="id_type")
    private String idType;
    public static final String SERIALIZED_NAME_ID_MASK = "id_mask";
    @SerializedName(value="id_mask")
    private String idMask;
    public static final String SERIALIZED_NAME_LAST4_DIGITS = "last_4_digits";
    @SerializedName(value="last_4_digits")
    private String last4Digits;

    public TaxpayerID idType(String idType) {
        this.idType = idType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of ID, e.g. 'SSN'")
    public String getIdType() {
        return this.idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public TaxpayerID idMask(String idMask) {
        this.idMask = idMask;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID mask; i.e. last 4 digits of the taxpayer ID")
    public String getIdMask() {
        return this.idMask;
    }

    public void setIdMask(String idMask) {
        this.idMask = idMask;
    }

    public TaxpayerID last4Digits(String last4Digits) {
        this.last4Digits = last4Digits;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last 4 digits of unique number of ID.")
    public String getLast4Digits() {
        return this.last4Digits;
    }

    public void setLast4Digits(String last4Digits) {
        this.last4Digits = last4Digits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxpayerID taxpayerID = (TaxpayerID)o;
        return Objects.equals(this.idType, taxpayerID.idType) && Objects.equals(this.idMask, taxpayerID.idMask) && Objects.equals(this.last4Digits, taxpayerID.last4Digits);
    }

    public int hashCode() {
        return Objects.hash(this.idType, this.idMask, this.last4Digits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxpayerID {\n");
        sb.append("    idType: ").append(this.toIndentedString(this.idType)).append("\n");
        sb.append("    idMask: ").append(this.toIndentedString(this.idMask)).append("\n");
        sb.append("    last4Digits: ").append(this.toIndentedString(this.last4Digits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

