/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.PersonalFinanceCategory;
import com.plaid.client.model.TransactionCode;
import com.plaid.client.model.TransactionCounterparty;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TransactionAllOf {
    public static final String SERIALIZED_NAME_AUTHORIZED_DATE = "authorized_date";
    @SerializedName(value="authorized_date")
    private LocalDate authorizedDate;
    public static final String SERIALIZED_NAME_AUTHORIZED_DATETIME = "authorized_datetime";
    @SerializedName(value="authorized_datetime")
    private OffsetDateTime authorizedDatetime;
    public static final String SERIALIZED_NAME_DATETIME = "datetime";
    @SerializedName(value="datetime")
    private OffsetDateTime datetime;
    public static final String SERIALIZED_NAME_PAYMENT_CHANNEL = "payment_channel";
    @SerializedName(value="payment_channel")
    private PaymentChannelEnum paymentChannel;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY = "personal_finance_category";
    @SerializedName(value="personal_finance_category")
    private PersonalFinanceCategory personalFinanceCategory;
    public static final String SERIALIZED_NAME_TRANSACTION_CODE = "transaction_code";
    @SerializedName(value="transaction_code")
    private TransactionCode transactionCode;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY_ICON_URL = "personal_finance_category_icon_url";
    @SerializedName(value="personal_finance_category_icon_url")
    private String personalFinanceCategoryIconUrl;
    public static final String SERIALIZED_NAME_COUNTERPARTIES = "counterparties";
    @SerializedName(value="counterparties")
    private List<TransactionCounterparty> counterparties = null;
    public static final String SERIALIZED_NAME_MERCHANT_ENTITY_ID = "merchant_entity_id";
    @SerializedName(value="merchant_entity_id")
    private String merchantEntityId;

    public TransactionAllOf authorizedDate(LocalDate authorizedDate) {
        this.authorizedDate = authorizedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date that the transaction was authorized. For posted transactions, the `date` field will indicate the posted date, but `authorized_date` will indicate the day the transaction was authorized by the financial institution. If presenting transactions to the user in a UI, the `authorized_date`, when available, is generally preferable to use over the `date` field for posted transactions, as it will generally represent the date the user actually made the transaction. Dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DD` ).")
    public LocalDate getAuthorizedDate() {
        return this.authorizedDate;
    }

    public void setAuthorizedDate(LocalDate authorizedDate) {
        this.authorizedDate = authorizedDate;
    }

    public TransactionAllOf authorizedDatetime(OffsetDateTime authorizedDatetime) {
        this.authorizedDatetime = authorizedDatetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Date and time when a transaction was authorized in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DDTHH:mm:ssZ` ). For posted transactions, the `datetime` field will indicate the posted date, but `authorized_datetime` will indicate the day the transaction was authorized by the financial institution. If presenting transactions to the user in a UI, the `authorized_datetime`, when available, is generally preferable to use over the `datetime` field for posted transactions, as it will generally represent the date the user actually made the transaction.  This field is returned for select financial institutions and comes as provided by the institution. It may contain default time values (such as 00:00:00). This field is only populated in API version 2019-05-29 and later.")
    public OffsetDateTime getAuthorizedDatetime() {
        return this.authorizedDatetime;
    }

    public void setAuthorizedDatetime(OffsetDateTime authorizedDatetime) {
        this.authorizedDatetime = authorizedDatetime;
    }

    public TransactionAllOf datetime(OffsetDateTime datetime) {
        this.datetime = datetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Date and time when a transaction was posted in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DDTHH:mm:ssZ` ). For the date that the transaction was initiated, rather than posted, see the `authorized_datetime` field.  This field is returned for select financial institutions and comes as provided by the institution. It may contain default time values (such as 00:00:00). This field is only populated in API version 2019-05-29 and later.")
    public OffsetDateTime getDatetime() {
        return this.datetime;
    }

    public void setDatetime(OffsetDateTime datetime) {
        this.datetime = datetime;
    }

    public TransactionAllOf paymentChannel(PaymentChannelEnum paymentChannel) {
        this.paymentChannel = paymentChannel;
        return this;
    }

    @ApiModelProperty(required=true, value="The channel used to make a payment. `online:` transactions that took place online.  `in store:` transactions that were made at a physical location.  `other:` transactions that relate to banks, e.g. fees or deposits.  This field replaces the `transaction_type` field. ")
    public PaymentChannelEnum getPaymentChannel() {
        return this.paymentChannel;
    }

    public void setPaymentChannel(PaymentChannelEnum paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public TransactionAllOf personalFinanceCategory(PersonalFinanceCategory personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PersonalFinanceCategory getPersonalFinanceCategory() {
        return this.personalFinanceCategory;
    }

    public void setPersonalFinanceCategory(PersonalFinanceCategory personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
    }

    public TransactionAllOf transactionCode(TransactionCode transactionCode) {
        this.transactionCode = transactionCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransactionCode getTransactionCode() {
        return this.transactionCode;
    }

    public void setTransactionCode(TransactionCode transactionCode) {
        this.transactionCode = transactionCode;
    }

    public TransactionAllOf personalFinanceCategoryIconUrl(String personalFinanceCategoryIconUrl) {
        this.personalFinanceCategoryIconUrl = personalFinanceCategoryIconUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL of an icon associated with the primary personal finance category. The icon will always be 100\u00d7100 pixel PNG file.")
    public String getPersonalFinanceCategoryIconUrl() {
        return this.personalFinanceCategoryIconUrl;
    }

    public void setPersonalFinanceCategoryIconUrl(String personalFinanceCategoryIconUrl) {
        this.personalFinanceCategoryIconUrl = personalFinanceCategoryIconUrl;
    }

    public TransactionAllOf counterparties(List<TransactionCounterparty> counterparties) {
        this.counterparties = counterparties;
        return this;
    }

    public TransactionAllOf addCounterpartiesItem(TransactionCounterparty counterpartiesItem) {
        if (this.counterparties == null) {
            this.counterparties = new ArrayList<TransactionCounterparty>();
        }
        this.counterparties.add(counterpartiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparties present in the transaction. Counterparties, such as the merchant or the financial institution, are extracted by Plaid from the raw description.")
    public List<TransactionCounterparty> getCounterparties() {
        return this.counterparties;
    }

    public void setCounterparties(List<TransactionCounterparty> counterparties) {
        this.counterparties = counterparties;
    }

    public TransactionAllOf merchantEntityId(String merchantEntityId) {
        this.merchantEntityId = merchantEntityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique, stable, Plaid-generated ID that maps to the merchant. In the case of a merchant with multiple retail locations, this field will map to the broader merchant, not a specific location or store.")
    public String getMerchantEntityId() {
        return this.merchantEntityId;
    }

    public void setMerchantEntityId(String merchantEntityId) {
        this.merchantEntityId = merchantEntityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionAllOf transactionAllOf = (TransactionAllOf)o;
        return Objects.equals(this.authorizedDate, transactionAllOf.authorizedDate) && Objects.equals(this.authorizedDatetime, transactionAllOf.authorizedDatetime) && Objects.equals(this.datetime, transactionAllOf.datetime) && Objects.equals((Object)this.paymentChannel, (Object)transactionAllOf.paymentChannel) && Objects.equals(this.personalFinanceCategory, transactionAllOf.personalFinanceCategory) && Objects.equals((Object)this.transactionCode, (Object)transactionAllOf.transactionCode) && Objects.equals(this.personalFinanceCategoryIconUrl, transactionAllOf.personalFinanceCategoryIconUrl) && Objects.equals(this.counterparties, transactionAllOf.counterparties) && Objects.equals(this.merchantEntityId, transactionAllOf.merchantEntityId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizedDate, this.authorizedDatetime, this.datetime, this.paymentChannel, this.personalFinanceCategory, this.transactionCode, this.personalFinanceCategoryIconUrl, this.counterparties, this.merchantEntityId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionAllOf {\n");
        sb.append("    authorizedDate: ").append(this.toIndentedString(this.authorizedDate)).append("\n");
        sb.append("    authorizedDatetime: ").append(this.toIndentedString(this.authorizedDatetime)).append("\n");
        sb.append("    datetime: ").append(this.toIndentedString(this.datetime)).append("\n");
        sb.append("    paymentChannel: ").append(this.toIndentedString((Object)this.paymentChannel)).append("\n");
        sb.append("    personalFinanceCategory: ").append(this.toIndentedString(this.personalFinanceCategory)).append("\n");
        sb.append("    transactionCode: ").append(this.toIndentedString((Object)this.transactionCode)).append("\n");
        sb.append("    personalFinanceCategoryIconUrl: ").append(this.toIndentedString(this.personalFinanceCategoryIconUrl)).append("\n");
        sb.append("    counterparties: ").append(this.toIndentedString(this.counterparties)).append("\n");
        sb.append("    merchantEntityId: ").append(this.toIndentedString(this.merchantEntityId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PaymentChannelEnum {
        ONLINE("online"),
        IN_STORE("in store"),
        OTHER("other");

        private String value;

        private PaymentChannelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PaymentChannelEnum fromValue(String value) {
            for (PaymentChannelEnum b : PaymentChannelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PaymentChannelEnum> {
            public void write(JsonWriter jsonWriter, PaymentChannelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PaymentChannelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PaymentChannelEnum.fromValue(value);
            }
        }
    }
}

