/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.Location;
import com.plaid.client.model.PaymentMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A representation of a transaction")
public class TransactionBase {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private List<String> category = null;
    public static final String SERIALIZED_NAME_CATEGORY_ID = "category_id";
    @SerializedName(value="category_id")
    private String categoryId;
    public static final String SERIALIZED_NAME_CHECK_NUMBER = "check_number";
    @SerializedName(value="check_number")
    private String checkNumber;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private Location location;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchant_name";
    @SerializedName(value="merchant_name")
    private String merchantName;
    public static final String SERIALIZED_NAME_ORIGINAL_DESCRIPTION = "original_description";
    @SerializedName(value="original_description")
    private String originalDescription;
    public static final String SERIALIZED_NAME_PAYMENT_META = "payment_meta";
    @SerializedName(value="payment_meta")
    private PaymentMeta paymentMeta;
    public static final String SERIALIZED_NAME_PENDING = "pending";
    @SerializedName(value="pending")
    private Boolean pending;
    public static final String SERIALIZED_NAME_PENDING_TRANSACTION_ID = "pending_transaction_id";
    @SerializedName(value="pending_transaction_id")
    private String pendingTransactionId;
    public static final String SERIALIZED_NAME_ACCOUNT_OWNER = "account_owner";
    @SerializedName(value="account_owner")
    private String accountOwner;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transaction_id";
    @SerializedName(value="transaction_id")
    private String transactionId;
    public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transaction_type";
    @SerializedName(value="transaction_type")
    private TransactionTypeEnum transactionType;
    public static final String SERIALIZED_NAME_LOGO_URL = "logo_url";
    @SerializedName(value="logo_url")
    private String logoUrl;
    public static final String SERIALIZED_NAME_WEBSITE = "website";
    @SerializedName(value="website")
    private String website;

    public TransactionBase accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the account in which this transaction occurred.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransactionBase amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The settled value of the transaction, denominated in the transactions's currency, as stated in `iso_currency_code` or `unofficial_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, debit card purchases are positive; credit card payments, direct deposits, and refunds are negative.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public TransactionBase isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the transaction. Always `null` if `unofficial_currency_code` is non-null.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public TransactionBase unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the transaction. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public TransactionBase category(List<String> category) {
        this.category = category;
        return this;
    }

    public TransactionBase addCategoryItem(String categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<String>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A hierarchical array of the categories to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).  All Transactions implementations are recommended to use the new `personal_finance_category` instead of `category`, as it provides greater accuracy and more meaningful categorization.  If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.")
    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }

    public TransactionBase categoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the category to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).  All Transactions implementations are recommended to use the new `personal_finance_category` instead of `category`, as it provides greater accuracy and more meaningful categorization.  If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.")
    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public TransactionBase checkNumber(String checkNumber) {
        this.checkNumber = checkNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The check number of the transaction. This field is only populated for check transactions.")
    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public TransactionBase date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(required=true, value="For pending transactions, the date that the transaction occurred; for posted transactions, the date that the transaction posted. Both dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DD` ). To receive information about the date that a posted transaction was initiated, see the `authorized_date` field.")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public TransactionBase location(Location location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public TransactionBase name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The merchant name or transaction description.   Note: This is a legacy field that is not actively maintained. Use `merchant_name` instead for the merchant name.  If the `transactions` object was returned by a Transactions endpoint such as `/transactions/sync` or `/transactions/get`, this field will always appear. If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TransactionBase merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The merchant name, as enriched by Plaid from the `name` field. This is typically a more human-readable version of the merchant counterparty in the transaction. For some bank transactions (such as checks or account transfers) where there is no meaningful merchant name, this value will be `null`.")
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public TransactionBase originalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The string returned by the financial institution to describe the transaction. For transactions returned by `/transactions/sync` or `/transactions/get`, this field will be omitted unless the client has set `options.include_original_description` to `true`.")
    public String getOriginalDescription() {
        return this.originalDescription;
    }

    public void setOriginalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
    }

    public TransactionBase paymentMeta(PaymentMeta paymentMeta) {
        this.paymentMeta = paymentMeta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentMeta getPaymentMeta() {
        return this.paymentMeta;
    }

    public void setPaymentMeta(PaymentMeta paymentMeta) {
        this.paymentMeta = paymentMeta;
    }

    public TransactionBase pending(Boolean pending) {
        this.pending = pending;
        return this;
    }

    @ApiModelProperty(required=true, value="When `true`, identifies the transaction as pending or unsettled. Pending transaction details (name, type, amount, category ID) may change before they are settled.")
    public Boolean getPending() {
        return this.pending;
    }

    public void setPending(Boolean pending) {
        this.pending = pending;
    }

    public TransactionBase pendingTransactionId(String pendingTransactionId) {
        this.pendingTransactionId = pendingTransactionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of a posted transaction's associated pending transaction, where applicable.")
    public String getPendingTransactionId() {
        return this.pendingTransactionId;
    }

    public void setPendingTransactionId(String pendingTransactionId) {
        this.pendingTransactionId = pendingTransactionId;
    }

    public TransactionBase accountOwner(String accountOwner) {
        this.accountOwner = accountOwner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the account owner. This field is not typically populated and only relevant when dealing with sub-accounts.")
    public String getAccountOwner() {
        return this.accountOwner;
    }

    public void setAccountOwner(String accountOwner) {
        this.accountOwner = accountOwner;
    }

    public TransactionBase transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID of the transaction. Like all Plaid identifiers, the `transaction_id` is case sensitive.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransactionBase transactionType(TransactionTypeEnum transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Please use the `payment_channel` field, `transaction_type` will be deprecated in the future.  `digital:` transactions that took place online.  `place:` transactions that were made at a physical location.  `special:` transactions that relate to banks, e.g. fees or deposits.  `unresolved:` transactions that do not fit into the other three types. ")
    public TransactionTypeEnum getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionTypeEnum transactionType) {
        this.transactionType = transactionType;
    }

    public TransactionBase logoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL of a logo associated with this transaction, if available. The logo will always be 100\u00d7100 pixel PNG file.")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public TransactionBase website(String website) {
        this.website = website;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The website associated with this transaction, if available.")
    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionBase transactionBase = (TransactionBase)o;
        return Objects.equals(this.accountId, transactionBase.accountId) && Objects.equals(this.amount, transactionBase.amount) && Objects.equals(this.isoCurrencyCode, transactionBase.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, transactionBase.unofficialCurrencyCode) && Objects.equals(this.category, transactionBase.category) && Objects.equals(this.categoryId, transactionBase.categoryId) && Objects.equals(this.checkNumber, transactionBase.checkNumber) && Objects.equals(this.date, transactionBase.date) && Objects.equals(this.location, transactionBase.location) && Objects.equals(this.name, transactionBase.name) && Objects.equals(this.merchantName, transactionBase.merchantName) && Objects.equals(this.originalDescription, transactionBase.originalDescription) && Objects.equals(this.paymentMeta, transactionBase.paymentMeta) && Objects.equals(this.pending, transactionBase.pending) && Objects.equals(this.pendingTransactionId, transactionBase.pendingTransactionId) && Objects.equals(this.accountOwner, transactionBase.accountOwner) && Objects.equals(this.transactionId, transactionBase.transactionId) && Objects.equals((Object)this.transactionType, (Object)transactionBase.transactionType) && Objects.equals(this.logoUrl, transactionBase.logoUrl) && Objects.equals(this.website, transactionBase.website);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.amount, this.isoCurrencyCode, this.unofficialCurrencyCode, this.category, this.categoryId, this.checkNumber, this.date, this.location, this.name, this.merchantName, this.originalDescription, this.paymentMeta, this.pending, this.pendingTransactionId, this.accountOwner, this.transactionId, this.transactionType, this.logoUrl, this.website});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionBase {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    checkNumber: ").append(this.toIndentedString(this.checkNumber)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    originalDescription: ").append(this.toIndentedString(this.originalDescription)).append("\n");
        sb.append("    paymentMeta: ").append(this.toIndentedString(this.paymentMeta)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("    pendingTransactionId: ").append(this.toIndentedString(this.pendingTransactionId)).append("\n");
        sb.append("    accountOwner: ").append(this.toIndentedString(this.accountOwner)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString((Object)this.transactionType)).append("\n");
        sb.append("    logoUrl: ").append(this.toIndentedString(this.logoUrl)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransactionTypeEnum {
        DIGITAL("digital"),
        PLACE("place"),
        SPECIAL("special"),
        UNRESOLVED("unresolved");

        private String value;

        private TransactionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransactionTypeEnum fromValue(String value) {
            for (TransactionTypeEnum b : TransactionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TransactionTypeEnum> {
            public void write(JsonWriter jsonWriter, TransactionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransactionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransactionTypeEnum.fromValue(value);
            }
        }
    }
}

