/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum TransactionCode {
    ADJUSTMENT("adjustment"),
    ATM("atm"),
    BANK_CHARGE("bank charge"),
    BILL_PAYMENT("bill payment"),
    CASH("cash"),
    CASHBACK("cashback"),
    CHEQUE("cheque"),
    DIRECT_DEBIT("direct debit"),
    INTEREST("interest"),
    PURCHASE("purchase"),
    STANDING_ORDER("standing order"),
    TRANSFER("transfer"),
    NULL("null"),
    ENUM_UNKNOWN("ENUM_UNKNOWN");

    private String value;

    private TransactionCode(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransactionCode fromValue(String value) {
        for (TransactionCode b : TransactionCode.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return null;
    }

    public static class Adapter
    extends TypeAdapter<TransactionCode> {
        public void write(JsonWriter jsonWriter, TransactionCode enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public TransactionCode read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return TransactionCode.fromValue(value);
        }
    }
}

