/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CounterpartyType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The counterparty, such as the merchant or financial institution, is extracted by Plaid from the raw description.")
public class TransactionCounterparty {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ENTITY_ID = "entity_id";
    @SerializedName(value="entity_id")
    private String entityId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private CounterpartyType type;
    public static final String SERIALIZED_NAME_WEBSITE = "website";
    @SerializedName(value="website")
    private String website;
    public static final String SERIALIZED_NAME_LOGO_URL = "logo_url";
    @SerializedName(value="logo_url")
    private String logoUrl;
    public static final String SERIALIZED_NAME_CONFIDENCE_LEVEL = "confidence_level";
    @SerializedName(value="confidence_level")
    private String confidenceLevel;

    public TransactionCounterparty name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the counterparty, such as the merchant or the financial institution, as extracted by Plaid from the raw description.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TransactionCounterparty entityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique, stable, Plaid-generated ID that maps to the counterparty.")
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public TransactionCounterparty type(CounterpartyType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CounterpartyType getType() {
        return this.type;
    }

    public void setType(CounterpartyType type) {
        this.type = type;
    }

    public TransactionCounterparty website(String website) {
        this.website = website;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The website associated with the counterparty.")
    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public TransactionCounterparty logoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The URL of a logo associated with the counterparty, if available. The logo will always be 100\u00d7100 pixel PNG file.")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public TransactionCounterparty confidenceLevel(String confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A description of how confident we are that the provided counterparty is involved in the transaction.  `VERY_HIGH`: We recognize this counterparty and we are more than 98% confident that it is involved in this transaction. `HIGH`: We recognize this counterparty and we are more than 90% confident that it is involved in this transaction. `MEDIUM`: We are moderately confident that this counterparty was involved in this transaction, but some details may differ from our records. `LOW`: We didn\u2019t find a matching counterparty in our records, so we are returning a cleansed name parsed out of the request description. `UNKNOWN`: We don\u2019t know the confidence level for this counterparty.")
    public String getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public void setConfidenceLevel(String confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionCounterparty transactionCounterparty = (TransactionCounterparty)o;
        return Objects.equals(this.name, transactionCounterparty.name) && Objects.equals(this.entityId, transactionCounterparty.entityId) && Objects.equals((Object)this.type, (Object)transactionCounterparty.type) && Objects.equals(this.website, transactionCounterparty.website) && Objects.equals(this.logoUrl, transactionCounterparty.logoUrl) && Objects.equals(this.confidenceLevel, transactionCounterparty.confidenceLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.entityId, this.type, this.website, this.logoUrl, this.confidenceLevel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionCounterparty {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    logoUrl: ").append(this.toIndentedString(this.logoUrl)).append("\n");
        sb.append("    confidenceLevel: ").append(this.toIndentedString(this.confidenceLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

