/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Data to populate as test transaction data. If not specified, random transactions will be generated instead.")
public class TransactionOverride {
    public static final String SERIALIZED_NAME_DATE_TRANSACTED = "date_transacted";
    @SerializedName(value="date_transacted")
    private LocalDate dateTransacted;
    public static final String SERIALIZED_NAME_DATE_POSTED = "date_posted";
    @SerializedName(value="date_posted")
    private LocalDate datePosted;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;

    public TransactionOverride dateTransacted(LocalDate dateTransacted) {
        this.dateTransacted = dateTransacted;
        return this;
    }

    @ApiModelProperty(required=true, value="The date of the transaction, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format. Transactions in Sandbox will move from pending to posted once their transaction date has been reached. If a `date_transacted` is not provided by the institution, a transaction date may be available in the [`authorized_date`](https://plaid.com/docs/api/products/transactions/#transactions-get-response-transactions-authorized-date) field.")
    public LocalDate getDateTransacted() {
        return this.dateTransacted;
    }

    public void setDateTransacted(LocalDate dateTransacted) {
        this.dateTransacted = dateTransacted;
    }

    public TransactionOverride datePosted(LocalDate datePosted) {
        this.datePosted = datePosted;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the transaction posted, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format. Posted dates in the past or present will result in posted transactions; posted dates in the future will result in pending transactions.")
    public LocalDate getDatePosted() {
        return this.datePosted;
    }

    public void setDatePosted(LocalDate datePosted) {
        this.datePosted = datePosted;
    }

    public TransactionOverride amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The transaction amount. Can be negative.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public TransactionOverride description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The transaction description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransactionOverride currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO-4217 format currency code for the transaction.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionOverride transactionOverride = (TransactionOverride)o;
        return Objects.equals(this.dateTransacted, transactionOverride.dateTransacted) && Objects.equals(this.datePosted, transactionOverride.datePosted) && Objects.equals(this.amount, transactionOverride.amount) && Objects.equals(this.description, transactionOverride.description) && Objects.equals(this.currency, transactionOverride.currency);
    }

    public int hashCode() {
        return Objects.hash(this.dateTransacted, this.datePosted, this.amount, this.description, this.currency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionOverride {\n");
        sb.append("    dateTransacted: ").append(this.toIndentedString(this.dateTransacted)).append("\n");
        sb.append("    datePosted: ").append(this.toIndentedString(this.datePosted)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

