/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PersonalFinanceCategory;
import com.plaid.client.model.RecurringTransactionFrequency;
import com.plaid.client.model.TransactionStreamAmount;
import com.plaid.client.model.TransactionStreamStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A grouping of related transactions")
public class TransactionStream {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_STREAM_ID = "stream_id";
    @SerializedName(value="stream_id")
    private String streamId;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private List<String> category = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CATEGORY_ID = "category_id";
    @SerializedName(value="category_id")
    private String categoryId;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchant_name";
    @SerializedName(value="merchant_name")
    private String merchantName;
    public static final String SERIALIZED_NAME_FIRST_DATE = "first_date";
    @SerializedName(value="first_date")
    private LocalDate firstDate;
    public static final String SERIALIZED_NAME_LAST_DATE = "last_date";
    @SerializedName(value="last_date")
    private LocalDate lastDate;
    public static final String SERIALIZED_NAME_FREQUENCY = "frequency";
    @SerializedName(value="frequency")
    private RecurringTransactionFrequency frequency;
    public static final String SERIALIZED_NAME_TRANSACTION_IDS = "transaction_ids";
    @SerializedName(value="transaction_ids")
    private List<String> transactionIds = new ArrayList<String>();
    public static final String SERIALIZED_NAME_AVERAGE_AMOUNT = "average_amount";
    @SerializedName(value="average_amount")
    private TransactionStreamAmount averageAmount;
    public static final String SERIALIZED_NAME_LAST_AMOUNT = "last_amount";
    @SerializedName(value="last_amount")
    private TransactionStreamAmount lastAmount;
    public static final String SERIALIZED_NAME_IS_ACTIVE = "is_active";
    @SerializedName(value="is_active")
    private Boolean isActive;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TransactionStreamStatus status;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY = "personal_finance_category";
    @SerializedName(value="personal_finance_category")
    private PersonalFinanceCategory personalFinanceCategory;
    public static final String SERIALIZED_NAME_IS_USER_MODIFIED = "is_user_modified";
    @SerializedName(value="is_user_modified")
    private Boolean isUserModified;
    public static final String SERIALIZED_NAME_LAST_USER_MODIFIED_DATETIME = "last_user_modified_datetime";
    @SerializedName(value="last_user_modified_datetime")
    private OffsetDateTime lastUserModifiedDatetime;

    public TransactionStream accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the account to which the stream belongs")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransactionStream streamId(String streamId) {
        this.streamId = streamId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique id for the stream")
    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public TransactionStream category(List<String> category) {
        this.category = category;
        return this;
    }

    public TransactionStream addCategoryItem(String categoryItem) {
        this.category.add(categoryItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A hierarchical array of the categories to which this transaction belongs. See [Categories](https://plaid.com/docs/api/products/transactions/#categoriesget).  All implementations are encouraged to use the new `personal_finance_category` instead of `category`. `personal_finance_category` provides more meaningful categorization and greater accuracy.")
    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }

    public TransactionStream categoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the category to which this transaction belongs. See [Categories](https://plaid.com/docs/api/products/transactions/#categoriesget).  All implementations are encouraged to use the new `personal_finance_category` instead of `category`. `personal_finance_category` provides more meaningful categorization and greater accuracy.")
    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public TransactionStream description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="A description of the transaction stream.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransactionStream merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The merchant associated with the transaction stream.")
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public TransactionStream firstDate(LocalDate firstDate) {
        this.firstDate = firstDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The posted date of the earliest transaction in the stream.")
    public LocalDate getFirstDate() {
        return this.firstDate;
    }

    public void setFirstDate(LocalDate firstDate) {
        this.firstDate = firstDate;
    }

    public TransactionStream lastDate(LocalDate lastDate) {
        this.lastDate = lastDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The posted date of the latest transaction in the stream.")
    public LocalDate getLastDate() {
        return this.lastDate;
    }

    public void setLastDate(LocalDate lastDate) {
        this.lastDate = lastDate;
    }

    public TransactionStream frequency(RecurringTransactionFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public RecurringTransactionFrequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(RecurringTransactionFrequency frequency) {
        this.frequency = frequency;
    }

    public TransactionStream transactionIds(List<String> transactionIds) {
        this.transactionIds = transactionIds;
        return this;
    }

    public TransactionStream addTransactionIdsItem(String transactionIdsItem) {
        this.transactionIds.add(transactionIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of Plaid transaction IDs belonging to the stream, sorted by posted date.")
    public List<String> getTransactionIds() {
        return this.transactionIds;
    }

    public void setTransactionIds(List<String> transactionIds) {
        this.transactionIds = transactionIds;
    }

    public TransactionStream averageAmount(TransactionStreamAmount averageAmount) {
        this.averageAmount = averageAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransactionStreamAmount getAverageAmount() {
        return this.averageAmount;
    }

    public void setAverageAmount(TransactionStreamAmount averageAmount) {
        this.averageAmount = averageAmount;
    }

    public TransactionStream lastAmount(TransactionStreamAmount lastAmount) {
        this.lastAmount = lastAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransactionStreamAmount getLastAmount() {
        return this.lastAmount;
    }

    public void setLastAmount(TransactionStreamAmount lastAmount) {
        this.lastAmount = lastAmount;
    }

    public TransactionStream isActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the transaction stream is still live.")
    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public TransactionStream status(TransactionStreamStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransactionStreamStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransactionStreamStatus status) {
        this.status = status;
    }

    public TransactionStream personalFinanceCategory(PersonalFinanceCategory personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PersonalFinanceCategory getPersonalFinanceCategory() {
        return this.personalFinanceCategory;
    }

    public void setPersonalFinanceCategory(PersonalFinanceCategory personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
    }

    public TransactionStream isUserModified(Boolean isUserModified) {
        this.isUserModified = isUserModified;
        return this;
    }

    @ApiModelProperty(required=true, value="This will be set to `true` if the stream has been modified by request to a `/transactions/recurring/streams` endpoint. It will be `false` for all other streams.")
    public Boolean getIsUserModified() {
        return this.isUserModified;
    }

    public void setIsUserModified(Boolean isUserModified) {
        this.isUserModified = isUserModified;
    }

    public TransactionStream lastUserModifiedDatetime(OffsetDateTime lastUserModifiedDatetime) {
        this.lastUserModifiedDatetime = lastUserModifiedDatetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time of the most recent user modification. This will only be set if `is_user_modified` is `true`.")
    public OffsetDateTime getLastUserModifiedDatetime() {
        return this.lastUserModifiedDatetime;
    }

    public void setLastUserModifiedDatetime(OffsetDateTime lastUserModifiedDatetime) {
        this.lastUserModifiedDatetime = lastUserModifiedDatetime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionStream transactionStream = (TransactionStream)o;
        return Objects.equals(this.accountId, transactionStream.accountId) && Objects.equals(this.streamId, transactionStream.streamId) && Objects.equals(this.category, transactionStream.category) && Objects.equals(this.categoryId, transactionStream.categoryId) && Objects.equals(this.description, transactionStream.description) && Objects.equals(this.merchantName, transactionStream.merchantName) && Objects.equals(this.firstDate, transactionStream.firstDate) && Objects.equals(this.lastDate, transactionStream.lastDate) && Objects.equals((Object)this.frequency, (Object)transactionStream.frequency) && Objects.equals(this.transactionIds, transactionStream.transactionIds) && Objects.equals(this.averageAmount, transactionStream.averageAmount) && Objects.equals(this.lastAmount, transactionStream.lastAmount) && Objects.equals(this.isActive, transactionStream.isActive) && Objects.equals((Object)this.status, (Object)transactionStream.status) && Objects.equals(this.personalFinanceCategory, transactionStream.personalFinanceCategory) && Objects.equals(this.isUserModified, transactionStream.isUserModified) && Objects.equals(this.lastUserModifiedDatetime, transactionStream.lastUserModifiedDatetime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.streamId, this.category, this.categoryId, this.description, this.merchantName, this.firstDate, this.lastDate, this.frequency, this.transactionIds, this.averageAmount, this.lastAmount, this.isActive, this.status, this.personalFinanceCategory, this.isUserModified, this.lastUserModifiedDatetime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionStream {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    streamId: ").append(this.toIndentedString(this.streamId)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    firstDate: ").append(this.toIndentedString(this.firstDate)).append("\n");
        sb.append("    lastDate: ").append(this.toIndentedString(this.lastDate)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString((Object)this.frequency)).append("\n");
        sb.append("    transactionIds: ").append(this.toIndentedString(this.transactionIds)).append("\n");
        sb.append("    averageAmount: ").append(this.toIndentedString(this.averageAmount)).append("\n");
        sb.append("    lastAmount: ").append(this.toIndentedString(this.lastAmount)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    personalFinanceCategory: ").append(this.toIndentedString(this.personalFinanceCategory)).append("\n");
        sb.append("    isUserModified: ").append(this.toIndentedString(this.isUserModified)).append("\n");
        sb.append("    lastUserModifiedDatetime: ").append(this.toIndentedString(this.lastUserModifiedDatetime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

