/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransactionsRuleDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A representation of a transactions category rule.")
public class TransactionsCategoryRule {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY = "personal_finance_category";
    @SerializedName(value="personal_finance_category")
    private String personalFinanceCategory;
    public static final String SERIALIZED_NAME_RULE_DETAILS = "rule_details";
    @SerializedName(value="rule_details")
    private TransactionsRuleDetails ruleDetails;

    public TransactionsCategoryRule id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier of the rule created")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransactionsCategoryRule itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier of the Item the rule was created for.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public TransactionsCategoryRule createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date and time when a rule was created in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DDTHH:mm:ssZ` ). ")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public TransactionsCategoryRule personalFinanceCategory(String personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Personal finance category unique identifier.  In the personal finance category taxonomy, this field is represented by the detailed category field. ")
    public String getPersonalFinanceCategory() {
        return this.personalFinanceCategory;
    }

    public void setPersonalFinanceCategory(String personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
    }

    public TransactionsCategoryRule ruleDetails(TransactionsRuleDetails ruleDetails) {
        this.ruleDetails = ruleDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransactionsRuleDetails getRuleDetails() {
        return this.ruleDetails;
    }

    public void setRuleDetails(TransactionsRuleDetails ruleDetails) {
        this.ruleDetails = ruleDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsCategoryRule transactionsCategoryRule = (TransactionsCategoryRule)o;
        return Objects.equals(this.id, transactionsCategoryRule.id) && Objects.equals(this.itemId, transactionsCategoryRule.itemId) && Objects.equals(this.createdAt, transactionsCategoryRule.createdAt) && Objects.equals(this.personalFinanceCategory, transactionsCategoryRule.personalFinanceCategory) && Objects.equals(this.ruleDetails, transactionsCategoryRule.ruleDetails);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.itemId, this.createdAt, this.personalFinanceCategory, this.ruleDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsCategoryRule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    personalFinanceCategory: ").append(this.toIndentedString(this.personalFinanceCategory)).append("\n");
        sb.append("    ruleDetails: ").append(this.toIndentedString(this.ruleDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

