/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ClientProvidedRawTransaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TransactionsEnhanceGetRequest defines the request schema for `/transactions/enhance`.")
public class TransactionsEnhanceGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
    @SerializedName(value="account_type")
    private String accountType;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<ClientProvidedRawTransaction> transactions = new ArrayList<ClientProvidedRawTransaction>();

    public TransactionsEnhanceGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransactionsEnhanceGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransactionsEnhanceGetRequest accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of account for the requested transactions (`depository` or `credit`).")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public TransactionsEnhanceGetRequest transactions(List<ClientProvidedRawTransaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public TransactionsEnhanceGetRequest addTransactionsItem(ClientProvidedRawTransaction transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of raw transactions to be enhanced.")
    public List<ClientProvidedRawTransaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<ClientProvidedRawTransaction> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsEnhanceGetRequest transactionsEnhanceGetRequest = (TransactionsEnhanceGetRequest)o;
        return Objects.equals(this.clientId, transactionsEnhanceGetRequest.clientId) && Objects.equals(this.secret, transactionsEnhanceGetRequest.secret) && Objects.equals(this.accountType, transactionsEnhanceGetRequest.accountType) && Objects.equals(this.transactions, transactionsEnhanceGetRequest.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.accountType, this.transactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsEnhanceGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

