/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An optional object to be used with the request.")
public class TransactionsEnrichRequestOptions {
    public static final String SERIALIZED_NAME_INCLUDE_LEGACY_CATEGORY = "include_legacy_category";
    @SerializedName(value="include_legacy_category")
    private Boolean includeLegacyCategory = false;

    public TransactionsEnrichRequestOptions includeLegacyCategory(Boolean includeLegacyCategory) {
        this.includeLegacyCategory = includeLegacyCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include `legacy_category` and `legacy_category_id` in the response (in addition to the default `personal_finance_category`).  Categories are based on Plaid's legacy taxonomy. For a full list of legacy categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).")
    public Boolean getIncludeLegacyCategory() {
        return this.includeLegacyCategory;
    }

    public void setIncludeLegacyCategory(Boolean includeLegacyCategory) {
        this.includeLegacyCategory = includeLegacyCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsEnrichRequestOptions transactionsEnrichRequestOptions = (TransactionsEnrichRequestOptions)o;
        return Objects.equals(this.includeLegacyCategory, transactionsEnrichRequestOptions.includeLegacyCategory);
    }

    public int hashCode() {
        return Objects.hash(this.includeLegacyCategory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsEnrichRequestOptions {\n");
        sb.append("    includeLegacyCategory: ").append(this.toIndentedString(this.includeLegacyCategory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

