/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ClientProvidedEnrichedTransaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TransactionsEnrichResponse defines the response schema for `/transactions/enrich`.")
public class TransactionsEnrichResponse {
    public static final String SERIALIZED_NAME_ENRICHED_TRANSACTIONS = "enriched_transactions";
    @SerializedName(value="enriched_transactions")
    private List<ClientProvidedEnrichedTransaction> enrichedTransactions = new ArrayList<ClientProvidedEnrichedTransaction>();
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public TransactionsEnrichResponse enrichedTransactions(List<ClientProvidedEnrichedTransaction> enrichedTransactions) {
        this.enrichedTransactions = enrichedTransactions;
        return this;
    }

    public TransactionsEnrichResponse addEnrichedTransactionsItem(ClientProvidedEnrichedTransaction enrichedTransactionsItem) {
        this.enrichedTransactions.add(enrichedTransactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of enriched transactions.")
    public List<ClientProvidedEnrichedTransaction> getEnrichedTransactions() {
        return this.enrichedTransactions;
    }

    public void setEnrichedTransactions(List<ClientProvidedEnrichedTransaction> enrichedTransactions) {
        this.enrichedTransactions = enrichedTransactions;
    }

    public TransactionsEnrichResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsEnrichResponse transactionsEnrichResponse = (TransactionsEnrichResponse)o;
        return Objects.equals(this.enrichedTransactions, transactionsEnrichResponse.enrichedTransactions) && Objects.equals(this.requestId, transactionsEnrichResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.enrichedTransactions, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsEnrichResponse {\n");
        sb.append("    enrichedTransactions: ").append(this.toIndentedString(this.enrichedTransactions)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

