/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountBase;
import com.plaid.client.model.Item;
import com.plaid.client.model.Transaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="TransactionsGetResponse defines the response schema for `/transactions/get`")
public class TransactionsGetResponse {
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<AccountBase> accounts = new ArrayList<AccountBase>();
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<Transaction> transactions = new ArrayList<Transaction>();
    public static final String SERIALIZED_NAME_TOTAL_TRANSACTIONS = "total_transactions";
    @SerializedName(value="total_transactions")
    private Integer totalTransactions;
    public static final String SERIALIZED_NAME_ITEM = "item";
    @SerializedName(value="item")
    private Item item;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public TransactionsGetResponse accounts(List<AccountBase> accounts) {
        this.accounts = accounts;
        return this;
    }

    public TransactionsGetResponse addAccountsItem(AccountBase accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array containing the `accounts` associated with the Item for which transactions are being returned. Each transaction can be mapped to its corresponding account via the `account_id` field.")
    public List<AccountBase> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountBase> accounts) {
        this.accounts = accounts;
    }

    public TransactionsGetResponse transactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public TransactionsGetResponse addTransactionsItem(Transaction transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array containing transactions from the account. Transactions are returned in reverse chronological order, with the most recent at the beginning of the array. The maximum number of transactions returned is determined by the `count` parameter.")
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    public TransactionsGetResponse totalTransactions(Integer totalTransactions) {
        this.totalTransactions = totalTransactions;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of transactions available within the date range specified. If `total_transactions` is larger than the size of the `transactions` array, more transactions are available and can be fetched via manipulating the `offset` parameter.")
    public Integer getTotalTransactions() {
        return this.totalTransactions;
    }

    public void setTotalTransactions(Integer totalTransactions) {
        this.totalTransactions = totalTransactions;
    }

    public TransactionsGetResponse item(Item item) {
        this.item = item;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public TransactionsGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsGetResponse transactionsGetResponse = (TransactionsGetResponse)o;
        return Objects.equals(this.accounts, transactionsGetResponse.accounts) && Objects.equals(this.transactions, transactionsGetResponse.transactions) && Objects.equals(this.totalTransactions, transactionsGetResponse.totalTransactions) && Objects.equals(this.item, transactionsGetResponse.item) && Objects.equals(this.requestId, transactionsGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.transactions, this.totalTransactions, this.item, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsGetResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    totalTransactions: ").append(this.toIndentedString(this.totalTransactions)).append("\n");
        sb.append("    item: ").append(this.toIndentedString(this.item)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

