/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransactionStream;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TransactionsRecurringCreateResponse defines the response schema for the `/transactions/recurring/streams/create` endpoint.")
public class TransactionsRecurringCreateResponse {
    public static final String SERIALIZED_NAME_ADDED_STREAMS = "added_streams";
    @SerializedName(value="added_streams")
    private List<TransactionStream> addedStreams = new ArrayList<TransactionStream>();
    public static final String SERIALIZED_NAME_MODIFIED_STREAMS = "modified_streams";
    @SerializedName(value="modified_streams")
    private List<TransactionStream> modifiedStreams = null;
    public static final String SERIALIZED_NAME_REMOVED_STREAM_IDS = "removed_stream_ids";
    @SerializedName(value="removed_stream_ids")
    private List<String> removedStreamIds = null;

    public TransactionsRecurringCreateResponse addedStreams(List<TransactionStream> addedStreams) {
        this.addedStreams = addedStreams;
        return this;
    }

    public TransactionsRecurringCreateResponse addAddedStreamsItem(TransactionStream addedStreamsItem) {
        this.addedStreams.add(addedStreamsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Streams created as a result of the operation.")
    public List<TransactionStream> getAddedStreams() {
        return this.addedStreams;
    }

    public void setAddedStreams(List<TransactionStream> addedStreams) {
        this.addedStreams = addedStreams;
    }

    public TransactionsRecurringCreateResponse modifiedStreams(List<TransactionStream> modifiedStreams) {
        this.modifiedStreams = modifiedStreams;
        return this;
    }

    public TransactionsRecurringCreateResponse addModifiedStreamsItem(TransactionStream modifiedStreamsItem) {
        if (this.modifiedStreams == null) {
            this.modifiedStreams = new ArrayList<TransactionStream>();
        }
        this.modifiedStreams.add(modifiedStreamsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Other streams with transactions removed from them as a result of the operation (in no particular order).")
    public List<TransactionStream> getModifiedStreams() {
        return this.modifiedStreams;
    }

    public void setModifiedStreams(List<TransactionStream> modifiedStreams) {
        this.modifiedStreams = modifiedStreams;
    }

    public TransactionsRecurringCreateResponse removedStreamIds(List<String> removedStreamIds) {
        this.removedStreamIds = removedStreamIds;
        return this;
    }

    public TransactionsRecurringCreateResponse addRemovedStreamIdsItem(String removedStreamIdsItem) {
        if (this.removedStreamIds == null) {
            this.removedStreamIds = new ArrayList<String>();
        }
        this.removedStreamIds.add(removedStreamIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ids of streams that are no longer qualified as recurring transaction streams (in no particular order).")
    public List<String> getRemovedStreamIds() {
        return this.removedStreamIds;
    }

    public void setRemovedStreamIds(List<String> removedStreamIds) {
        this.removedStreamIds = removedStreamIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsRecurringCreateResponse transactionsRecurringCreateResponse = (TransactionsRecurringCreateResponse)o;
        return Objects.equals(this.addedStreams, transactionsRecurringCreateResponse.addedStreams) && Objects.equals(this.modifiedStreams, transactionsRecurringCreateResponse.modifiedStreams) && Objects.equals(this.removedStreamIds, transactionsRecurringCreateResponse.removedStreamIds);
    }

    public int hashCode() {
        return Objects.hash(this.addedStreams, this.modifiedStreams, this.removedStreamIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsRecurringCreateResponse {\n");
        sb.append("    addedStreams: ").append(this.toIndentedString(this.addedStreams)).append("\n");
        sb.append("    modifiedStreams: ").append(this.toIndentedString(this.modifiedStreams)).append("\n");
        sb.append("    removedStreamIds: ").append(this.toIndentedString(this.removedStreamIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

