/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransactionsRecurringGetRequestOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TransactionsRecurringGetRequest defines the request schema for `/transactions/recurring/get`")
public class TransactionsRecurringGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private TransactionsRecurringGetRequestOptions options;
    public static final String SERIALIZED_NAME_ACCOUNT_IDS = "account_ids";
    @SerializedName(value="account_ids")
    private List<String> accountIds = null;

    public TransactionsRecurringGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransactionsRecurringGetRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TransactionsRecurringGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransactionsRecurringGetRequest options(TransactionsRecurringGetRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransactionsRecurringGetRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(TransactionsRecurringGetRequestOptions options) {
        this.options = options;
    }

    public TransactionsRecurringGetRequest accountIds(List<String> accountIds) {
        this.accountIds = accountIds;
        return this;
    }

    public TransactionsRecurringGetRequest addAccountIdsItem(String accountIdsItem) {
        if (this.accountIds == null) {
            this.accountIds = new ArrayList<String>();
        }
        this.accountIds.add(accountIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional list of `account_ids` to retrieve for the Item. Retrieves all active accounts on item if no `account_id`s are provided.  Note: An error will be returned if a provided `account_id` is not associated with the Item.")
    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(List<String> accountIds) {
        this.accountIds = accountIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsRecurringGetRequest transactionsRecurringGetRequest = (TransactionsRecurringGetRequest)o;
        return Objects.equals(this.clientId, transactionsRecurringGetRequest.clientId) && Objects.equals(this.accessToken, transactionsRecurringGetRequest.accessToken) && Objects.equals(this.secret, transactionsRecurringGetRequest.secret) && Objects.equals(this.options, transactionsRecurringGetRequest.options) && Objects.equals(this.accountIds, transactionsRecurringGetRequest.accountIds);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.accessToken, this.secret, this.options, this.accountIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsRecurringGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    accountIds: ").append(this.toIndentedString(this.accountIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

