/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransactionStream;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TransactionsRecurringMergeResponse defines the response schema for the `/transactions/recurring/streams/merge` endpoint.")
public class TransactionsRecurringMergeResponse {
    public static final String SERIALIZED_NAME_MODIFIED_STREAMS = "modified_streams";
    @SerializedName(value="modified_streams")
    private List<TransactionStream> modifiedStreams = new ArrayList<TransactionStream>();
    public static final String SERIALIZED_NAME_REMOVED_STREAM_IDS = "removed_stream_ids";
    @SerializedName(value="removed_stream_ids")
    private List<String> removedStreamIds = null;

    public TransactionsRecurringMergeResponse modifiedStreams(List<TransactionStream> modifiedStreams) {
        this.modifiedStreams = modifiedStreams;
        return this;
    }

    public TransactionsRecurringMergeResponse addModifiedStreamsItem(TransactionStream modifiedStreamsItem) {
        this.modifiedStreams.add(modifiedStreamsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Directly modified stream, along with other streams with transactions removed from them as a result of the operation (in no particular order).")
    public List<TransactionStream> getModifiedStreams() {
        return this.modifiedStreams;
    }

    public void setModifiedStreams(List<TransactionStream> modifiedStreams) {
        this.modifiedStreams = modifiedStreams;
    }

    public TransactionsRecurringMergeResponse removedStreamIds(List<String> removedStreamIds) {
        this.removedStreamIds = removedStreamIds;
        return this;
    }

    public TransactionsRecurringMergeResponse addRemovedStreamIdsItem(String removedStreamIdsItem) {
        if (this.removedStreamIds == null) {
            this.removedStreamIds = new ArrayList<String>();
        }
        this.removedStreamIds.add(removedStreamIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ids of streams that are no longer qualified as recurring transaction streams (in no particular order).")
    public List<String> getRemovedStreamIds() {
        return this.removedStreamIds;
    }

    public void setRemovedStreamIds(List<String> removedStreamIds) {
        this.removedStreamIds = removedStreamIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsRecurringMergeResponse transactionsRecurringMergeResponse = (TransactionsRecurringMergeResponse)o;
        return Objects.equals(this.modifiedStreams, transactionsRecurringMergeResponse.modifiedStreams) && Objects.equals(this.removedStreamIds, transactionsRecurringMergeResponse.removedStreamIds);
    }

    public int hashCode() {
        return Objects.hash(this.modifiedStreams, this.removedStreamIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsRecurringMergeResponse {\n");
        sb.append("    modifiedStreams: ").append(this.toIndentedString(this.modifiedStreams)).append("\n");
        sb.append("    removedStreamIds: ").append(this.toIndentedString(this.removedStreamIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

