/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransactionsRecurringUpdateInput;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TransactionsRecurringUpdateRequest defined the request schema for `/transactions/recurring/streams/update` endpoint.")
public class TransactionsRecurringUpdateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_INPUTS = "inputs";
    @SerializedName(value="inputs")
    private List<TransactionsRecurringUpdateInput> inputs = new ArrayList<TransactionsRecurringUpdateInput>();

    public TransactionsRecurringUpdateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransactionsRecurringUpdateRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TransactionsRecurringUpdateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransactionsRecurringUpdateRequest inputs(List<TransactionsRecurringUpdateInput> inputs) {
        this.inputs = inputs;
        return this;
    }

    public TransactionsRecurringUpdateRequest addInputsItem(TransactionsRecurringUpdateInput inputsItem) {
        this.inputs.add(inputsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of all the operations to be performed. This will either all succeed or all fail.")
    public List<TransactionsRecurringUpdateInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<TransactionsRecurringUpdateInput> inputs) {
        this.inputs = inputs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsRecurringUpdateRequest transactionsRecurringUpdateRequest = (TransactionsRecurringUpdateRequest)o;
        return Objects.equals(this.clientId, transactionsRecurringUpdateRequest.clientId) && Objects.equals(this.accessToken, transactionsRecurringUpdateRequest.accessToken) && Objects.equals(this.secret, transactionsRecurringUpdateRequest.secret) && Objects.equals(this.inputs, transactionsRecurringUpdateRequest.inputs);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.accessToken, this.secret, this.inputs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsRecurringUpdateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

