/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransactionsRuleDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TransactionsRulesCreateRequest defines the request schema for `beta/transactions/rules/v1/create`")
public class TransactionsRulesCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY = "personal_finance_category";
    @SerializedName(value="personal_finance_category")
    private String personalFinanceCategory;
    public static final String SERIALIZED_NAME_RULE_DETAILS = "rule_details";
    @SerializedName(value="rule_details")
    private TransactionsRuleDetails ruleDetails;

    public TransactionsRulesCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransactionsRulesCreateRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TransactionsRulesCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransactionsRulesCreateRequest personalFinanceCategory(String personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
        return this;
    }

    @ApiModelProperty(required=true, value="Personal finance detailed category.  All implementations are encouraged to use this field instead of `category`, as it provides more meaningful and accurate categorization.  See the [`taxonomy csv file`](https://plaid.com/documents/transactions-personal-finance-category-taxonomy.csv) for a full list of personal finance categories. ")
    public String getPersonalFinanceCategory() {
        return this.personalFinanceCategory;
    }

    public void setPersonalFinanceCategory(String personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
    }

    public TransactionsRulesCreateRequest ruleDetails(TransactionsRuleDetails ruleDetails) {
        this.ruleDetails = ruleDetails;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransactionsRuleDetails getRuleDetails() {
        return this.ruleDetails;
    }

    public void setRuleDetails(TransactionsRuleDetails ruleDetails) {
        this.ruleDetails = ruleDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsRulesCreateRequest transactionsRulesCreateRequest = (TransactionsRulesCreateRequest)o;
        return Objects.equals(this.clientId, transactionsRulesCreateRequest.clientId) && Objects.equals(this.accessToken, transactionsRulesCreateRequest.accessToken) && Objects.equals(this.secret, transactionsRulesCreateRequest.secret) && Objects.equals(this.personalFinanceCategory, transactionsRulesCreateRequest.personalFinanceCategory) && Objects.equals(this.ruleDetails, transactionsRulesCreateRequest.ruleDetails);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.accessToken, this.secret, this.personalFinanceCategory, this.ruleDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsRulesCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    personalFinanceCategory: ").append(this.toIndentedString(this.personalFinanceCategory)).append("\n");
        sb.append("    ruleDetails: ").append(this.toIndentedString(this.ruleDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

