/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransactionsCategoryRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="TransactionsRulesListResponse defines the response schema for `/beta/transactions/rules/v1/list`")
public class TransactionsRulesListResponse {
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    private List<TransactionsCategoryRule> rules = new ArrayList<TransactionsCategoryRule>();
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public TransactionsRulesListResponse rules(List<TransactionsCategoryRule> rules) {
        this.rules = rules;
        return this;
    }

    public TransactionsRulesListResponse addRulesItem(TransactionsCategoryRule rulesItem) {
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of the Item's transaction rules")
    public List<TransactionsCategoryRule> getRules() {
        return this.rules;
    }

    public void setRules(List<TransactionsCategoryRule> rules) {
        this.rules = rules;
    }

    public TransactionsRulesListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsRulesListResponse transactionsRulesListResponse = (TransactionsRulesListResponse)o;
        return Objects.equals(this.rules, transactionsRulesListResponse.rules) && Objects.equals(this.requestId, transactionsRulesListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.rules, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsRulesListResponse {\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

