/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TransactionsRulesRemoveRequest defines the request schema for `/beta/transactions/rules/v1/remove`")
public class TransactionsRulesRemoveRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_RULE_ID = "rule_id";
    @SerializedName(value="rule_id")
    private String ruleId;

    public TransactionsRulesRemoveRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransactionsRulesRemoveRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TransactionsRulesRemoveRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransactionsRulesRemoveRequest ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @ApiModelProperty(required=true, value="A rule's unique identifier")
    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsRulesRemoveRequest transactionsRulesRemoveRequest = (TransactionsRulesRemoveRequest)o;
        return Objects.equals(this.clientId, transactionsRulesRemoveRequest.clientId) && Objects.equals(this.accessToken, transactionsRulesRemoveRequest.accessToken) && Objects.equals(this.secret, transactionsRulesRemoveRequest.secret) && Objects.equals(this.ruleId, transactionsRulesRemoveRequest.ruleId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.accessToken, this.secret, this.ruleId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsRulesRemoveRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    ruleId: ").append(this.toIndentedString(this.ruleId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

