/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransactionsSyncRequestOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TransactionsSyncRequest defines the request schema for `/transactions/sync`")
public class TransactionsSyncRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CURSOR = "cursor";
    @SerializedName(value="cursor")
    private String cursor;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 100;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private TransactionsSyncRequestOptions options;

    public TransactionsSyncRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransactionsSyncRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TransactionsSyncRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransactionsSyncRequest cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The cursor value represents the last update requested. Providing it will cause the response to only return changes after this update. If omitted, the entire history of updates will be returned, starting with the first-added transactions on the Item. The cursor also accepts the special value of `\"now\"`, which can be used to fast-forward the cursor as part of migrating an existing Item from `/transactions/get` to `/transactions/sync`. For more information, see the [Transactions sync migration guide](https://plaid.com/docs/transactions/sync-migration/). Note that using the `\"now\"` value is not supported for any use case other than migrating existing Items from `/transactions/get`.  The upper-bound length of this cursor is 256 characters of base64.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public TransactionsSyncRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of transaction updates to fetch.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public TransactionsSyncRequest options(TransactionsSyncRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransactionsSyncRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(TransactionsSyncRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsSyncRequest transactionsSyncRequest = (TransactionsSyncRequest)o;
        return Objects.equals(this.clientId, transactionsSyncRequest.clientId) && Objects.equals(this.accessToken, transactionsSyncRequest.accessToken) && Objects.equals(this.secret, transactionsSyncRequest.secret) && Objects.equals(this.cursor, transactionsSyncRequest.cursor) && Objects.equals(this.count, transactionsSyncRequest.count) && Objects.equals(this.options, transactionsSyncRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.accessToken, this.secret, this.cursor, this.count, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsSyncRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

