/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An optional object to be used with the request. If specified, `options` must not be `null`.")
public class TransactionsSyncRequestOptions {
    public static final String SERIALIZED_NAME_INCLUDE_ORIGINAL_DESCRIPTION = "include_original_description";
    @SerializedName(value="include_original_description")
    private Boolean includeOriginalDescription = false;
    public static final String SERIALIZED_NAME_INCLUDE_PERSONAL_FINANCE_CATEGORY = "include_personal_finance_category";
    @SerializedName(value="include_personal_finance_category")
    private Boolean includePersonalFinanceCategory = false;
    public static final String SERIALIZED_NAME_INCLUDE_LOGO_AND_COUNTERPARTY_BETA = "include_logo_and_counterparty_beta";
    @SerializedName(value="include_logo_and_counterparty_beta")
    private Boolean includeLogoAndCounterpartyBeta = false;
    public static final String SERIALIZED_NAME_DAYS_REQUESTED = "days_requested";
    @SerializedName(value="days_requested")
    private Integer daysRequested = 90;

    public TransactionsSyncRequestOptions includeOriginalDescription(Boolean includeOriginalDescription) {
        this.includeOriginalDescription = includeOriginalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include the raw unparsed transaction description from the financial institution.")
    public Boolean getIncludeOriginalDescription() {
        return this.includeOriginalDescription;
    }

    public void setIncludeOriginalDescription(Boolean includeOriginalDescription) {
        this.includeOriginalDescription = includeOriginalDescription;
    }

    public TransactionsSyncRequestOptions includePersonalFinanceCategory(Boolean includePersonalFinanceCategory) {
        this.includePersonalFinanceCategory = includePersonalFinanceCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Personal finance categories are now returned by default.")
    public Boolean getIncludePersonalFinanceCategory() {
        return this.includePersonalFinanceCategory;
    }

    public void setIncludePersonalFinanceCategory(Boolean includePersonalFinanceCategory) {
        this.includePersonalFinanceCategory = includePersonalFinanceCategory;
    }

    public TransactionsSyncRequestOptions includeLogoAndCounterpartyBeta(Boolean includeLogoAndCounterpartyBeta) {
        this.includeLogoAndCounterpartyBeta = includeLogoAndCounterpartyBeta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Counterparties and extra merchant fields are now returned by default.")
    public Boolean getIncludeLogoAndCounterpartyBeta() {
        return this.includeLogoAndCounterpartyBeta;
    }

    public void setIncludeLogoAndCounterpartyBeta(Boolean includeLogoAndCounterpartyBeta) {
        this.includeLogoAndCounterpartyBeta = includeLogoAndCounterpartyBeta;
    }

    public TransactionsSyncRequestOptions daysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This option only applies to calls for Items that were not initialized with Transactions during Link and are now adding the Transactions product to the Item for the first time. In these cases, this option controls the maximum number of days of transaction history that Plaid will request from the financial institution. For developer accounts created after December 3, 2023, if no value is specified, this will default to 90 days. For developer accounts created on December 3, 2023 or earlier, if no value is specified, this will default to 730 days until June 24, 2024, at which point it will default to 90 days.  If Transactions has already been added to the Item prior to this call, this field will have no effect.  We strongly recommend that customers utilizing [Recurring Transactions](https://plaid.com/docs/api/products/transactions/#transactionsrecurringget) request at least 180 days of history for optimal results.")
    public Integer getDaysRequested() {
        return this.daysRequested;
    }

    public void setDaysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsSyncRequestOptions transactionsSyncRequestOptions = (TransactionsSyncRequestOptions)o;
        return Objects.equals(this.includeOriginalDescription, transactionsSyncRequestOptions.includeOriginalDescription) && Objects.equals(this.includePersonalFinanceCategory, transactionsSyncRequestOptions.includePersonalFinanceCategory) && Objects.equals(this.includeLogoAndCounterpartyBeta, transactionsSyncRequestOptions.includeLogoAndCounterpartyBeta) && Objects.equals(this.daysRequested, transactionsSyncRequestOptions.daysRequested);
    }

    public int hashCode() {
        return Objects.hash(this.includeOriginalDescription, this.includePersonalFinanceCategory, this.includeLogoAndCounterpartyBeta, this.daysRequested);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsSyncRequestOptions {\n");
        sb.append("    includeOriginalDescription: ").append(this.toIndentedString(this.includeOriginalDescription)).append("\n");
        sb.append("    includePersonalFinanceCategory: ").append(this.toIndentedString(this.includePersonalFinanceCategory)).append("\n");
        sb.append("    includeLogoAndCounterpartyBeta: ").append(this.toIndentedString(this.includeLogoAndCounterpartyBeta)).append("\n");
        sb.append("    daysRequested: ").append(this.toIndentedString(this.daysRequested)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

