/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountBase;
import com.plaid.client.model.RemovedTransaction;
import com.plaid.client.model.Transaction;
import com.plaid.client.model.TransactionsUpdateStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="TransactionsSyncResponse defines the response schema for `/transactions/sync`")
public class TransactionsSyncResponse {
    public static final String SERIALIZED_NAME_TRANSACTIONS_UPDATE_STATUS = "transactions_update_status";
    @SerializedName(value="transactions_update_status")
    private TransactionsUpdateStatus transactionsUpdateStatus;
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<AccountBase> accounts = new ArrayList<AccountBase>();
    public static final String SERIALIZED_NAME_ADDED = "added";
    @SerializedName(value="added")
    private List<Transaction> added = new ArrayList<Transaction>();
    public static final String SERIALIZED_NAME_MODIFIED = "modified";
    @SerializedName(value="modified")
    private List<Transaction> modified = new ArrayList<Transaction>();
    public static final String SERIALIZED_NAME_REMOVED = "removed";
    @SerializedName(value="removed")
    private List<RemovedTransaction> removed = new ArrayList<RemovedTransaction>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private String nextCursor;
    public static final String SERIALIZED_NAME_HAS_MORE = "has_more";
    @SerializedName(value="has_more")
    private Boolean hasMore;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public TransactionsSyncResponse transactionsUpdateStatus(TransactionsUpdateStatus transactionsUpdateStatus) {
        this.transactionsUpdateStatus = transactionsUpdateStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransactionsUpdateStatus getTransactionsUpdateStatus() {
        return this.transactionsUpdateStatus;
    }

    public void setTransactionsUpdateStatus(TransactionsUpdateStatus transactionsUpdateStatus) {
        this.transactionsUpdateStatus = transactionsUpdateStatus;
    }

    public TransactionsSyncResponse accounts(List<AccountBase> accounts) {
        this.accounts = accounts;
        return this;
    }

    public TransactionsSyncResponse addAccountsItem(AccountBase accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of accounts at a financial institution associated with the transactions in this response.")
    public List<AccountBase> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountBase> accounts) {
        this.accounts = accounts;
    }

    public TransactionsSyncResponse added(List<Transaction> added) {
        this.added = added;
        return this;
    }

    public TransactionsSyncResponse addAddedItem(Transaction addedItem) {
        this.added.add(addedItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Transactions that have been added to the Item since `cursor` ordered by ascending last modified time.")
    public List<Transaction> getAdded() {
        return this.added;
    }

    public void setAdded(List<Transaction> added) {
        this.added = added;
    }

    public TransactionsSyncResponse modified(List<Transaction> modified) {
        this.modified = modified;
        return this;
    }

    public TransactionsSyncResponse addModifiedItem(Transaction modifiedItem) {
        this.modified.add(modifiedItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Transactions that have been modified on the Item since `cursor` ordered by ascending last modified time.")
    public List<Transaction> getModified() {
        return this.modified;
    }

    public void setModified(List<Transaction> modified) {
        this.modified = modified;
    }

    public TransactionsSyncResponse removed(List<RemovedTransaction> removed) {
        this.removed = removed;
        return this;
    }

    public TransactionsSyncResponse addRemovedItem(RemovedTransaction removedItem) {
        this.removed.add(removedItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Transactions that have been removed from the Item since `cursor` ordered by ascending last modified time.")
    public List<RemovedTransaction> getRemoved() {
        return this.removed;
    }

    public void setRemoved(List<RemovedTransaction> removed) {
        this.removed = removed;
    }

    public TransactionsSyncResponse nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @ApiModelProperty(required=true, value="Cursor used for fetching any future updates after the latest update provided in this response. The cursor obtained after all pages have been pulled (indicated by `has_more` being `false`) will be valid for at least 1 year. This cursor should be persisted for later calls. If transactions are not yet available, this will be an empty string.")
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public TransactionsSyncResponse hasMore(Boolean hasMore) {
        this.hasMore = hasMore;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents if more than requested count of transaction updates exist. If true, the additional updates can be fetched by making an additional request with `cursor` set to `next_cursor`. If `has_more` is true, it\u2019s important to pull all available pages, to make it less likely for underlying data changes to conflict with pagination.")
    public Boolean getHasMore() {
        return this.hasMore;
    }

    public void setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
    }

    public TransactionsSyncResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionsSyncResponse transactionsSyncResponse = (TransactionsSyncResponse)o;
        return Objects.equals((Object)this.transactionsUpdateStatus, (Object)transactionsSyncResponse.transactionsUpdateStatus) && Objects.equals(this.accounts, transactionsSyncResponse.accounts) && Objects.equals(this.added, transactionsSyncResponse.added) && Objects.equals(this.modified, transactionsSyncResponse.modified) && Objects.equals(this.removed, transactionsSyncResponse.removed) && Objects.equals(this.nextCursor, transactionsSyncResponse.nextCursor) && Objects.equals(this.hasMore, transactionsSyncResponse.hasMore) && Objects.equals(this.requestId, transactionsSyncResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionsUpdateStatus, this.accounts, this.added, this.modified, this.removed, this.nextCursor, this.hasMore, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionsSyncResponse {\n");
        sb.append("    transactionsUpdateStatus: ").append(this.toIndentedString((Object)this.transactionsUpdateStatus)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    added: ").append(this.toIndentedString(this.added)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    removed: ").append(this.toIndentedString(this.removed)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    hasMore: ").append(this.toIndentedString(this.hasMore)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

