/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.TransferAuthorizationGuaranteeDecision;
import com.plaid.client.model.TransferAuthorizationGuaranteeDecisionRationale;
import com.plaid.client.model.TransferCreditFundsSource;
import com.plaid.client.model.TransferExpectedSweepSettlementScheduleItem;
import com.plaid.client.model.TransferFailure;
import com.plaid.client.model.TransferNetwork;
import com.plaid.client.model.TransferRefund;
import com.plaid.client.model.TransferStatus;
import com.plaid.client.model.TransferSweepStatus;
import com.plaid.client.model.TransferType;
import com.plaid.client.model.TransferUserInResponse;
import com.plaid.client.model.TransferWireDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a transfer within the Transfers API.")
public class Transfer {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_AUTHORIZATION_ID = "authorization_id";
    @SerializedName(value="authorization_id")
    private String authorizationId;
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TransferType type;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private TransferUserInResponse user;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TransferStatus status;
    public static final String SERIALIZED_NAME_SWEEP_STATUS = "sweep_status";
    @SerializedName(value="sweep_status")
    private TransferSweepStatus sweepStatus;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private TransferNetwork network;
    public static final String SERIALIZED_NAME_WIRE_DETAILS = "wire_details";
    @SerializedName(value="wire_details")
    private TransferWireDetails wireDetails;
    public static final String SERIALIZED_NAME_CANCELLABLE = "cancellable";
    @SerializedName(value="cancellable")
    private Boolean cancellable;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failure_reason";
    @SerializedName(value="failure_reason")
    private TransferFailure failureReason;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_GUARANTEE_DECISION = "guarantee_decision";
    @SerializedName(value="guarantee_decision")
    private TransferAuthorizationGuaranteeDecision guaranteeDecision;
    public static final String SERIALIZED_NAME_GUARANTEE_DECISION_RATIONALE = "guarantee_decision_rationale";
    @SerializedName(value="guarantee_decision_rationale")
    private TransferAuthorizationGuaranteeDecisionRationale guaranteeDecisionRationale;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_STANDARD_RETURN_WINDOW = "standard_return_window";
    @SerializedName(value="standard_return_window")
    private LocalDate standardReturnWindow;
    public static final String SERIALIZED_NAME_UNAUTHORIZED_RETURN_WINDOW = "unauthorized_return_window";
    @SerializedName(value="unauthorized_return_window")
    private LocalDate unauthorizedReturnWindow;
    public static final String SERIALIZED_NAME_EXPECTED_SETTLEMENT_DATE = "expected_settlement_date";
    @SerializedName(value="expected_settlement_date")
    private LocalDate expectedSettlementDate;
    public static final String SERIALIZED_NAME_ORIGINATOR_CLIENT_ID = "originator_client_id";
    @SerializedName(value="originator_client_id")
    private String originatorClientId;
    public static final String SERIALIZED_NAME_REFUNDS = "refunds";
    @SerializedName(value="refunds")
    private List<TransferRefund> refunds = new ArrayList<TransferRefund>();
    public static final String SERIALIZED_NAME_RECURRING_TRANSFER_ID = "recurring_transfer_id";
    @SerializedName(value="recurring_transfer_id")
    private String recurringTransferId;
    public static final String SERIALIZED_NAME_EXPECTED_SWEEP_SETTLEMENT_SCHEDULE = "expected_sweep_settlement_schedule";
    @SerializedName(value="expected_sweep_settlement_schedule")
    private List<TransferExpectedSweepSettlementScheduleItem> expectedSweepSettlementSchedule = null;
    public static final String SERIALIZED_NAME_CREDIT_FUNDS_SOURCE = "credit_funds_source";
    @SerializedName(value="credit_funds_source")
    private TransferCreditFundsSource creditFundsSource;
    public static final String SERIALIZED_NAME_FACILITATOR_FEE = "facilitator_fee";
    @SerializedName(value="facilitator_fee")
    private String facilitatorFee;
    public static final String SERIALIZED_NAME_NETWORK_TRACE_ID = "network_trace_id";
    @SerializedName(value="network_trace_id")
    private String networkTraceId;

    public Transfer id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a transfer.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Transfer authorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a transfer authorization.")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public Transfer achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public Transfer accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid `account_id` corresponding to the end-user account that will be debited or credited.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Transfer fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The id of the associated funding account, available in the Plaid Dashboard. If present, this indicates which of your business checking accounts will be credited or debited.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public Transfer type(TransferType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferType getType() {
        return this.type;
    }

    public void setType(TransferType type) {
        this.type = type;
    }

    public Transfer user(TransferUserInResponse user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferUserInResponse getUser() {
        return this.user;
    }

    public void setUser(TransferUserInResponse user) {
        this.user = user;
    }

    public Transfer amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\"). When calling `/transfer/authorization/create`, specify the maximum amount to authorize. When calling `/transfer/create`, specify the exact amount of the transfer, up to a maximum of the amount authorized. If this field is left blank when calling `/transfer/create`, the maximum amount authorized in the `authorization_id` will be sent.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public Transfer description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the transfer.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Transfer created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime when this transfer was created. This will be of the form `2006-01-02T15:04:05Z`")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public Transfer status(TransferStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransferStatus status) {
        this.status = status;
    }

    public Transfer sweepStatus(TransferSweepStatus sweepStatus) {
        this.sweepStatus = sweepStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferSweepStatus getSweepStatus() {
        return this.sweepStatus;
    }

    public void setSweepStatus(TransferSweepStatus sweepStatus) {
        this.sweepStatus = sweepStatus;
    }

    public Transfer network(TransferNetwork network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(TransferNetwork network) {
        this.network = network;
    }

    public Transfer wireDetails(TransferWireDetails wireDetails) {
        this.wireDetails = wireDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferWireDetails getWireDetails() {
        return this.wireDetails;
    }

    public void setWireDetails(TransferWireDetails wireDetails) {
        this.wireDetails = wireDetails;
    }

    public Transfer cancellable(Boolean cancellable) {
        this.cancellable = cancellable;
        return this;
    }

    @ApiModelProperty(required=true, value="When `true`, you can still cancel this transfer.")
    public Boolean getCancellable() {
        return this.cancellable;
    }

    public void setCancellable(Boolean cancellable) {
        this.cancellable = cancellable;
    }

    public Transfer failureReason(TransferFailure failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferFailure getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(TransferFailure failureReason) {
        this.failureReason = failureReason;
    }

    public Transfer metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Transfer putMetadataItem(String key, String metadataItem) {
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: The JSON values must be Strings (no nested JSON objects allowed) Only ASCII characters may be used Maximum of 50 key/value pairs Maximum key length of 40 characters Maximum value length of 500 characters ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Transfer originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for the origination account that was used for this transfer.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public Transfer guaranteeDecision(TransferAuthorizationGuaranteeDecision guaranteeDecision) {
        this.guaranteeDecision = guaranteeDecision;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationGuaranteeDecision getGuaranteeDecision() {
        return this.guaranteeDecision;
    }

    public void setGuaranteeDecision(TransferAuthorizationGuaranteeDecision guaranteeDecision) {
        this.guaranteeDecision = guaranteeDecision;
    }

    public Transfer guaranteeDecisionRationale(TransferAuthorizationGuaranteeDecisionRationale guaranteeDecisionRationale) {
        this.guaranteeDecisionRationale = guaranteeDecisionRationale;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationGuaranteeDecisionRationale getGuaranteeDecisionRationale() {
        return this.guaranteeDecisionRationale;
    }

    public void setGuaranteeDecisionRationale(TransferAuthorizationGuaranteeDecisionRationale guaranteeDecisionRationale) {
        this.guaranteeDecisionRationale = guaranteeDecisionRationale;
    }

    public Transfer isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the transfer amount, e.g. \"USD\"")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public Transfer standardReturnWindow(LocalDate standardReturnWindow) {
        this.standardReturnWindow = standardReturnWindow;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date 3 business days from settlement date indicating the following ACH returns can no longer happen: R01, R02, R03, R29. This will be of the form YYYY-MM-DD.")
    public LocalDate getStandardReturnWindow() {
        return this.standardReturnWindow;
    }

    public void setStandardReturnWindow(LocalDate standardReturnWindow) {
        this.standardReturnWindow = standardReturnWindow;
    }

    public Transfer unauthorizedReturnWindow(LocalDate unauthorizedReturnWindow) {
        this.unauthorizedReturnWindow = unauthorizedReturnWindow;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date 61 business days from settlement date indicating the following ACH returns can no longer happen: R05, R07, R10, R11, R51, R33, R37, R38, R51, R52, R53. This will be of the form YYYY-MM-DD.")
    public LocalDate getUnauthorizedReturnWindow() {
        return this.unauthorizedReturnWindow;
    }

    public void setUnauthorizedReturnWindow(LocalDate unauthorizedReturnWindow) {
        this.unauthorizedReturnWindow = unauthorizedReturnWindow;
    }

    public Transfer expectedSettlementDate(LocalDate expectedSettlementDate) {
        this.expectedSettlementDate = expectedSettlementDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The expected date when the full amount of the transfer settles at the consumers\u2019 account, if the transfer is credit; or at the customer's business checking account, if the transfer is debit. Only set for ACH transfers and is null for non-ACH transfers. Only set for ACH transfers. This will be of the form YYYY-MM-DD.")
    public LocalDate getExpectedSettlementDate() {
        return this.expectedSettlementDate;
    }

    public void setExpectedSettlementDate(LocalDate expectedSettlementDate) {
        this.expectedSettlementDate = expectedSettlementDate;
    }

    public Transfer originatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The Plaid client ID that is the originator of this transfer. Only present if created on behalf of another client as a [Platform customer](https://plaid.com/docs/transfer/application/#originators-vs-platforms).")
    public String getOriginatorClientId() {
        return this.originatorClientId;
    }

    public void setOriginatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
    }

    public Transfer refunds(List<TransferRefund> refunds) {
        this.refunds = refunds;
        return this;
    }

    public Transfer addRefundsItem(TransferRefund refundsItem) {
        this.refunds.add(refundsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of refunds associated with this transfer.")
    public List<TransferRefund> getRefunds() {
        return this.refunds;
    }

    public void setRefunds(List<TransferRefund> refunds) {
        this.refunds = refunds;
    }

    public Transfer recurringTransferId(String recurringTransferId) {
        this.recurringTransferId = recurringTransferId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The id of the recurring transfer if this transfer belongs to a recurring transfer.")
    public String getRecurringTransferId() {
        return this.recurringTransferId;
    }

    public void setRecurringTransferId(String recurringTransferId) {
        this.recurringTransferId = recurringTransferId;
    }

    public Transfer expectedSweepSettlementSchedule(List<TransferExpectedSweepSettlementScheduleItem> expectedSweepSettlementSchedule) {
        this.expectedSweepSettlementSchedule = expectedSweepSettlementSchedule;
        return this;
    }

    public Transfer addExpectedSweepSettlementScheduleItem(TransferExpectedSweepSettlementScheduleItem expectedSweepSettlementScheduleItem) {
        if (this.expectedSweepSettlementSchedule == null) {
            this.expectedSweepSettlementSchedule = new ArrayList<TransferExpectedSweepSettlementScheduleItem>();
        }
        this.expectedSweepSettlementSchedule.add(expectedSweepSettlementScheduleItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The expected sweep settlement schedule of this transfer, assuming this transfer is not `returned`. Only applies to ACH debit transfers.")
    public List<TransferExpectedSweepSettlementScheduleItem> getExpectedSweepSettlementSchedule() {
        return this.expectedSweepSettlementSchedule;
    }

    public void setExpectedSweepSettlementSchedule(List<TransferExpectedSweepSettlementScheduleItem> expectedSweepSettlementSchedule) {
        this.expectedSweepSettlementSchedule = expectedSweepSettlementSchedule;
    }

    public Transfer creditFundsSource(TransferCreditFundsSource creditFundsSource) {
        this.creditFundsSource = creditFundsSource;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferCreditFundsSource getCreditFundsSource() {
        return this.creditFundsSource;
    }

    public void setCreditFundsSource(TransferCreditFundsSource creditFundsSource) {
        this.creditFundsSource = creditFundsSource;
    }

    public Transfer facilitatorFee(String facilitatorFee) {
        this.facilitatorFee = facilitatorFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to deduct from `transfer.amount` and distribute to the platform\u2019s Ledger balance as a facilitator fee (decimal string with two digits of precision e.g. \"10.00\"). The remainder will go to the end-customer\u2019s Ledger balance. This must be less than or equal to the `transfer.amount`.")
    public String getFacilitatorFee() {
        return this.facilitatorFee;
    }

    public void setFacilitatorFee(String facilitatorFee) {
        this.facilitatorFee = facilitatorFee;
    }

    public Transfer networkTraceId(String networkTraceId) {
        this.networkTraceId = networkTraceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The trace identifier for the transfer based on its network. This will only be set after the transfer has posted.  For `ach` or `same-day-ach` transfers, this is the ACH trace number. For `rtp` transfers, this is the Transaction Identification number. For `wire` transfers, this is the IMAD (Input Message Accountability Data) number.")
    public String getNetworkTraceId() {
        return this.networkTraceId;
    }

    public void setNetworkTraceId(String networkTraceId) {
        this.networkTraceId = networkTraceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transfer transfer = (Transfer)o;
        return Objects.equals(this.id, transfer.id) && Objects.equals(this.authorizationId, transfer.authorizationId) && Objects.equals((Object)this.achClass, (Object)transfer.achClass) && Objects.equals(this.accountId, transfer.accountId) && Objects.equals(this.fundingAccountId, transfer.fundingAccountId) && Objects.equals((Object)this.type, (Object)transfer.type) && Objects.equals(this.user, transfer.user) && Objects.equals(this.amount, transfer.amount) && Objects.equals(this.description, transfer.description) && Objects.equals(this.created, transfer.created) && Objects.equals((Object)this.status, (Object)transfer.status) && Objects.equals((Object)this.sweepStatus, (Object)transfer.sweepStatus) && Objects.equals((Object)this.network, (Object)transfer.network) && Objects.equals(this.wireDetails, transfer.wireDetails) && Objects.equals(this.cancellable, transfer.cancellable) && Objects.equals(this.failureReason, transfer.failureReason) && Objects.equals(this.metadata, transfer.metadata) && Objects.equals(this.originationAccountId, transfer.originationAccountId) && Objects.equals((Object)this.guaranteeDecision, (Object)transfer.guaranteeDecision) && Objects.equals(this.guaranteeDecisionRationale, transfer.guaranteeDecisionRationale) && Objects.equals(this.isoCurrencyCode, transfer.isoCurrencyCode) && Objects.equals(this.standardReturnWindow, transfer.standardReturnWindow) && Objects.equals(this.unauthorizedReturnWindow, transfer.unauthorizedReturnWindow) && Objects.equals(this.expectedSettlementDate, transfer.expectedSettlementDate) && Objects.equals(this.originatorClientId, transfer.originatorClientId) && Objects.equals(this.refunds, transfer.refunds) && Objects.equals(this.recurringTransferId, transfer.recurringTransferId) && Objects.equals(this.expectedSweepSettlementSchedule, transfer.expectedSweepSettlementSchedule) && Objects.equals((Object)this.creditFundsSource, (Object)transfer.creditFundsSource) && Objects.equals(this.facilitatorFee, transfer.facilitatorFee) && Objects.equals(this.networkTraceId, transfer.networkTraceId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.authorizationId, this.achClass, this.accountId, this.fundingAccountId, this.type, this.user, this.amount, this.description, this.created, this.status, this.sweepStatus, this.network, this.wireDetails, this.cancellable, this.failureReason, this.metadata, this.originationAccountId, this.guaranteeDecision, this.guaranteeDecisionRationale, this.isoCurrencyCode, this.standardReturnWindow, this.unauthorizedReturnWindow, this.expectedSettlementDate, this.originatorClientId, this.refunds, this.recurringTransferId, this.expectedSweepSettlementSchedule, this.creditFundsSource, this.facilitatorFee, this.networkTraceId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transfer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    authorizationId: ").append(this.toIndentedString(this.authorizationId)).append("\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    sweepStatus: ").append(this.toIndentedString((Object)this.sweepStatus)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    wireDetails: ").append(this.toIndentedString(this.wireDetails)).append("\n");
        sb.append("    cancellable: ").append(this.toIndentedString(this.cancellable)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    guaranteeDecision: ").append(this.toIndentedString((Object)this.guaranteeDecision)).append("\n");
        sb.append("    guaranteeDecisionRationale: ").append(this.toIndentedString(this.guaranteeDecisionRationale)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    standardReturnWindow: ").append(this.toIndentedString(this.standardReturnWindow)).append("\n");
        sb.append("    unauthorizedReturnWindow: ").append(this.toIndentedString(this.unauthorizedReturnWindow)).append("\n");
        sb.append("    expectedSettlementDate: ").append(this.toIndentedString(this.expectedSettlementDate)).append("\n");
        sb.append("    originatorClientId: ").append(this.toIndentedString(this.originatorClientId)).append("\n");
        sb.append("    refunds: ").append(this.toIndentedString(this.refunds)).append("\n");
        sb.append("    recurringTransferId: ").append(this.toIndentedString(this.recurringTransferId)).append("\n");
        sb.append("    expectedSweepSettlementSchedule: ").append(this.toIndentedString(this.expectedSweepSettlementSchedule)).append("\n");
        sb.append("    creditFundsSource: ").append(this.toIndentedString((Object)this.creditFundsSource)).append("\n");
        sb.append("    facilitatorFee: ").append(this.toIndentedString(this.facilitatorFee)).append("\n");
        sb.append("    networkTraceId: ").append(this.toIndentedString(this.networkTraceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

