/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferAuthorizationDecision;
import com.plaid.client.model.TransferAuthorizationDecisionRationale;
import com.plaid.client.model.TransferAuthorizationGuaranteeDecision;
import com.plaid.client.model.TransferAuthorizationGuaranteeDecisionRationale;
import com.plaid.client.model.TransferAuthorizationPaymentRisk;
import com.plaid.client.model.TransferAuthorizationProposedTransfer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains the authorization decision for a proposed transfer.")
public class TransferAuthorization {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_DECISION = "decision";
    @SerializedName(value="decision")
    private TransferAuthorizationDecision decision;
    public static final String SERIALIZED_NAME_DECISION_RATIONALE = "decision_rationale";
    @SerializedName(value="decision_rationale")
    private TransferAuthorizationDecisionRationale decisionRationale;
    public static final String SERIALIZED_NAME_GUARANTEE_DECISION = "guarantee_decision";
    @SerializedName(value="guarantee_decision")
    private TransferAuthorizationGuaranteeDecision guaranteeDecision;
    public static final String SERIALIZED_NAME_GUARANTEE_DECISION_RATIONALE = "guarantee_decision_rationale";
    @SerializedName(value="guarantee_decision_rationale")
    private TransferAuthorizationGuaranteeDecisionRationale guaranteeDecisionRationale;
    public static final String SERIALIZED_NAME_PAYMENT_RISK = "payment_risk";
    @SerializedName(value="payment_risk")
    private TransferAuthorizationPaymentRisk paymentRisk;
    public static final String SERIALIZED_NAME_PROPOSED_TRANSFER = "proposed_transfer";
    @SerializedName(value="proposed_transfer")
    private TransferAuthorizationProposedTransfer proposedTransfer;

    public TransferAuthorization id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a transfer authorization.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransferAuthorization created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime representing when the authorization was created, in the format `2006-01-02T15:04:05Z`.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public TransferAuthorization decision(TransferAuthorizationDecision decision) {
        this.decision = decision;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationDecision getDecision() {
        return this.decision;
    }

    public void setDecision(TransferAuthorizationDecision decision) {
        this.decision = decision;
    }

    public TransferAuthorization decisionRationale(TransferAuthorizationDecisionRationale decisionRationale) {
        this.decisionRationale = decisionRationale;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationDecisionRationale getDecisionRationale() {
        return this.decisionRationale;
    }

    public void setDecisionRationale(TransferAuthorizationDecisionRationale decisionRationale) {
        this.decisionRationale = decisionRationale;
    }

    public TransferAuthorization guaranteeDecision(TransferAuthorizationGuaranteeDecision guaranteeDecision) {
        this.guaranteeDecision = guaranteeDecision;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationGuaranteeDecision getGuaranteeDecision() {
        return this.guaranteeDecision;
    }

    public void setGuaranteeDecision(TransferAuthorizationGuaranteeDecision guaranteeDecision) {
        this.guaranteeDecision = guaranteeDecision;
    }

    public TransferAuthorization guaranteeDecisionRationale(TransferAuthorizationGuaranteeDecisionRationale guaranteeDecisionRationale) {
        this.guaranteeDecisionRationale = guaranteeDecisionRationale;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationGuaranteeDecisionRationale getGuaranteeDecisionRationale() {
        return this.guaranteeDecisionRationale;
    }

    public void setGuaranteeDecisionRationale(TransferAuthorizationGuaranteeDecisionRationale guaranteeDecisionRationale) {
        this.guaranteeDecisionRationale = guaranteeDecisionRationale;
    }

    public TransferAuthorization paymentRisk(TransferAuthorizationPaymentRisk paymentRisk) {
        this.paymentRisk = paymentRisk;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationPaymentRisk getPaymentRisk() {
        return this.paymentRisk;
    }

    public void setPaymentRisk(TransferAuthorizationPaymentRisk paymentRisk) {
        this.paymentRisk = paymentRisk;
    }

    public TransferAuthorization proposedTransfer(TransferAuthorizationProposedTransfer proposedTransfer) {
        this.proposedTransfer = proposedTransfer;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationProposedTransfer getProposedTransfer() {
        return this.proposedTransfer;
    }

    public void setProposedTransfer(TransferAuthorizationProposedTransfer proposedTransfer) {
        this.proposedTransfer = proposedTransfer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferAuthorization transferAuthorization = (TransferAuthorization)o;
        return Objects.equals(this.id, transferAuthorization.id) && Objects.equals(this.created, transferAuthorization.created) && Objects.equals((Object)this.decision, (Object)transferAuthorization.decision) && Objects.equals(this.decisionRationale, transferAuthorization.decisionRationale) && Objects.equals((Object)this.guaranteeDecision, (Object)transferAuthorization.guaranteeDecision) && Objects.equals(this.guaranteeDecisionRationale, transferAuthorization.guaranteeDecisionRationale) && Objects.equals(this.paymentRisk, transferAuthorization.paymentRisk) && Objects.equals(this.proposedTransfer, transferAuthorization.proposedTransfer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.created, this.decision, this.decisionRationale, this.guaranteeDecision, this.guaranteeDecisionRationale, this.paymentRisk, this.proposedTransfer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferAuthorization {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    decision: ").append(this.toIndentedString((Object)this.decision)).append("\n");
        sb.append("    decisionRationale: ").append(this.toIndentedString(this.decisionRationale)).append("\n");
        sb.append("    guaranteeDecision: ").append(this.toIndentedString((Object)this.guaranteeDecision)).append("\n");
        sb.append("    guaranteeDecisionRationale: ").append(this.toIndentedString(this.guaranteeDecisionRationale)).append("\n");
        sb.append("    paymentRisk: ").append(this.toIndentedString(this.paymentRisk)).append("\n");
        sb.append("    proposedTransfer: ").append(this.toIndentedString(this.proposedTransfer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

