/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/authorization/cancel`")
public class TransferAuthorizationCancelRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_AUTHORIZATION_ID = "authorization_id";
    @SerializedName(value="authorization_id")
    private String authorizationId;

    public TransferAuthorizationCancelRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferAuthorizationCancelRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferAuthorizationCancelRequest authorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a transfer authorization.")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferAuthorizationCancelRequest transferAuthorizationCancelRequest = (TransferAuthorizationCancelRequest)o;
        return Objects.equals(this.clientId, transferAuthorizationCancelRequest.clientId) && Objects.equals(this.secret, transferAuthorizationCancelRequest.secret) && Objects.equals(this.authorizationId, transferAuthorizationCancelRequest.authorizationId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.authorizationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferAuthorizationCancelRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    authorizationId: ").append(this.toIndentedString(this.authorizationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

