/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.TransferAuthorizationDevice;
import com.plaid.client.model.TransferAuthorizationUserInRequest;
import com.plaid.client.model.TransferCreditFundsSource;
import com.plaid.client.model.TransferNetwork;
import com.plaid.client.model.TransferType;
import com.plaid.client.model.TransferWireDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/authorization/create`")
public class TransferAuthorizationCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_PAYMENT_PROFILE_TOKEN = "payment_profile_token";
    @SerializedName(value="payment_profile_token")
    private String paymentProfileToken;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TransferType type;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private TransferNetwork network;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_WIRE_DETAILS = "wire_details";
    @SerializedName(value="wire_details")
    private TransferWireDetails wireDetails;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private TransferAuthorizationUserInRequest user;
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    private TransferAuthorizationDevice device;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_IDEMPOTENCY_KEY = "idempotency_key";
    @SerializedName(value="idempotency_key")
    private String idempotencyKey;
    public static final String SERIALIZED_NAME_USER_PRESENT = "user_present";
    @SerializedName(value="user_present")
    private Boolean userPresent;
    public static final String SERIALIZED_NAME_WITH_GUARANTEE = "with_guarantee";
    @SerializedName(value="with_guarantee")
    private Boolean withGuarantee = true;
    public static final String SERIALIZED_NAME_BEACON_SESSION_ID = "beacon_session_id";
    @SerializedName(value="beacon_session_id")
    private String beaconSessionId;
    public static final String SERIALIZED_NAME_ORIGINATOR_CLIENT_ID = "originator_client_id";
    @SerializedName(value="originator_client_id")
    private String originatorClientId;
    public static final String SERIALIZED_NAME_CREDIT_FUNDS_SOURCE = "credit_funds_source";
    @SerializedName(value="credit_funds_source")
    private TransferCreditFundsSource creditFundsSource;
    public static final String SERIALIZED_NAME_TEST_CLOCK_ID = "test_clock_id";
    @SerializedName(value="test_clock_id")
    private String testClockId;

    public TransferAuthorizationCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferAuthorizationCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferAuthorizationCreateRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `access_token` for the account that will be debited or credited.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TransferAuthorizationCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `account_id` corresponding to the end-user account that will be debited or credited.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransferAuthorizationCreateRequest fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify the account used to fund the transfer. Should be specified if using legacy funding methods only. If using Plaid Ledger, leave this field blank. Customers can find a list of `funding_account_id`s in the Accounts page of your Plaid Dashboard, under the \"Account ID\" column. If this field is left blank and you are using legacy funding methods, this will default to the default `funding_account_id` specified during onboarding. Otherwise, Plaid Ledger will be used.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public TransferAuthorizationCreateRequest paymentProfileToken(String paymentProfileToken) {
        this.paymentProfileToken = paymentProfileToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment profile token associated with the Payment Profile that will be debited or credited. Required if not using `access_token`.")
    public String getPaymentProfileToken() {
        return this.paymentProfileToken;
    }

    public void setPaymentProfileToken(String paymentProfileToken) {
        this.paymentProfileToken = paymentProfileToken;
    }

    public TransferAuthorizationCreateRequest type(TransferType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferType getType() {
        return this.type;
    }

    public void setType(TransferType type) {
        this.type = type;
    }

    public TransferAuthorizationCreateRequest network(TransferNetwork network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(TransferNetwork network) {
        this.network = network;
    }

    public TransferAuthorizationCreateRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\"). When calling `/transfer/authorization/create`, specify the maximum amount to authorize. When calling `/transfer/create`, specify the exact amount of the transfer, up to a maximum of the amount authorized. If this field is left blank when calling `/transfer/create`, the maximum amount authorized in the `authorization_id` will be sent.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferAuthorizationCreateRequest achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public TransferAuthorizationCreateRequest wireDetails(TransferWireDetails wireDetails) {
        this.wireDetails = wireDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferWireDetails getWireDetails() {
        return this.wireDetails;
    }

    public void setWireDetails(TransferWireDetails wireDetails) {
        this.wireDetails = wireDetails;
    }

    public TransferAuthorizationCreateRequest user(TransferAuthorizationUserInRequest user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationUserInRequest getUser() {
        return this.user;
    }

    public void setUser(TransferAuthorizationUserInRequest user) {
        this.user = user;
    }

    public TransferAuthorizationCreateRequest device(TransferAuthorizationDevice device) {
        this.device = device;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferAuthorizationDevice getDevice() {
        return this.device;
    }

    public void setDevice(TransferAuthorizationDevice device) {
        this.device = device;
    }

    public TransferAuthorizationCreateRequest originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid's unique identifier for the origination account for this authorization. If not specified, the default account will be used.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public TransferAuthorizationCreateRequest isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The currency of the transfer amount. The default value is \"USD\".")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public TransferAuthorizationCreateRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A random key provided by the client, per unique authorization, which expires after 48 hours. Maximum of 50 characters.  The API supports idempotency for safely retrying requests without accidentally performing the same operation twice. For example, if a request to create an authorization fails due to a network connection error, you can retry the request with the same idempotency key to guarantee that only a single authorization is created.  This idempotency key expires after 48 hours, after which the same key can be reused. Failure to provide this key may result in duplicate charges.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public TransferAuthorizationCreateRequest userPresent(Boolean userPresent) {
        this.userPresent = userPresent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the end user is initiating the specific transfer themselves via an interactive UI, this should be `true`; for automatic recurring payments where the end user is not actually initiating each individual transfer, it should be `false`. This field is not currently used and is present to support planned future functionality.")
    public Boolean getUserPresent() {
        return this.userPresent;
    }

    public void setUserPresent(Boolean userPresent) {
        this.userPresent = userPresent;
    }

    public TransferAuthorizationCreateRequest withGuarantee(Boolean withGuarantee) {
        this.withGuarantee = withGuarantee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `false`, Plaid will not offer a `guarantee_decision` for this request (Guarantee customers only).")
    public Boolean getWithGuarantee() {
        return this.withGuarantee;
    }

    public void setWithGuarantee(Boolean withGuarantee) {
        this.withGuarantee = withGuarantee;
    }

    public TransferAuthorizationCreateRequest beaconSessionId(String beaconSessionId) {
        this.beaconSessionId = beaconSessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier returned by Plaid's [beacon](https://plaid.com/docs/transfer/guarantee/#using-a-beacon) when it is run on your webpage.")
    public String getBeaconSessionId() {
        return this.beaconSessionId;
    }

    public void setBeaconSessionId(String beaconSessionId) {
        this.beaconSessionId = beaconSessionId;
    }

    public TransferAuthorizationCreateRequest originatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid client ID that is the originator of this transfer. Only needed if creating transfers on behalf of another client as a [Platform customer](https://plaid.com/docs/transfer/application/#originators-vs-platforms).")
    public String getOriginatorClientId() {
        return this.originatorClientId;
    }

    public void setOriginatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
    }

    public TransferAuthorizationCreateRequest creditFundsSource(TransferCreditFundsSource creditFundsSource) {
        this.creditFundsSource = creditFundsSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferCreditFundsSource getCreditFundsSource() {
        return this.creditFundsSource;
    }

    public void setCreditFundsSource(TransferCreditFundsSource creditFundsSource) {
        this.creditFundsSource = creditFundsSource;
    }

    public TransferAuthorizationCreateRequest testClockId(String testClockId) {
        this.testClockId = testClockId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for a test clock. This field may only be used when using `sandbox` environment. If provided, the `authorization` is created at the `virtual_time` on the provided test clock.")
    public String getTestClockId() {
        return this.testClockId;
    }

    public void setTestClockId(String testClockId) {
        this.testClockId = testClockId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferAuthorizationCreateRequest transferAuthorizationCreateRequest = (TransferAuthorizationCreateRequest)o;
        return Objects.equals(this.clientId, transferAuthorizationCreateRequest.clientId) && Objects.equals(this.secret, transferAuthorizationCreateRequest.secret) && Objects.equals(this.accessToken, transferAuthorizationCreateRequest.accessToken) && Objects.equals(this.accountId, transferAuthorizationCreateRequest.accountId) && Objects.equals(this.fundingAccountId, transferAuthorizationCreateRequest.fundingAccountId) && Objects.equals(this.paymentProfileToken, transferAuthorizationCreateRequest.paymentProfileToken) && Objects.equals((Object)this.type, (Object)transferAuthorizationCreateRequest.type) && Objects.equals((Object)this.network, (Object)transferAuthorizationCreateRequest.network) && Objects.equals(this.amount, transferAuthorizationCreateRequest.amount) && Objects.equals((Object)this.achClass, (Object)transferAuthorizationCreateRequest.achClass) && Objects.equals(this.wireDetails, transferAuthorizationCreateRequest.wireDetails) && Objects.equals(this.user, transferAuthorizationCreateRequest.user) && Objects.equals(this.device, transferAuthorizationCreateRequest.device) && Objects.equals(this.originationAccountId, transferAuthorizationCreateRequest.originationAccountId) && Objects.equals(this.isoCurrencyCode, transferAuthorizationCreateRequest.isoCurrencyCode) && Objects.equals(this.idempotencyKey, transferAuthorizationCreateRequest.idempotencyKey) && Objects.equals(this.userPresent, transferAuthorizationCreateRequest.userPresent) && Objects.equals(this.withGuarantee, transferAuthorizationCreateRequest.withGuarantee) && Objects.equals(this.beaconSessionId, transferAuthorizationCreateRequest.beaconSessionId) && Objects.equals(this.originatorClientId, transferAuthorizationCreateRequest.originatorClientId) && Objects.equals((Object)this.creditFundsSource, (Object)transferAuthorizationCreateRequest.creditFundsSource) && Objects.equals(this.testClockId, transferAuthorizationCreateRequest.testClockId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.accessToken, this.accountId, this.fundingAccountId, this.paymentProfileToken, this.type, this.network, this.amount, this.achClass, this.wireDetails, this.user, this.device, this.originationAccountId, this.isoCurrencyCode, this.idempotencyKey, this.userPresent, this.withGuarantee, this.beaconSessionId, this.originatorClientId, this.creditFundsSource, this.testClockId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferAuthorizationCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    paymentProfileToken: ").append(this.toIndentedString(this.paymentProfileToken)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    wireDetails: ").append(this.toIndentedString(this.wireDetails)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    userPresent: ").append(this.toIndentedString(this.userPresent)).append("\n");
        sb.append("    withGuarantee: ").append(this.toIndentedString(this.withGuarantee)).append("\n");
        sb.append("    beaconSessionId: ").append(this.toIndentedString(this.beaconSessionId)).append("\n");
        sb.append("    originatorClientId: ").append(this.toIndentedString(this.originatorClientId)).append("\n");
        sb.append("    creditFundsSource: ").append(this.toIndentedString((Object)this.creditFundsSource)).append("\n");
        sb.append("    testClockId: ").append(this.toIndentedString(this.testClockId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

