/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.SignalWarning;
import com.plaid.client.model.TransferAuthorizationRiskLevel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="This object includes the scores and risk level. This response is offered as an add-on to /transfer/authorization/create. To request access to these fields please contact your Plaid account manager.")
public class TransferAuthorizationPaymentRisk {
    public static final String SERIALIZED_NAME_BANK_INITIATED_RETURN_SCORE = "bank_initiated_return_score";
    @SerializedName(value="bank_initiated_return_score")
    private Integer bankInitiatedReturnScore;
    public static final String SERIALIZED_NAME_CUSTOMER_INITIATED_RETURN_SCORE = "customer_initiated_return_score";
    @SerializedName(value="customer_initiated_return_score")
    private Integer customerInitiatedReturnScore;
    public static final String SERIALIZED_NAME_RISK_LEVEL = "risk_level";
    @SerializedName(value="risk_level")
    private TransferAuthorizationRiskLevel riskLevel;
    public static final String SERIALIZED_NAME_WARNINGS = "warnings";
    @SerializedName(value="warnings")
    private List<SignalWarning> warnings = new ArrayList<SignalWarning>();

    public TransferAuthorizationPaymentRisk bankInitiatedReturnScore(Integer bankInitiatedReturnScore) {
        this.bankInitiatedReturnScore = bankInitiatedReturnScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A score from 1-99 that indicates the transaction return risk: a higher risk score suggests a higher return likelihood.  The score evaluates the transaction return risk because an account is overdrawn or because an ineligible account is used and covers return codes: \"R01\", \"R02\", \"R03\", \"R04\", \"R06\", \"R08\",  \"R09\", \"R13\", \"R16\", \"R17\", \"R20\", \"R23\". These returns have a turnaround time of 2 banking days.")
    public Integer getBankInitiatedReturnScore() {
        return this.bankInitiatedReturnScore;
    }

    public void setBankInitiatedReturnScore(Integer bankInitiatedReturnScore) {
        this.bankInitiatedReturnScore = bankInitiatedReturnScore;
    }

    public TransferAuthorizationPaymentRisk customerInitiatedReturnScore(Integer customerInitiatedReturnScore) {
        this.customerInitiatedReturnScore = customerInitiatedReturnScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A score from 1-99 that indicates the transaction return risk: a higher risk score suggests a higher return likelihood.  The score evaluates the transaction return risk of an unauthorized debit and covers return codes: \"R05\", \"R07\", \"R10\", \"R11\", \"R29\". These returns typically have a return time frame of up to 60 calendar days. During this period, the customer of financial institutions can dispute a transaction as unauthorized.")
    public Integer getCustomerInitiatedReturnScore() {
        return this.customerInitiatedReturnScore;
    }

    public void setCustomerInitiatedReturnScore(Integer customerInitiatedReturnScore) {
        this.customerInitiatedReturnScore = customerInitiatedReturnScore;
    }

    public TransferAuthorizationPaymentRisk riskLevel(TransferAuthorizationRiskLevel riskLevel) {
        this.riskLevel = riskLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationRiskLevel getRiskLevel() {
        return this.riskLevel;
    }

    public void setRiskLevel(TransferAuthorizationRiskLevel riskLevel) {
        this.riskLevel = riskLevel;
    }

    public TransferAuthorizationPaymentRisk warnings(List<SignalWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public TransferAuthorizationPaymentRisk addWarningsItem(SignalWarning warningsItem) {
        this.warnings.add(warningsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="If bank information was not available to be used in the Signal model, this array contains warnings describing why bank data is missing. If you want to receive an API error instead of Signal scores in the case of missing bank data, file a support ticket or contact your Plaid account manager.")
    public List<SignalWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<SignalWarning> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferAuthorizationPaymentRisk transferAuthorizationPaymentRisk = (TransferAuthorizationPaymentRisk)o;
        return Objects.equals(this.bankInitiatedReturnScore, transferAuthorizationPaymentRisk.bankInitiatedReturnScore) && Objects.equals(this.customerInitiatedReturnScore, transferAuthorizationPaymentRisk.customerInitiatedReturnScore) && Objects.equals((Object)this.riskLevel, (Object)transferAuthorizationPaymentRisk.riskLevel) && Objects.equals(this.warnings, transferAuthorizationPaymentRisk.warnings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bankInitiatedReturnScore, this.customerInitiatedReturnScore, this.riskLevel, this.warnings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferAuthorizationPaymentRisk {\n");
        sb.append("    bankInitiatedReturnScore: ").append(this.toIndentedString(this.bankInitiatedReturnScore)).append("\n");
        sb.append("    customerInitiatedReturnScore: ").append(this.toIndentedString(this.customerInitiatedReturnScore)).append("\n");
        sb.append("    riskLevel: ").append(this.toIndentedString((Object)this.riskLevel)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

