/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.TransferCreditFundsSource;
import com.plaid.client.model.TransferType;
import com.plaid.client.model.TransferUserInResponse;
import com.plaid.client.model.TransferWireDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details regarding the proposed transfer.")
public class TransferAuthorizationProposedTransfer {
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TransferType type;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private TransferUserInResponse user;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_WIRE_DETAILS = "wire_details";
    @SerializedName(value="wire_details")
    private TransferWireDetails wireDetails;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_ORIGINATOR_CLIENT_ID = "originator_client_id";
    @SerializedName(value="originator_client_id")
    private String originatorClientId;
    public static final String SERIALIZED_NAME_CREDIT_FUNDS_SOURCE = "credit_funds_source";
    @SerializedName(value="credit_funds_source")
    private TransferCreditFundsSource creditFundsSource;

    public TransferAuthorizationProposedTransfer achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public TransferAuthorizationProposedTransfer accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid `account_id` for the account that will be debited or credited.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransferAuthorizationProposedTransfer fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The id of the associated funding account, available in the Plaid Dashboard. If present, this indicates which of your business checking accounts will be credited or debited.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public TransferAuthorizationProposedTransfer type(TransferType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferType getType() {
        return this.type;
    }

    public void setType(TransferType type) {
        this.type = type;
    }

    public TransferAuthorizationProposedTransfer user(TransferUserInResponse user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferUserInResponse getUser() {
        return this.user;
    }

    public void setUser(TransferUserInResponse user) {
        this.user = user;
    }

    public TransferAuthorizationProposedTransfer amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\"). When calling `/transfer/authorization/create`, specify the maximum amount to authorize. When calling `/transfer/create`, specify the exact amount of the transfer, up to a maximum of the amount authorized. If this field is left blank when calling `/transfer/create`, the maximum amount authorized in the `authorization_id` will be sent.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferAuthorizationProposedTransfer network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="The network or rails used for the transfer.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public TransferAuthorizationProposedTransfer wireDetails(TransferWireDetails wireDetails) {
        this.wireDetails = wireDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferWireDetails getWireDetails() {
        return this.wireDetails;
    }

    public void setWireDetails(TransferWireDetails wireDetails) {
        this.wireDetails = wireDetails;
    }

    public TransferAuthorizationProposedTransfer originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid's unique identifier for the origination account that was used for this transfer.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public TransferAuthorizationProposedTransfer isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the transfer amount. The default value is \"USD\".")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public TransferAuthorizationProposedTransfer originatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The Plaid client ID that is the originator of this transfer. Only present if created on behalf of another client as a [Platform customer](https://plaid.com/docs/transfer/application/#originators-vs-platforms).")
    public String getOriginatorClientId() {
        return this.originatorClientId;
    }

    public void setOriginatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
    }

    public TransferAuthorizationProposedTransfer creditFundsSource(TransferCreditFundsSource creditFundsSource) {
        this.creditFundsSource = creditFundsSource;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferCreditFundsSource getCreditFundsSource() {
        return this.creditFundsSource;
    }

    public void setCreditFundsSource(TransferCreditFundsSource creditFundsSource) {
        this.creditFundsSource = creditFundsSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferAuthorizationProposedTransfer transferAuthorizationProposedTransfer = (TransferAuthorizationProposedTransfer)o;
        return Objects.equals((Object)this.achClass, (Object)transferAuthorizationProposedTransfer.achClass) && Objects.equals(this.accountId, transferAuthorizationProposedTransfer.accountId) && Objects.equals(this.fundingAccountId, transferAuthorizationProposedTransfer.fundingAccountId) && Objects.equals((Object)this.type, (Object)transferAuthorizationProposedTransfer.type) && Objects.equals(this.user, transferAuthorizationProposedTransfer.user) && Objects.equals(this.amount, transferAuthorizationProposedTransfer.amount) && Objects.equals(this.network, transferAuthorizationProposedTransfer.network) && Objects.equals(this.wireDetails, transferAuthorizationProposedTransfer.wireDetails) && Objects.equals(this.originationAccountId, transferAuthorizationProposedTransfer.originationAccountId) && Objects.equals(this.isoCurrencyCode, transferAuthorizationProposedTransfer.isoCurrencyCode) && Objects.equals(this.originatorClientId, transferAuthorizationProposedTransfer.originatorClientId) && Objects.equals((Object)this.creditFundsSource, (Object)transferAuthorizationProposedTransfer.creditFundsSource);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.achClass, this.accountId, this.fundingAccountId, this.type, this.user, this.amount, this.network, this.wireDetails, this.originationAccountId, this.isoCurrencyCode, this.originatorClientId, this.creditFundsSource});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferAuthorizationProposedTransfer {\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    wireDetails: ").append(this.toIndentedString(this.wireDetails)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    originatorClientId: ").append(this.toIndentedString(this.originatorClientId)).append("\n");
        sb.append("    creditFundsSource: ").append(this.toIndentedString((Object)this.creditFundsSource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

