/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferUserAddressInRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The legal name and other information for the account holder. The `user.legal_name` field is required. Other fields are not currently used and are present to support planned future functionality.")
public class TransferAuthorizationUserInRequest {
    public static final String SERIALIZED_NAME_LEGAL_NAME = "legal_name";
    @SerializedName(value="legal_name")
    private String legalName;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private String emailAddress;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private TransferUserAddressInRequest address;

    public TransferAuthorizationUserInRequest legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @ApiModelProperty(required=true, value="The user's legal name. If the user is a business, provide the business name.")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public TransferAuthorizationUserInRequest phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's phone number.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public TransferAuthorizationUserInRequest emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public TransferAuthorizationUserInRequest address(TransferUserAddressInRequest address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferUserAddressInRequest getAddress() {
        return this.address;
    }

    public void setAddress(TransferUserAddressInRequest address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferAuthorizationUserInRequest transferAuthorizationUserInRequest = (TransferAuthorizationUserInRequest)o;
        return Objects.equals(this.legalName, transferAuthorizationUserInRequest.legalName) && Objects.equals(this.phoneNumber, transferAuthorizationUserInRequest.phoneNumber) && Objects.equals(this.emailAddress, transferAuthorizationUserInRequest.emailAddress) && Objects.equals(this.address, transferAuthorizationUserInRequest.address);
    }

    public int hashCode() {
        return Objects.hash(this.legalName, this.phoneNumber, this.emailAddress, this.address);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferAuthorizationUserInRequest {\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

