/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferBalanceType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information about the balance held with Plaid.")
public class TransferBalance {
    public static final String SERIALIZED_NAME_AVAILABLE = "available";
    @SerializedName(value="available")
    private String available;
    public static final String SERIALIZED_NAME_CURRENT = "current";
    @SerializedName(value="current")
    private String current;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TransferBalanceType type;

    public TransferBalance available(String available) {
        this.available = available;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of this balance available for use (decimal string with two digits of precision e.g. \"10.00\").")
    public String getAvailable() {
        return this.available;
    }

    public void setAvailable(String available) {
        this.available = available;
    }

    public TransferBalance current(String current) {
        this.current = current;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The available balance, plus amount of pending funds that in processing (decimal string with two digits of precision e.g. \"10.00\").")
    public String getCurrent() {
        return this.current;
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public TransferBalance type(TransferBalanceType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferBalanceType getType() {
        return this.type;
    }

    public void setType(TransferBalanceType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferBalance transferBalance = (TransferBalance)o;
        return Objects.equals(this.available, transferBalance.available) && Objects.equals(this.current, transferBalance.current) && Objects.equals((Object)this.type, (Object)transferBalance.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.available, this.current, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferBalance {\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    current: ").append(this.toIndentedString(this.current)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

