/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferBalanceType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/balance/get`")
public class TransferBalanceGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_ORIGINATOR_CLIENT_ID = "originator_client_id";
    @SerializedName(value="originator_client_id")
    private String originatorClientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TransferBalanceType type;

    public TransferBalanceGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferBalanceGetRequest originatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Client ID of the end customer.")
    public String getOriginatorClientId() {
        return this.originatorClientId;
    }

    public void setOriginatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
    }

    public TransferBalanceGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferBalanceGetRequest type(TransferBalanceType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferBalanceType getType() {
        return this.type;
    }

    public void setType(TransferBalanceType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferBalanceGetRequest transferBalanceGetRequest = (TransferBalanceGetRequest)o;
        return Objects.equals(this.clientId, transferBalanceGetRequest.clientId) && Objects.equals(this.originatorClientId, transferBalanceGetRequest.originatorClientId) && Objects.equals(this.secret, transferBalanceGetRequest.secret) && Objects.equals((Object)this.type, (Object)transferBalanceGetRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.originatorClientId, this.secret, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferBalanceGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    originatorClientId: ").append(this.toIndentedString(this.originatorClientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

