/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines the response schema for `/transfer/configuration/get`")
public class TransferConfigurationGetResponse {
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_MAX_SINGLE_TRANSFER_AMOUNT = "max_single_transfer_amount";
    @SerializedName(value="max_single_transfer_amount")
    private String maxSingleTransferAmount;
    public static final String SERIALIZED_NAME_MAX_SINGLE_TRANSFER_CREDIT_AMOUNT = "max_single_transfer_credit_amount";
    @SerializedName(value="max_single_transfer_credit_amount")
    private String maxSingleTransferCreditAmount;
    public static final String SERIALIZED_NAME_MAX_SINGLE_TRANSFER_DEBIT_AMOUNT = "max_single_transfer_debit_amount";
    @SerializedName(value="max_single_transfer_debit_amount")
    private String maxSingleTransferDebitAmount;
    public static final String SERIALIZED_NAME_MAX_DAILY_CREDIT_AMOUNT = "max_daily_credit_amount";
    @SerializedName(value="max_daily_credit_amount")
    private String maxDailyCreditAmount;
    public static final String SERIALIZED_NAME_MAX_DAILY_DEBIT_AMOUNT = "max_daily_debit_amount";
    @SerializedName(value="max_daily_debit_amount")
    private String maxDailyDebitAmount;
    public static final String SERIALIZED_NAME_MAX_MONTHLY_AMOUNT = "max_monthly_amount";
    @SerializedName(value="max_monthly_amount")
    private String maxMonthlyAmount;
    public static final String SERIALIZED_NAME_MAX_MONTHLY_CREDIT_AMOUNT = "max_monthly_credit_amount";
    @SerializedName(value="max_monthly_credit_amount")
    private String maxMonthlyCreditAmount;
    public static final String SERIALIZED_NAME_MAX_MONTHLY_DEBIT_AMOUNT = "max_monthly_debit_amount";
    @SerializedName(value="max_monthly_debit_amount")
    private String maxMonthlyDebitAmount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;

    public TransferConfigurationGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public TransferConfigurationGetResponse maxSingleTransferAmount(String maxSingleTransferAmount) {
        this.maxSingleTransferAmount = maxSingleTransferAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The max limit of dollar amount of a single transfer (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMaxSingleTransferAmount() {
        return this.maxSingleTransferAmount;
    }

    public void setMaxSingleTransferAmount(String maxSingleTransferAmount) {
        this.maxSingleTransferAmount = maxSingleTransferAmount;
    }

    public TransferConfigurationGetResponse maxSingleTransferCreditAmount(String maxSingleTransferCreditAmount) {
        this.maxSingleTransferCreditAmount = maxSingleTransferCreditAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The max limit of dollar amount of a single credit transfer (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMaxSingleTransferCreditAmount() {
        return this.maxSingleTransferCreditAmount;
    }

    public void setMaxSingleTransferCreditAmount(String maxSingleTransferCreditAmount) {
        this.maxSingleTransferCreditAmount = maxSingleTransferCreditAmount;
    }

    public TransferConfigurationGetResponse maxSingleTransferDebitAmount(String maxSingleTransferDebitAmount) {
        this.maxSingleTransferDebitAmount = maxSingleTransferDebitAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The max limit of dollar amount of a single debit transfer (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMaxSingleTransferDebitAmount() {
        return this.maxSingleTransferDebitAmount;
    }

    public void setMaxSingleTransferDebitAmount(String maxSingleTransferDebitAmount) {
        this.maxSingleTransferDebitAmount = maxSingleTransferDebitAmount;
    }

    public TransferConfigurationGetResponse maxDailyCreditAmount(String maxDailyCreditAmount) {
        this.maxDailyCreditAmount = maxDailyCreditAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The max limit of sum of dollar amount of credit transfers in last 24 hours (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMaxDailyCreditAmount() {
        return this.maxDailyCreditAmount;
    }

    public void setMaxDailyCreditAmount(String maxDailyCreditAmount) {
        this.maxDailyCreditAmount = maxDailyCreditAmount;
    }

    public TransferConfigurationGetResponse maxDailyDebitAmount(String maxDailyDebitAmount) {
        this.maxDailyDebitAmount = maxDailyDebitAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The max limit of sum of dollar amount of debit transfers in last 24 hours (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMaxDailyDebitAmount() {
        return this.maxDailyDebitAmount;
    }

    public void setMaxDailyDebitAmount(String maxDailyDebitAmount) {
        this.maxDailyDebitAmount = maxDailyDebitAmount;
    }

    public TransferConfigurationGetResponse maxMonthlyAmount(String maxMonthlyAmount) {
        this.maxMonthlyAmount = maxMonthlyAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The max limit of sum of dollar amount of credit and debit transfers in one calendar month (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMaxMonthlyAmount() {
        return this.maxMonthlyAmount;
    }

    public void setMaxMonthlyAmount(String maxMonthlyAmount) {
        this.maxMonthlyAmount = maxMonthlyAmount;
    }

    public TransferConfigurationGetResponse maxMonthlyCreditAmount(String maxMonthlyCreditAmount) {
        this.maxMonthlyCreditAmount = maxMonthlyCreditAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The max limit of sum of dollar amount of credit transfers in one calendar month (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMaxMonthlyCreditAmount() {
        return this.maxMonthlyCreditAmount;
    }

    public void setMaxMonthlyCreditAmount(String maxMonthlyCreditAmount) {
        this.maxMonthlyCreditAmount = maxMonthlyCreditAmount;
    }

    public TransferConfigurationGetResponse maxMonthlyDebitAmount(String maxMonthlyDebitAmount) {
        this.maxMonthlyDebitAmount = maxMonthlyDebitAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The max limit of sum of dollar amount of debit transfers in one calendar month (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMaxMonthlyDebitAmount() {
        return this.maxMonthlyDebitAmount;
    }

    public void setMaxMonthlyDebitAmount(String maxMonthlyDebitAmount) {
        this.maxMonthlyDebitAmount = maxMonthlyDebitAmount;
    }

    public TransferConfigurationGetResponse isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the dollar amount, e.g. \"USD\".")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferConfigurationGetResponse transferConfigurationGetResponse = (TransferConfigurationGetResponse)o;
        return Objects.equals(this.requestId, transferConfigurationGetResponse.requestId) && Objects.equals(this.maxSingleTransferAmount, transferConfigurationGetResponse.maxSingleTransferAmount) && Objects.equals(this.maxSingleTransferCreditAmount, transferConfigurationGetResponse.maxSingleTransferCreditAmount) && Objects.equals(this.maxSingleTransferDebitAmount, transferConfigurationGetResponse.maxSingleTransferDebitAmount) && Objects.equals(this.maxDailyCreditAmount, transferConfigurationGetResponse.maxDailyCreditAmount) && Objects.equals(this.maxDailyDebitAmount, transferConfigurationGetResponse.maxDailyDebitAmount) && Objects.equals(this.maxMonthlyAmount, transferConfigurationGetResponse.maxMonthlyAmount) && Objects.equals(this.maxMonthlyCreditAmount, transferConfigurationGetResponse.maxMonthlyCreditAmount) && Objects.equals(this.maxMonthlyDebitAmount, transferConfigurationGetResponse.maxMonthlyDebitAmount) && Objects.equals(this.isoCurrencyCode, transferConfigurationGetResponse.isoCurrencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.maxSingleTransferAmount, this.maxSingleTransferCreditAmount, this.maxSingleTransferDebitAmount, this.maxDailyCreditAmount, this.maxDailyDebitAmount, this.maxMonthlyAmount, this.maxMonthlyCreditAmount, this.maxMonthlyDebitAmount, this.isoCurrencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferConfigurationGetResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    maxSingleTransferAmount: ").append(this.toIndentedString(this.maxSingleTransferAmount)).append("\n");
        sb.append("    maxSingleTransferCreditAmount: ").append(this.toIndentedString(this.maxSingleTransferCreditAmount)).append("\n");
        sb.append("    maxSingleTransferDebitAmount: ").append(this.toIndentedString(this.maxSingleTransferDebitAmount)).append("\n");
        sb.append("    maxDailyCreditAmount: ").append(this.toIndentedString(this.maxDailyCreditAmount)).append("\n");
        sb.append("    maxDailyDebitAmount: ").append(this.toIndentedString(this.maxDailyDebitAmount)).append("\n");
        sb.append("    maxMonthlyAmount: ").append(this.toIndentedString(this.maxMonthlyAmount)).append("\n");
        sb.append("    maxMonthlyCreditAmount: ").append(this.toIndentedString(this.maxMonthlyCreditAmount)).append("\n");
        sb.append("    maxMonthlyDebitAmount: ").append(this.toIndentedString(this.maxMonthlyDebitAmount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

